/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.chm;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;

public class SelectableConcurrentHashMap {
    protected static final Element DUMMY_PINNED_ELEMENT = new Element(new DummyPinnedKey(), new DummyPinnedValue());
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MAX_SEGMENTS = 65536;
    private static final int RETRIES_BEFORE_LOCK = 2;
    private final int segmentMask;
    private final int segmentShift;
    private final Segment[] segments;
    private final Random rndm = new Random();
    private final PoolAccessor poolAccessor;
    private final boolean elementPinningEnabled;
    private volatile long maxSize;
    private volatile PinnedKeySet pinnedKeySet;
    private final RegisteredEventListeners cacheEventNotificationService;
    private Set<Object> keySet;
    private Set<Map.Entry<Object, Element>> entrySet;
    private Collection<Element> values;

    public SelectableConcurrentHashMap(PoolAccessor poolAccessor, boolean elementPinningEnabled, int concurrency, long maximumSize, RegisteredEventListeners cacheEventNotificationService) {
        this(poolAccessor, elementPinningEnabled, 16, 0.75f, concurrency, maximumSize, cacheEventNotificationService);
    }

    public SelectableConcurrentHashMap(PoolAccessor poolAccessor, boolean elementPinningEnabled, int initialCapacity, float loadFactor, int concurrency, long maximumSize, RegisteredEventListeners cacheEventNotificationService) {
        int cap;
        int c2;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrency <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrency > 65536) {
            concurrency = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrency; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = new Segment[ssize];
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c2 = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c2;
        }
        for (cap = 1; cap < c2; cap <<= 1) {
        }
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2] = this.createSegment(cap, loadFactor);
        }
        this.poolAccessor = poolAccessor;
        this.elementPinningEnabled = elementPinningEnabled;
        this.maxSize = maximumSize;
        this.cacheEventNotificationService = cacheEventNotificationService;
        this.pinnedKeySet = new PinnedKeySet();
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public Element[] getRandomValues(int size, Object keyHint) {
        ArrayList<Element> sampled = new ArrayList<Element>(size * 2);
        int randomHash = this.rndm.nextInt();
        int segmentStart = keyHint == null ? randomHash >>> this.segmentShift & this.segmentMask : SelectableConcurrentHashMap.hash(keyHint.hashCode()) >>> this.segmentShift & this.segmentMask;
        int segmentIndex = segmentStart;
        do {
            int tableStart;
            HashEntry[] table = this.segments[segmentIndex].table;
            int tableIndex = tableStart = randomHash & table.length - 1;
            do {
                HashEntry e2 = table[tableIndex];
                while (e2 != null) {
                    Element value = e2.value;
                    if (!(value == null || e2.pinned && this.elementPinningEnabled && !value.isExpired())) {
                        sampled.add(value);
                    }
                    e2 = e2.next;
                }
                if (sampled.size() < size) continue;
                return sampled.toArray(new Element[sampled.size()]);
            } while ((tableIndex = tableIndex + 1 & table.length - 1) != tableStart);
        } while ((segmentIndex = segmentIndex + 1 & this.segmentMask) != segmentStart);
        return sampled.toArray(new Element[sampled.size()]);
    }

    public Object storedObject(Element e2) {
        return new HashEntry(null, 0, null, e2, 0L, false);
    }

    public int quickSize() {
        Segment[] segments = this.segments;
        long sum = 0L;
        for (Segment seg : segments) {
            sum += (long)(seg.count - seg.numDummyPinnedKeys);
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public boolean isEmpty() {
        int i2;
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i2 = 0; i2 < segments.length; ++i2) {
            if (segments[i2].count != 0) {
                return false;
            }
            mc[i2] = segments[i2].modCount;
            mcsum += mc[i2];
        }
        if (mcsum != 0) {
            for (i2 = 0; i2 < segments.length; ++i2) {
                if (segments[i2].count == 0 && mc[i2] == segments[i2].modCount) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int i2;
        Segment[] segments = this.segments;
        for (int k2 = 0; k2 < 2; ++k2) {
            int i3;
            int[] mc = new int[segments.length];
            long check = 0L;
            long sum = 0L;
            int mcsum = 0;
            for (i3 = 0; i3 < segments.length; ++i3) {
                sum += (long)(segments[i3].count - segments[i3].numDummyPinnedKeys);
                mc[i3] = segments[i3].modCount;
                mcsum += mc[i3];
            }
            if (mcsum != 0) {
                for (i3 = 0; i3 < segments.length; ++i3) {
                    check += (long)(segments[i3].count - segments[i3].numDummyPinnedKeys);
                    if (mc[i3] == segments[i3].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check != sum) continue;
            if (sum > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)sum;
        }
        long sum = 0L;
        for (i2 = 0; i2 < segments.length; ++i2) {
            segments[i2].readLock().lock();
        }
        try {
            for (i2 = 0; i2 < segments.length; ++i2) {
                sum += (long)(segments[i2].count - segments[i2].numDummyPinnedKeys);
            }
        }
        finally {
            for (i2 = 0; i2 < segments.length; ++i2) {
                segments[i2].readLock().unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pinnedSize() {
        int i2;
        Segment[] segments = this.segments;
        for (int k2 = 0; k2 < 2; ++k2) {
            int i3;
            int[] mc = new int[segments.length];
            long check = 0L;
            long sum = 0L;
            int mcsum = 0;
            for (i3 = 0; i3 < segments.length; ++i3) {
                sum += (long)(segments[i3].pinnedCount - segments[i3].numDummyPinnedKeys);
                mc[i3] = segments[i3].modCount;
                mcsum += mc[i3];
            }
            if (mcsum != 0) {
                for (i3 = 0; i3 < segments.length; ++i3) {
                    check += (long)(segments[i3].pinnedCount - segments[i3].numDummyPinnedKeys);
                    if (mc[i3] == segments[i3].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check != sum) continue;
            if (sum > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)sum;
        }
        long sum = 0L;
        for (i2 = 0; i2 < segments.length; ++i2) {
            segments[i2].readLock().lock();
        }
        try {
            for (i2 = 0; i2 < segments.length; ++i2) {
                sum += (long)(segments[i2].pinnedCount - segments[i2].numDummyPinnedKeys);
            }
        }
        finally {
            for (i2 = 0; i2 < segments.length; ++i2) {
                segments[i2].readLock().unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public ReentrantReadWriteLock lockFor(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash);
    }

    public ReentrantReadWriteLock[] locks() {
        return this.segments;
    }

    public Element get(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).get(key, hash);
    }

    public boolean containsKey(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        int i2;
        if (value == null) {
            throw new NullPointerException();
        }
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k2 = 0; k2 < 2; ++k2) {
            boolean sum = false;
            int mcsum = 0;
            for (int i3 = 0; i3 < segments.length; ++i3) {
                int c2 = segments[i3].count;
                mc[i3] = segments[i3].modCount;
                mcsum += mc[i3];
                if (!segments[i3].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i4 = 0; i4 < segments.length; ++i4) {
                    int c3 = segments[i4].count;
                    if (mc[i4] == segments[i4].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (i2 = 0; i2 < segments.length; ++i2) {
            segments[i2].readLock().lock();
        }
        try {
            for (i2 = 0; i2 < segments.length; ++i2) {
                if (!segments[i2].containsValue(value)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            for (int i5 = 0; i5 < segments.length; ++i5) {
                segments[i5].readLock().unlock();
            }
        }
        return false;
    }

    public Element put(Object key, Element element, long sizeOf) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, element, sizeOf, false, false, true);
    }

    public Element putIfAbsent(Object key, Element element, long sizeOf) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, element, sizeOf, true, false, true);
    }

    public Element remove(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, null);
    }

    public boolean remove(Object key, Object value) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        if (value == null) {
            return false;
        }
        return this.segmentFor(hash).remove(key, hash, value) != null;
    }

    public void clear() {
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].clear();
        }
    }

    public void unpinAll() {
        for (Segment segment : this.segments) {
            segment.unpinAll();
        }
    }

    public void setPinned(Object key, boolean pinned) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        this.segmentFor(hash).setPinned(key, pinned, hash);
    }

    public boolean isPinned(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).isPinned(key, hash);
    }

    public Set<Object> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection<Element> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set<Map.Entry<Object, Element>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    protected Segment createSegment(int initialCapacity, float lf) {
        return new Segment(initialCapacity, lf);
    }

    public boolean evict() {
        return this.getRandomSegment().evict();
    }

    private Segment getRandomSegment() {
        int randomHash = this.rndm.nextInt();
        return this.segments[randomHash >>> this.segmentShift & this.segmentMask];
    }

    public void recalculateSize(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        this.segmentFor(hash).recalculateSize(key, hash);
    }

    public Set pinnedKeySet() {
        PinnedKeySet pks = this.pinnedKeySet;
        return pks != null ? pks : (this.pinnedKeySet = new PinnedKeySet());
    }

    protected final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    protected final List<Segment> segments() {
        return Collections.unmodifiableList(Arrays.asList(this.segments));
    }

    protected static int hash(int h2) {
        h2 += h2 << 15 ^ 0xFFFFCD7D;
        h2 ^= h2 >>> 10;
        h2 += h2 << 3;
        h2 ^= h2 >>> 6;
        h2 += (h2 << 2) + (h2 << 14);
        return h2 ^ h2 >>> 16;
    }

    private class PinnedKeyIterator
    extends KeyIterator {
        private PinnedKeyIterator() {
        }

        @Override
        protected boolean hideValue(HashEntry hashEntry) {
            return super.hideValue(hashEntry) || !hashEntry.pinned;
        }
    }

    private class PinnedKeySet
    extends AbstractSet<Object> {
        private PinnedKeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new PinnedKeyIterator();
        }

        @Override
        public int size() {
            return SelectableConcurrentHashMap.this.pinnedSize();
        }

        @Override
        public boolean contains(Object o2) {
            return SelectableConcurrentHashMap.this.isPinned(o2) && SelectableConcurrentHashMap.this.containsKey(o2);
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry[] currentTable;
        HashEntry nextEntry;
        HashEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = SelectableConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = SelectableConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j2 = this.currentTable.length - 1; j2 >= 0; --j2) {
                    this.nextEntry = this.currentTable[j2];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j2 - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            SelectableConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    abstract class HashEntryIterator
    extends HashIterator {
        private HashEntry myNextEntry = this.advanceToNextEntry();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }

        @Override
        public HashEntry nextEntry() {
            if (this.myNextEntry == null) {
                throw new NoSuchElementException();
            }
            HashEntry entry = this.myNextEntry;
            this.myNextEntry = this.advanceToNextEntry();
            return entry;
        }

        @Override
        public boolean hasNext() {
            return this.myNextEntry != null;
        }

        private HashEntry advanceToNextEntry() {
            HashEntry myEntry = null;
            while (super.hasNext() && ((myEntry = super.nextEntry()) == null || this.hideValue(myEntry))) {
                myEntry = null;
            }
            return myEntry;
        }

        protected boolean hideValue(HashEntry hashEntry) {
            return hashEntry.value == DUMMY_PINNED_ELEMENT;
        }
    }

    final class EntryIterator
    extends HashEntryIterator
    implements Iterator<Map.Entry<Object, Element>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<Object, Element> next() {
            HashEntry entry = this.nextEntry();
            final Object key = entry.key;
            final Element value = entry.value;
            return new Map.Entry<Object, Element>(){

                @Override
                public Object getKey() {
                    return key;
                }

                @Override
                public Element getValue() {
                    return value;
                }

                @Override
                public Element setValue(Element value2) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    final class ValueIterator
    extends HashEntryIterator
    implements Iterator<Element> {
        ValueIterator() {
        }

        @Override
        public Element next() {
            return this.nextEntry().value;
        }
    }

    class KeyIterator
    extends HashEntryIterator
    implements Iterator<Object> {
        KeyIterator() {
        }

        @Override
        public Object next() {
            return this.nextEntry().key;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<Object, Element>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Object, Element>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return SelectableConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SelectableConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Element v2 = SelectableConcurrentHashMap.this.get(e2.getKey());
            return v2 != null && v2.equals(e2.getValue());
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return SelectableConcurrentHashMap.this.remove(e2.getKey(), e2.getValue());
        }

        @Override
        public void clear() {
            SelectableConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<Map.Entry<Object, Element>> c2 = new ArrayList<Map.Entry<Object, Element>>();
            for (Map.Entry<Object, Element> object : this) {
                c2.add(object);
            }
            return c2.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            ArrayList<Map.Entry<Object, Element>> c2 = new ArrayList<Map.Entry<Object, Element>>();
            for (Map.Entry<Object, Element> object : this) {
                c2.add(object);
            }
            return c2.toArray(a2);
        }
    }

    final class Values
    extends AbstractCollection<Element> {
        Values() {
        }

        @Override
        public Iterator<Element> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return SelectableConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SelectableConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return SelectableConcurrentHashMap.this.containsValue(o2);
        }

        @Override
        public void clear() {
            SelectableConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<Element> c2 = new ArrayList<Element>();
            for (Element object : this) {
                c2.add(object);
            }
            return c2.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            ArrayList<Element> c2 = new ArrayList<Element>();
            for (Element object : this) {
                c2.add(object);
            }
            return c2.toArray(a2);
        }
    }

    final class KeySet
    extends AbstractSet<Object> {
        KeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return SelectableConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SelectableConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return SelectableConcurrentHashMap.this.containsKey(o2);
        }

        @Override
        public boolean remove(Object o2) {
            return SelectableConcurrentHashMap.this.remove(o2) != null;
        }

        @Override
        public void clear() {
            SelectableConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<Object> c2 = new ArrayList<Object>();
            for (Object object : this) {
                c2.add(object);
            }
            return c2.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            ArrayList<Object> c2 = new ArrayList<Object>();
            for (Object object : this) {
                c2.add(object);
            }
            return c2.toArray(a2);
        }
    }

    @IgnoreSizeOf
    protected static class DummyPinnedValue
    implements Serializable {
        protected DummyPinnedValue() {
        }
    }

    @IgnoreSizeOf
    protected static class DummyPinnedKey
    implements Serializable {
        protected DummyPinnedKey() {
        }
    }

    static class SegmentIterator
    implements Iterator<HashEntry> {
        int nextTableIndex = -1;
        HashEntry[] currentTable;
        HashEntry nextEntry;
        private final Segment seg;

        private SegmentIterator(Segment memoryStoreSegment) {
            this.seg = memoryStoreSegment;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public HashEntry next() {
            if (this.nextEntry == null) {
                return null;
            }
            HashEntry lastReturned = this.nextEntry;
            this.advance();
            return lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            if (this.seg.count != 0) {
                this.currentTable = this.seg.table;
                for (int j2 = this.currentTable.length - 1; j2 >= 0; --j2) {
                    this.nextEntry = this.currentTable[j2];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j2 - 1;
                    return;
                }
            }
        }
    }

    public static class HashEntry {
        public final Object key;
        public final int hash;
        public final HashEntry next;
        public volatile Element value;
        public volatile boolean pinned;
        public volatile long sizeOf;
        public volatile boolean accessed = true;

        protected HashEntry(Object key, int hash, HashEntry next, Element value, long sizeOf, boolean pinned) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
            this.sizeOf = sizeOf;
            this.pinned = pinned;
        }

        boolean checkAndAssertDummyPinnedEntry() {
            if (this.value == DUMMY_PINNED_ELEMENT && !this.pinned) {
                throw new IllegalStateException("HashEntry value is DUMMY_PINNED_ELEMENT but pinned " + this.pinned);
            }
            return this.value == DUMMY_PINNED_ELEMENT;
        }
    }

    public class Segment
    extends ReentrantReadWriteLock {
        private static final int MAX_EVICTION = 5;
        protected volatile int count;
        int modCount;
        int threshold;
        protected volatile HashEntry[] table;
        final float loadFactor;
        private Iterator<HashEntry> evictionIterator;
        private boolean fullyPinned;
        protected volatile int pinnedCount;
        protected volatile int numDummyPinnedKeys;

        protected Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(new HashEntry[initialCapacity]);
        }

        protected void preRemove(HashEntry e2) {
        }

        protected void postInstall(Object key, Element value, boolean pinned) {
        }

        void setTable(HashEntry[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        protected HashEntry getFirst(int hash) {
            HashEntry[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPinned(Object key, boolean pinned, int hash) {
            this.writeLock().lock();
            try {
                HashEntry e2 = this.getFirst(hash);
                while (!(e2 == null || e2.hash == hash && key.equals(e2.key))) {
                    e2 = e2.next;
                }
                if (e2 != null) {
                    if (pinned && !e2.pinned) {
                        ++this.pinnedCount;
                        e2.pinned = true;
                        this.postInstall(e2.key, e2.value, true);
                    } else if (!pinned && e2.pinned) {
                        --this.pinnedCount;
                        if (!e2.checkAndAssertDummyPinnedEntry()) {
                            e2.pinned = false;
                            this.postInstall(e2.key, e2.value, false);
                        } else {
                            HashEntry[] tab = this.table;
                            int index = hash & tab.length - 1;
                            HashEntry first = tab[index];
                            tab[index] = this.removeAndGetFirst(e2, first);
                            --this.count;
                            --this.numDummyPinnedKeys;
                            ++this.modCount;
                        }
                    }
                } else if (pinned) {
                    this.put(key, hash, DUMMY_PINNED_ELEMENT, 0L, false, true, true);
                    ++this.pinnedCount;
                    ++this.numDummyPinnedKeys;
                }
            }
            finally {
                this.writeLock().unlock();
            }
        }

        private HashEntry removeAndGetFirst(HashEntry e2, HashEntry first) {
            this.preRemove(e2);
            HashEntry newFirst = e2.next;
            HashEntry p2 = first;
            while (p2 != e2) {
                newFirst = this.relinkHashEntry(p2, newFirst);
                p2 = p2.next;
            }
            return newFirst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPinned(Object key, int hash) {
            this.readLock().lock();
            try {
                HashEntry e2 = this.getFirst(hash);
                while (!(e2 == null || e2.hash == hash && key.equals(e2.key))) {
                    e2 = e2.next;
                }
                if (e2 != null) {
                    boolean bl = e2.pinned;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unpinAll() {
            this.writeLock().lock();
            try {
                if (this.numDummyPinnedKeys == this.count) {
                    this.clear();
                    return;
                }
                int numVisited = 0;
                int dummyPinnedKeys = 0;
                for (int i2 = 0; i2 < this.table.length && numVisited < this.count; ++i2) {
                    HashEntry newFirst = null;
                    HashEntry current = this.table[i2];
                    while (current != null && numVisited < this.count) {
                        if (!current.checkAndAssertDummyPinnedEntry()) {
                            current.pinned = false;
                            newFirst = this.relinkHashEntry(current, newFirst);
                        } else {
                            this.preRemove(current);
                            ++dummyPinnedKeys;
                        }
                        ++numVisited;
                        current = current.next;
                    }
                    this.table[i2] = newFirst;
                }
                if (this.numDummyPinnedKeys != dummyPinnedKeys) {
                    throw new IllegalStateException("numDummyPinnedKeys " + this.numDummyPinnedKeys + " but dummyPinnedKeys " + dummyPinnedKeys);
                }
                if (dummyPinnedKeys > 0) {
                    this.count -= dummyPinnedKeys;
                    ++this.modCount;
                }
                this.numDummyPinnedKeys = 0;
                this.pinnedCount = 0;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        protected HashEntry createHashEntry(Object key, int hash, HashEntry next, Element value, long sizeOf, boolean pinned) {
            return new HashEntry(key, hash, next, value, sizeOf, pinned);
        }

        protected HashEntry relinkHashEntry(HashEntry e2, HashEntry next) {
            return new HashEntry(e2.key, e2.hash, next, e2.value, e2.sizeOf, e2.pinned);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clear() {
            this.writeLock().lock();
            try {
                if (this.count != 0) {
                    HashEntry[] tab = this.table;
                    for (int i2 = 0; i2 < tab.length; ++i2) {
                        tab[i2] = null;
                    }
                    ++this.modCount;
                    this.numDummyPinnedKeys = 0;
                    this.pinnedCount = 0;
                    this.count = 0;
                }
                this.evictionIterator = null;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Element remove(Object key, int hash, Object value) {
            this.writeLock().lock();
            try {
                HashEntry first;
                int c2 = this.count - 1;
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e2 = first = tab[index];
                while (!(e2 == null || e2.hash == hash && key.equals(e2.key))) {
                    e2 = e2.next;
                }
                Element oldValue = null;
                if (e2 != null) {
                    Element v2 = e2.value;
                    if (value == null || value.equals(v2)) {
                        oldValue = v2;
                        ++this.modCount;
                        if (!e2.pinned) {
                            tab[index] = this.removeAndGetFirst(e2, first);
                        } else {
                            ++c2;
                            if (oldValue == DUMMY_PINNED_ELEMENT) {
                                oldValue = null;
                            } else {
                                this.preRemove(e2);
                                e2.value = DUMMY_PINNED_ELEMENT;
                                e2.accessed = true;
                                ++this.numDummyPinnedKeys;
                            }
                        }
                        this.count = c2;
                        SelectableConcurrentHashMap.this.poolAccessor.delete(e2.sizeOf);
                        if (this.evictionIterator != null && ((SegmentIterator)this.evictionIterator).nextEntry == e2) {
                            this.evictionIterator.next();
                        }
                    }
                }
                Element element = oldValue;
                return element;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recalculateSize(Object key, int hash) {
            Element value = null;
            long oldSize = 0L;
            this.readLock().lock();
            try {
                HashEntry first;
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e2 = first = tab[index];
                while (!(e2 == null || e2.hash == hash && key.equals(e2.key))) {
                    e2 = e2.next;
                }
                if (e2 != null) {
                    key = e2.key;
                    value = e2.value;
                    oldSize = e2.sizeOf;
                }
            }
            finally {
                this.readLock().unlock();
            }
            if (value != null) {
                long delta = SelectableConcurrentHashMap.this.poolAccessor.replace(oldSize, key, value, SelectableConcurrentHashMap.this.storedObject(value), true);
                this.writeLock().lock();
                try {
                    HashEntry e3 = this.getFirst(hash);
                    while (e3 != null && key != e3.key) {
                        e3 = e3.next;
                    }
                    if (e3 != null && e3.value == value && oldSize == e3.sizeOf) {
                        e3.sizeOf = oldSize + delta;
                    } else {
                        SelectableConcurrentHashMap.this.poolAccessor.delete(delta);
                    }
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Element put(Object key, int hash, Element value, long sizeOf, boolean onlyIfAbsent, boolean pinned, boolean fire) {
            Element[] evicted = new Element[5];
            this.writeLock().lock();
            try {
                Element oldValue;
                HashEntry first;
                int c2 = this.count;
                if (c2++ > this.threshold) {
                    this.rehash();
                }
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e2 = first = tab[index];
                while (!(e2 == null || e2.hash == hash && key.equals(e2.key))) {
                    e2 = e2.next;
                }
                if (e2 != null) {
                    oldValue = e2.value;
                    if (e2.value == DUMMY_PINNED_ELEMENT || !onlyIfAbsent) {
                        SelectableConcurrentHashMap.this.poolAccessor.delete(e2.sizeOf);
                        e2.value = value;
                        e2.sizeOf = sizeOf;
                        if (oldValue == DUMMY_PINNED_ELEMENT && value != DUMMY_PINNED_ELEMENT) {
                            --this.numDummyPinnedKeys;
                            oldValue = null;
                        }
                        if (fire) {
                            this.postInstall(key, value, e2.pinned);
                        }
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = this.createHashEntry(key, hash, first, value, sizeOf, pinned);
                    this.count = c2;
                    if (fire) {
                        this.postInstall(key, value, pinned);
                    }
                }
                if (!pinned && (onlyIfAbsent && oldValue != null || !onlyIfAbsent)) {
                    if (!this.isPinned(key, hash)) {
                        this.fullyPinned = false;
                    }
                    if (!this.fullyPinned && SelectableConcurrentHashMap.this.maxSize > 0L) {
                        int runs = Math.min(5, SelectableConcurrentHashMap.this.quickSize() - (int)SelectableConcurrentHashMap.this.maxSize);
                        while (runs-- > 0) {
                            Element removed;
                            Element evict = this.nextExpiredOrToEvict(value);
                            if (evict == null) continue;
                            while ((removed = this.remove(evict.getKey(), SelectableConcurrentHashMap.hash(evict.getKey().hashCode()), null)) == null && (evict = this.nextExpiredOrToEvict(value)) != null) {
                            }
                            evicted[runs] = removed;
                        }
                    }
                }
                Element element = oldValue;
                return element;
            }
            finally {
                this.writeLock().unlock();
                for (Element element : evicted) {
                    this.notifyEvictionOrExpiry(element);
                }
            }
        }

        private void notifyEvictionOrExpiry(Element element) {
            if (element != null && SelectableConcurrentHashMap.this.cacheEventNotificationService != null) {
                if (element.isExpired()) {
                    SelectableConcurrentHashMap.this.cacheEventNotificationService.notifyElementExpiry(element, false);
                } else {
                    SelectableConcurrentHashMap.this.cacheEventNotificationService.notifyElementEvicted(element, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Element get(Object key, int hash) {
            this.readLock().lock();
            try {
                if (this.count != 0) {
                    HashEntry e2 = this.getFirst(hash);
                    while (e2 != null) {
                        if (e2.hash == hash && key.equals(e2.key) && !e2.value.equals(DUMMY_PINNED_ELEMENT)) {
                            e2.accessed = true;
                            Element element = e2.value;
                            return element;
                        }
                        e2 = e2.next;
                    }
                }
                Element element = null;
                return element;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean containsKey(Object key, int hash) {
            this.readLock().lock();
            try {
                if (this.count != 0) {
                    HashEntry e2 = this.getFirst(hash);
                    while (e2 != null) {
                        if (e2.hash == hash && key.equals(e2.key) && !e2.value.equals(DUMMY_PINNED_ELEMENT)) {
                            boolean bl = true;
                            return bl;
                        }
                        e2 = e2.next;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean containsValue(Object value) {
            this.readLock().lock();
            try {
                if (this.count != 0) {
                    for (HashEntry e2 : this.table) {
                        while (e2 != null) {
                            Element v2 = e2.value;
                            if (value.equals(v2)) {
                                boolean bl = true;
                                return bl;
                            }
                            e2 = e2.next;
                        }
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.readLock().unlock();
            }
        }

        private Element nextExpiredOrToEvict(Element justAdded) {
            Element lastUnpinned = null;
            int i2 = 0;
            while (!this.fullyPinned && i2++ < this.count) {
                if (this.evictionIterator == null || !this.evictionIterator.hasNext()) {
                    this.evictionIterator = this.iterator();
                }
                HashEntry next = this.evictionIterator.next();
                if (next.value.isExpired() || !next.accessed) {
                    return next.value;
                }
                boolean pinned = next.pinned;
                if (!pinned && next.value != justAdded) {
                    lastUnpinned = next.value;
                }
                next.accessed = pinned;
            }
            this.fullyPinned = !this.fullyPinned && i2 >= this.count && lastUnpinned == null;
            return lastUnpinned;
        }

        protected Iterator<HashEntry> iterator() {
            return new SegmentIterator(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean evict() {
            Element remove = null;
            this.writeLock().lock();
            try {
                Element evict = this.nextExpiredOrToEvict(null);
                if (evict != null) {
                    remove = this.remove(evict.getKey(), SelectableConcurrentHashMap.hash(evict.getKey().hashCode()), null);
                }
            }
            finally {
                this.writeLock().unlock();
            }
            this.notifyEvictionOrExpiry(remove);
            return remove != null;
        }

        void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = new HashEntry[oldCapacity << 1];
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i2 = 0; i2 < oldCapacity; ++i2) {
                int k2;
                HashEntry e2 = oldTable[i2];
                if (e2 == null) continue;
                HashEntry next = e2.next;
                int idx = e2.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e2;
                    continue;
                }
                HashEntry lastRun = e2;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k2 = last.hash & sizeMask;
                    if (k2 != lastIdx) {
                        lastIdx = k2;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry p2 = e2;
                while (p2 != lastRun) {
                    k2 = p2.hash & sizeMask;
                    HashEntry n2 = newTable[k2];
                    newTable[k2] = this.relinkHashEntry(p2, n2);
                    p2 = p2.next;
                }
            }
            this.table = newTable;
            if (this.evictionIterator != null) {
                this.evictionIterator = this.iterator();
            }
        }

        Iterator<HashEntry> getEvictionIterator() {
            return this.evictionIterator;
        }
    }
}

