/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.manager.selector;

import javax.transaction.TransactionManager;
import net.sf.ehcache.transaction.manager.selector.Selector;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassSelector
extends Selector {
    private static final Logger LOG = LoggerFactory.getLogger(ClassSelector.class);
    private final String classname;

    public ClassSelector(String vendor, String classname) {
        super(vendor);
        this.classname = classname;
    }

    @Override
    protected TransactionManager doLookup() {
        TransactionManager transactionManager = null;
        try {
            Class txManagerClass = ClassLoaderUtil.loadClass(this.classname);
            transactionManager = (TransactionManager)txManagerClass.newInstance();
        }
        catch (ClassNotFoundException e2) {
            LOG.debug("FactorySelector failed lookup", e2);
        }
        catch (InstantiationException e3) {
            LOG.debug("FactorySelector failed lookup", e3);
        }
        catch (IllegalAccessException e4) {
            LOG.debug("FactorySelector failed lookup", e4);
        }
        return transactionManager;
    }
}

