/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.replay.OracleXADataSourceImpl;
import oracle.jdbc.xa.OracleXAConnectionBuilderImpl;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleXADataSourceConnectionFactoryAdapter
extends XADataSourceConnectionFactoryAdapter {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    public OracleXADataSourceConnectionFactoryAdapter(XADataSource xaDataSource) throws UniversalConnectionPoolException {
        super(xaDataSource);
        this.initializeUrlFromConnectionFactory();
    }

    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        XAConnection xaConnection;
        block8: {
            String instanceName = connectionRequestInfo instanceof OracleJDBCConnectionRetrievalInfo ? ((OracleJDBCConnectionRetrievalInfo)connectionRequestInfo).getInstanceName() : null;
            Object ods = null;
            xaConnection = null;
            try {
                if (!(this.m_xaDataSource instanceof OracleXADataSource) && !(this.m_xaDataSource instanceof OracleXADataSourceImpl)) {
                    ClioSupport.ilogFinest(null, null, null, null, "about to create connection without specifying instance");
                    xaConnection = (XAConnection)super.createConnection(connectionRequestInfo);
                    break block8;
                }
                OracleXAConnectionBuilderImpl builder = this.m_xaDataSource instanceof OracleXADataSource ? ((OracleXADataSource)this.m_xaDataSource).createXAConnectionBuilder() : ((OracleXADataSourceImpl)this.m_xaDataSource).createXAConnectionBuilder();
                ClioSupport.ilogFinest(null, null, null, null, "about to create connection to the instance " + instanceName);
                JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
                xaConnection = builder.user(jdbcCri.getUser()).password(jdbcCri.getPassword().get()).instanceName(instanceName).serviceName(jdbcCri.getServiceName()).shardingKey(jdbcCri.getShardingKey()).superShardingKey(jdbcCri.getSuperShardingKey()).build();
                if (null == xaConnection) break block8;
                String val = null;
                try {
                    val = ((OracleConnection)xaConnection.getConnection()).getServerSessionInfo().getProperty("INSTANCE_NAME");
                }
                catch (Throwable e2) {
                    ClioSupport.ilogFinest(null, null, null, null, "unable to get named instance connection information");
                }
                if (val != null) {
                    if (instanceName != null && !"".equals(instanceName) && !Util.equalsNormalized(instanceName, val)) {
                        ClioSupport.ilogFinest(null, null, null, null, "wrong named instance connection created");
                    }
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "unable to verify named instance connection creation");
                }
            }
            catch (SQLException e3) {
                ClioSupport.ilogThrowing(null, null, null, null, e3);
                UCPErrorHandler.throwUniversalConnectionPoolException(261, e3);
            }
        }
        return xaConnection;
    }

    @Override
    public UniversalPooledConnection createPooledConnection(Object connection, ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        JDBCConnectionPool jdbccp = (JDBCConnectionPool)this.getUniversalConnectionPool();
        return new OracleUniversalPooledConnection(jdbccp, connection, connectionRequestInfo, jdbccp.isFailoverEnabled());
    }

    @Override
    public void initializeUrlFromConnectionFactory() {
        Class<?> dsClass = this.m_xaDataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
            Method m3 = cls.getMethod("getURL", new Class[0]);
            this.m_url = (String)m3.invoke((Object)this.m_xaDataSource, new Object[0]);
            ClioSupport.ilogFinest(null, null, null, null, "initializeUrlFromConnectionFactory() succeeded");
        }
        catch (Exception exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
    }

    @Override
    public void setUrl(String url) {
        Class<?> dsClass = this.m_xaDataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
            Method m3 = cls.getMethod("setURL", String.class);
            m3.invoke((Object)this.m_xaDataSource, url);
        }
        catch (Exception exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
    }

    static {
        try {
            $$$methodRef$$$4 = OracleXADataSourceConnectionFactoryAdapter.class.getDeclaredConstructor(XADataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = OracleXADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("setUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = OracleXADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("initializeUrlFromConnectionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = OracleXADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createPooledConnection", Object.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = OracleXADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

