/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.oracle;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.jdbc.internal.OracleResultSet;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.ProxyException;
import oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase;
import oracle.ucp.jdbc.proxy.oracle.StatementProxy;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.Chain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
@ProxyFor(value={ResultSet.class, OracleResultSet.class, LogicalObject.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class ResultSetProxy
implements LogicalObject {
    private final long creationTS = Clock.clock();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private Chain.Atom<ResultSetProxy> resultSetChainAtom = null;

    void setResultSetChainAtom(Chain.Atom<ResultSetProxy> atom) {
        this.resultSetChainAtom = atom;
    }

    @GetDelegate
    protected abstract ResultSet getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    private UniversalPooledConnection getUPC() {
        return ((StatementProxy)this.getCreator()).getUPC();
    }

    private UniversalConnectionPool getUCP() {
        return ((StatementProxy)this.getCreator()).getUCP();
    }

    private void throwIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw UCPErrorHandler.newSQLException(43);
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Statement getStatement() throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return (Statement)this.getCreator();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public ResultSet getCursor(int columnIndex) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getCursor(columnIndex);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public ResultSet getCursor(String columnName) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getCursor(columnName);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int columnIndex) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnIndex);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int columnIndex, Class type) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnIndex, type);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int columnIndex, Map map) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnIndex, map);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String columnName) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnName);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String columnName, Class type) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnName, type);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String columnName, Map map) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return ((OracleResultSet)this.getDelegate()).getObject(columnName, map);
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.resultSetChainAtom.remove();
        this.closed.set(true);
        this.getDelegate().close();
    }

    public boolean isClosed() throws SQLException {
        return this.closed.get() || ((Statement)this.getCreator()).isClosed();
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Pre
    @Methods(signatures={@Signature(name="getACProxy", args={}), @Signature(name="setACProxy", args={Object.class})})
    protected void preNoThrow(Method m3, Object receiver, Object ... args) {
        try {
            this.pre(m3, receiver, args);
        }
        catch (SQLException e2) {
            throw new ProxyException(e2);
        }
    }

    @Pre
    protected void pre(Method m3, Object receiver, Object ... args) throws SQLException {
        StatementProxy stmtProxy;
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(43);
        }
        this.getUPC().heartbeat();
        if (Clock.isBefore(this.creationTS, this.getUPC().getAvailableStartTime()) || Clock.isBefore(this.creationTS, this.getUPC().getBorrowedStartTime())) {
            this.closed.set(true);
            ((Statement)this.getCreator()).getConnection().close();
        }
        if ((stmtProxy = (StatementProxy)this.getCreator()).isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        ConnectionProxyBase connProxy = (ConnectionProxyBase)stmtProxy.getCreator();
        if (connProxy.isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(31);
        }
    }

    @OnError(value=SQLException.class)
    protected void onErrorvoid(Method m3, SQLException e2) throws SQLException {
        this.onError(m3, e2);
    }

    @OnError(value=SQLException.class)
    protected Object onError(Method m3, SQLException e2) throws SQLException {
        this.getUPC().heartbeat();
        StatementProxy stmtProxy = (StatementProxy)this.getCreator();
        ConnectionProxyBase connProxy = (ConnectionProxyBase)stmtProxy.getCreator();
        connProxy.handleSQRecoverableException(e2);
        throw e2;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.getUPC().heartbeat();
        if (iface.isInterface()) {
            if (iface.isInstance(this.getDelegate())) {
                return (T)this.getDelegate();
            }
            return this.getDelegate().unwrap(iface);
        }
        throw new SQLException("unable to unwrap interface " + iface.toString());
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof ResultSetProxy ? ((ResultSetProxy)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }
}

