/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.criteria;

import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.kuali.rice.core.api.criteria.CriteriaValue;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@XmlRootElement(name="kualiDecimalValue")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CriteriaKualiDecimalValueType")
public final class CriteriaKualiDecimalValue
implements CriteriaValue<KualiDecimal> {
    @XmlValue
    private final BigDecimal value;

    CriteriaKualiDecimalValue() {
        this.value = null;
    }

    CriteriaKualiDecimalValue(KualiDecimal value) {
        CriteriaKualiDecimalValue.validateValue(value);
        this.value = CriteriaKualiDecimalValue.safeInstance(value).setScale(2);
    }

    CriteriaKualiDecimalValue(double value) {
        CriteriaKualiDecimalValue.validateValue(value);
        this.value = new KualiDecimal(value).bigDecimalValue();
    }

    CriteriaKualiDecimalValue(int value) {
        CriteriaKualiDecimalValue.validateValue(value);
        this.value = new KualiDecimal(value).bigDecimalValue();
    }

    CriteriaKualiDecimalValue(String value) {
        CriteriaKualiDecimalValue.validateValue(value);
        this.value = new KualiDecimal(value).bigDecimalValue();
    }

    CriteriaKualiDecimalValue(BigDecimal value) {
        CriteriaKualiDecimalValue.validateValue(value);
        this.value = new KualiDecimal(value).bigDecimalValue();
    }

    private static void validateValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
    }

    private static BigDecimal safeInstance(KualiDecimal val) {
        return new BigDecimal(val.bigDecimalValue().toPlainString());
    }

    @Override
    public KualiDecimal getValue() {
        return new KualiDecimal(this.value);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(obj, this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "kualiDecimalValue";
        static final String TYPE_NAME = "CriteriaKualiDecimalValueType";

        Constants() {
        }
    }
}

