/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.uif;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.uif.AttributeLookupSettings;
import org.kuali.rice.core.api.uif.ControlCopy;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAbstractWidget;
import org.kuali.rice.core.api.uif.RemotableAttributeFieldContract;
import org.kuali.rice.core.api.uif.RemotableAttributeLookupSettings;
import org.kuali.rice.core.api.uif.RemotableCheckbox;
import org.kuali.rice.core.api.uif.RemotableCheckboxGroup;
import org.kuali.rice.core.api.uif.RemotableControlContract;
import org.kuali.rice.core.api.uif.RemotableDatepicker;
import org.kuali.rice.core.api.uif.RemotableHiddenInput;
import org.kuali.rice.core.api.uif.RemotablePasswordInput;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.uif.RemotableRadioButtonGroup;
import org.kuali.rice.core.api.uif.RemotableSelect;
import org.kuali.rice.core.api.uif.RemotableTextExpand;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.uif.RemotableTextarea;
import org.kuali.rice.core.api.uif.RemotableWidgetContract;
import org.kuali.rice.core.api.uif.WidgetCopy;
import org.w3c.dom.Element;

@XmlRootElement(name="attributeField")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="AttributeFieldType", propOrder={"name", "dataType", "shortLabel", "longLabel", "helpSummary", "constraintText", "helpDescription", "forceUpperCase", "minLength", "maxLength", "minValue", "maxValue", "regexConstraint", "regexContraintMsg", "formatterName", "required", "defaultValues", "attributeLookupSettings", "control", "widgets", "_futureElements"})
public final class RemotableAttributeField
extends AbstractDataTransferObject
implements RemotableAttributeFieldContract {
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlJavaTypeAdapter(value=DataType.Adapter.class)
    @XmlElement(name="dataType", required=false)
    private final String dataType;
    @XmlElement(name="shortLabel", required=false)
    private final String shortLabel;
    @XmlElement(name="longLabel", required=false)
    private final String longLabel;
    @XmlElement(name="helpSummary", required=false)
    private final String helpSummary;
    @XmlElement(name="constraintText", required=false)
    private final String constraintText;
    @XmlElement(name="helpDescription", required=false)
    private final String helpDescription;
    @XmlElement(name="forceUpperCase", required=false)
    private final boolean forceUpperCase;
    @XmlElement(name="minLength", required=false)
    private final Integer minLength;
    @XmlElement(name="maxLength", required=false)
    private final Integer maxLength;
    @XmlElement(name="minValue", required=false)
    private final Double minValue;
    @XmlElement(name="maxValue", required=false)
    private final Double maxValue;
    @XmlElement(name="regexConstraint", required=false)
    private final String regexConstraint;
    @XmlElement(name="regexContraintMsg", required=false)
    private final String regexContraintMsg;
    @XmlElement(name="formatterName", required=false)
    private final String formatterName;
    @XmlElement(name="required", required=false)
    private final boolean required;
    @XmlElementWrapper(name="defaultValues", required=false)
    @XmlElement(name="defaultValue", required=false)
    private final Collection<String> defaultValues;
    @XmlElement(name="attributeLookupSettings", required=false)
    private final RemotableAttributeLookupSettings attributeLookupSettings;
    @XmlElements(value={@XmlElement(name="checkbox", type=RemotableCheckbox.class, required=false), @XmlElement(name="checkboxGroup", type=RemotableCheckboxGroup.class, required=false), @XmlElement(name="hiddenInput", type=RemotableHiddenInput.class, required=false), @XmlElement(name="passwordInput", type=RemotablePasswordInput.class, required=false), @XmlElement(name="radioButtonGroup", type=RemotableRadioButtonGroup.class, required=false), @XmlElement(name="select", type=RemotableSelect.class, required=false), @XmlElement(name="textarea", type=RemotableTextarea.class, required=false), @XmlElement(name="textInput", type=RemotableTextInput.class, required=false)})
    private final RemotableAbstractControl control;
    @XmlElementWrapper(name="widgets", required=false)
    @XmlElements(value={@XmlElement(name="datepicker", type=RemotableDatepicker.class, required=false), @XmlElement(name="quickFinder", type=RemotableQuickFinder.class, required=false), @XmlElement(name="textExpand", type=RemotableTextExpand.class, required=false)})
    private final Collection<? extends RemotableAbstractWidget> widgets;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RemotableAttributeField() {
        this.name = null;
        this.dataType = null;
        this.shortLabel = null;
        this.longLabel = null;
        this.helpSummary = null;
        this.constraintText = null;
        this.helpDescription = null;
        this.forceUpperCase = false;
        this.minLength = null;
        this.maxLength = null;
        this.minValue = null;
        this.maxValue = null;
        this.regexConstraint = null;
        this.regexContraintMsg = null;
        this.formatterName = null;
        this.required = false;
        this.defaultValues = null;
        this.attributeLookupSettings = null;
        this.control = RemotableTextInput.Builder.create().build();
        this.widgets = null;
    }

    private RemotableAttributeField(Builder b2) {
        this.name = b2.name;
        this.dataType = b2.dataType == null ? null : b2.dataType.name();
        this.shortLabel = b2.shortLabel;
        this.longLabel = b2.longLabel;
        this.helpSummary = b2.helpSummary;
        this.constraintText = b2.helpConstraint;
        this.helpDescription = b2.helpDescription;
        this.forceUpperCase = b2.forceUpperCase;
        this.minLength = b2.minLength;
        this.maxLength = b2.maxLength;
        this.minValue = b2.minValue;
        this.maxValue = b2.maxValue;
        this.regexConstraint = b2.regexConstraint;
        this.regexContraintMsg = b2.regexContraintMsg;
        this.formatterName = b2.formatterName;
        this.required = b2.required;
        if (b2.defaultValues == null) {
            this.defaultValues = Collections.emptyList();
        } else {
            ArrayList<String> defaultValuesCopy = new ArrayList<String>(b2.defaultValues);
            this.defaultValues = Collections.unmodifiableList(defaultValuesCopy);
        }
        this.attributeLookupSettings = b2.attributeLookupSettings == null ? null : b2.attributeLookupSettings.build();
        this.control = b2.control == null ? RemotableTextInput.Builder.create().build() : b2.control.build();
        ArrayList<RemotableAbstractWidget> temp = new ArrayList<RemotableAbstractWidget>();
        if (b2.widgets != null) {
            for (RemotableAbstractWidget.Builder attr : b2.widgets) {
                temp.add(attr.build());
            }
        }
        this.widgets = Collections.unmodifiableList(temp);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            return null;
        }
        return DataType.valueOf(this.dataType);
    }

    @Override
    public String getShortLabel() {
        return this.shortLabel;
    }

    @Override
    public String getLongLabel() {
        return this.longLabel;
    }

    @Override
    public String getHelpSummary() {
        return this.helpSummary;
    }

    @Override
    public String getConstraintText() {
        return this.constraintText;
    }

    @Override
    public String getHelpDescription() {
        return this.helpDescription;
    }

    @Override
    public boolean isForceUpperCase() {
        return this.forceUpperCase;
    }

    @Override
    public Integer getMinLength() {
        return this.minLength;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public Double getMinValue() {
        return this.minValue;
    }

    @Override
    public Double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public String getRegexConstraint() {
        return this.regexConstraint;
    }

    @Override
    public String getRegexContraintMsg() {
        return this.regexContraintMsg;
    }

    @Override
    public String getFormatterName() {
        return this.formatterName;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public Collection<String> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    public RemotableControlContract getControl() {
        return this.control;
    }

    public Collection<? extends RemotableAbstractWidget> getWidgets() {
        return this.widgets;
    }

    @Override
    public AttributeLookupSettings getAttributeLookupSettings() {
        return this.attributeLookupSettings;
    }

    public static RemotableAttributeField findAttribute(String attributeName, Collection<RemotableAttributeField> fields) {
        if (StringUtils.isBlank(attributeName)) {
            throw new IllegalArgumentException("attributeName is blank");
        }
        if (fields == null) {
            throw new IllegalArgumentException("errors is null");
        }
        for (RemotableAttributeField field : fields) {
            if (!attributeName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    static final class Elements {
        static final String NAME = "name";
        static final String DATA_TYPE = "dataType";
        static final String SHORT_LABEL = "shortLabel";
        static final String LONG_LABEL = "longLabel";
        static final String HELP_SUMMARY = "helpSummary";
        static final String CONSTRAINT_TEXT = "constraintText";
        static final String HELP_DESCRIPTION = "helpDescription";
        static final String FORCE_UPPERCASE = "forceUpperCase";
        static final String MIN_LENGTH = "minLength";
        static final String MAX_LENGTH = "maxLength";
        static final String MIN_VALUE = "minValue";
        static final String MAX_VALUE = "maxValue";
        static final String REGEX_CONSTRAINT = "regexConstraint";
        static final String REGEX_CONSTRAINT_MSG = "regexContraintMsg";
        static final String FORMATTER_NAME = "formatterName";
        static final String REQUIRED = "required";
        static final String DEFAULT_VALUES = "defaultValues";
        static final String DEFAULT_VALUE = "defaultValue";
        static final String ATTRIBUTE_LOOKUP_SETTINGS = "attributeLookupSettings";
        static final String CONTROL = "control";
        static final String WIDGETS = "widgets";

        Elements() {
        }
    }

    static final class Constants {
        static final String TYPE_NAME = "AttributeFieldType";
        static final String ROOT_ELEMENT_NAME = "attributeField";

        Constants() {
        }
    }

    public static final class Builder
    implements RemotableAttributeFieldContract,
    ModelBuilder {
        private String name;
        private DataType dataType;
        private String shortLabel;
        private String longLabel;
        private String helpSummary;
        private String helpConstraint;
        private String helpDescription;
        private boolean forceUpperCase;
        private Integer minLength;
        private Integer maxLength;
        private Double minValue;
        private Double maxValue;
        private String regexConstraint;
        private String regexContraintMsg;
        private String formatterName;
        private boolean required;
        private Collection<String> defaultValues = new ArrayList<String>();
        private RemotableAttributeLookupSettings.Builder attributeLookupSettings;
        private RemotableAbstractControl.Builder control = RemotableTextInput.Builder.create();
        private Collection<RemotableAbstractWidget.Builder> widgets = new ArrayList<RemotableAbstractWidget.Builder>();

        private Builder(String name) {
            this.setName(name);
        }

        public static Builder create(String name) {
            return new Builder(name);
        }

        public static Builder create(RemotableAttributeFieldContract field) {
            if (field == null) {
                throw new IllegalArgumentException("field was null");
            }
            Builder b2 = new Builder(field.getName());
            b2.setDataType(field.getDataType());
            b2.setShortLabel(field.getShortLabel());
            b2.setLongLabel(field.getLongLabel());
            b2.setHelpSummary(field.getHelpSummary());
            b2.setConstraintText(field.getConstraintText());
            b2.setHelpDescription(field.getHelpDescription());
            b2.setForceUpperCase(field.isForceUpperCase());
            b2.setMinLength(field.getMinLength());
            b2.setMaxLength(field.getMaxLength());
            b2.setMinValue(field.getMinValue());
            b2.setMaxValue(field.getMaxValue());
            b2.setRegexConstraint(field.getRegexConstraint());
            b2.setRegexContraintMsg(field.getRegexContraintMsg());
            b2.setFormatterName(field.getFormatterName());
            b2.setRequired(field.isRequired());
            b2.setDefaultValues(field.getDefaultValues());
            if (field.getAttributeLookupSettings() != null) {
                b2.setAttributeLookupSettings(RemotableAttributeLookupSettings.Builder.create(field.getAttributeLookupSettings()));
            }
            if (field.getControl() != null) {
                b2.setControl(ControlCopy.toBuilder(field.getControl()));
            }
            ArrayList<RemotableAbstractWidget.Builder> temp = new ArrayList<RemotableAbstractWidget.Builder>();
            if (field.getWidgets() != null) {
                for (RemotableWidgetContract remotableWidgetContract : field.getWidgets()) {
                    temp.add(WidgetCopy.toBuilder(remotableWidgetContract));
                }
            }
            b2.setWidgets(temp);
            return b2;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (StringUtils.isBlank(name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        @Override
        public DataType getDataType() {
            return this.dataType;
        }

        public void setDataType(DataType dataType) {
            this.dataType = dataType;
        }

        @Override
        public String getShortLabel() {
            return this.shortLabel;
        }

        public void setShortLabel(String shortLabel) {
            this.shortLabel = shortLabel;
        }

        @Override
        public String getLongLabel() {
            return this.longLabel;
        }

        public void setLongLabel(String longLabel) {
            this.longLabel = longLabel;
        }

        @Override
        public String getHelpSummary() {
            return this.helpSummary;
        }

        public void setHelpSummary(String helpSummary) {
            this.helpSummary = helpSummary;
        }

        @Override
        public String getConstraintText() {
            return this.helpConstraint;
        }

        public void setConstraintText(String helpConstraint) {
            this.helpConstraint = helpConstraint;
        }

        @Override
        public String getHelpDescription() {
            return this.helpDescription;
        }

        public void setHelpDescription(String helpDescription) {
            this.helpDescription = helpDescription;
        }

        @Override
        public boolean isForceUpperCase() {
            return this.forceUpperCase;
        }

        public void setForceUpperCase(boolean forceUpperCase) {
            this.forceUpperCase = forceUpperCase;
        }

        @Override
        public Integer getMinLength() {
            return this.minLength;
        }

        public void setMinLength(Integer minLength) {
            if (minLength != null && minLength < 1) {
                throw new IllegalArgumentException("minLength was < 1");
            }
            this.minLength = minLength;
        }

        @Override
        public Integer getMaxLength() {
            return this.maxLength;
        }

        public void setMaxLength(Integer maxLength) {
            if (maxLength != null && maxLength < 1) {
                throw new IllegalArgumentException("maxLength was < 1");
            }
            this.maxLength = maxLength;
        }

        @Override
        public Double getMinValue() {
            return this.minValue;
        }

        public void setMinValue(Double minValue) {
            this.minValue = minValue;
        }

        @Override
        public Double getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(Double maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public String getRegexConstraint() {
            return this.regexConstraint;
        }

        public void setRegexConstraint(String regexConstraint) {
            this.regexConstraint = regexConstraint;
        }

        @Override
        public String getRegexContraintMsg() {
            return this.regexContraintMsg;
        }

        public void setRegexContraintMsg(String regexContraintMsg) {
            this.regexContraintMsg = regexContraintMsg;
        }

        @Override
        public String getFormatterName() {
            return this.formatterName;
        }

        public void setFormatterName(String formatterName) {
            this.formatterName = formatterName;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        @Override
        public Collection<String> getDefaultValues() {
            return this.defaultValues;
        }

        public void setDefaultValues(Collection<String> defaultValues) {
            this.defaultValues = defaultValues;
        }

        public void addToDefaultValues(String defaultValue) {
            this.defaultValues.add(defaultValue);
        }

        @Override
        public RemotableAttributeLookupSettings.Builder getAttributeLookupSettings() {
            return this.attributeLookupSettings;
        }

        public void setAttributeLookupSettings(RemotableAttributeLookupSettings.Builder attributeLookupSettings) {
            this.attributeLookupSettings = attributeLookupSettings;
        }

        @Override
        public RemotableAbstractControl.Builder getControl() {
            return this.control;
        }

        public void setControl(RemotableAbstractControl.Builder control) {
            this.control = control;
        }

        public Collection<RemotableAbstractWidget.Builder> getWidgets() {
            return this.widgets;
        }

        public void setWidgets(Collection<RemotableAbstractWidget.Builder> widgets) {
            this.widgets = widgets;
        }

        @Override
        public RemotableAttributeField build() {
            return new RemotableAttributeField(this);
        }
    }
}

