/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.kuali.rice.core.api.exception.RiceRuntimeException;

public final class ChecksumUtils {
    public static String calculateChecksum(Object object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(object);
        }
        catch (IOException e2) {
            throw new RiceRuntimeException(e2);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return new String(Base64.encodeBase64(md.digest(bos.toByteArray())), "UTF-8");
        }
        catch (GeneralSecurityException ex) {
            throw new RiceRuntimeException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RiceRuntimeException(ex);
        }
    }

    private ChecksumUtils() {
        throw new UnsupportedOperationException("Should never be executed.");
    }
}

