/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.kuali.rice.core.api.util.cache.CacheException;

public class CopiedObject<T extends Serializable> {
    private byte[] content;
    private int size;
    private int oldSize = -1;

    public CopiedObject() {
    }

    public CopiedObject(T cacheableObject) {
        this.setContent(cacheableObject);
    }

    public int getSize() {
        return this.size;
    }

    public T getContent() {
        Serializable copy = null;
        if (this.content != null) {
            ObjectInputStream ois = null;
            try {
                FastByteArrayInputStream deserializer = new FastByteArrayInputStream(this.content, this.size);
                ois = new ObjectInputStream(deserializer);
                copy = (Serializable)ois.readObject();
            }
            catch (IOException e2) {
                throw new CacheException("unable to complete getContent()", e2);
            }
            catch (ClassNotFoundException e3) {
                throw new CacheException("unable to complete getContent()", e3);
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return (T)copy;
    }

    public void setContent(T cacheableObject) {
        boolean copySize = false;
        if (cacheableObject != null) {
            ObjectOutputStream oos = null;
            try {
                FastByteArrayOutputStream serializer = new FastByteArrayOutputStream();
                oos = new ObjectOutputStream(serializer);
                oos.writeObject(cacheableObject);
                if (this.content != null) {
                    this.oldSize = this.size;
                }
                this.size = serializer.getSize();
                this.content = serializer.getByteArray();
            }
            catch (IOException e2) {
                throw new CacheException("unable to complete deepCopy from src '" + cacheableObject.toString() + "'", e2);
            }
            finally {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public int getOldSize() {
        return this.oldSize;
    }

    private static class FastByteArrayInputStream
    extends InputStream {
        protected byte[] buf = null;
        protected int count = 0;
        protected int pos = 0;

        public FastByteArrayInputStream(byte[] buf, int count) {
            this.buf = buf;
            this.count = count;
        }

        @Override
        public final int available() {
            return this.count - this.pos;
        }

        @Override
        public final int read() {
            return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
        }

        @Override
        public final int read(byte[] b2, int off, int len) {
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + len > this.count) {
                len = this.count - this.pos;
            }
            System.arraycopy(this.buf, this.pos, b2, off, len);
            this.pos += len;
            return len;
        }

        @Override
        public final long skip(long n2) {
            if ((long)this.pos + n2 > (long)this.count) {
                n2 = this.count - this.pos;
            }
            if (n2 < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + n2);
            return n2;
        }
    }

    private static class FastByteArrayOutputStream
    extends OutputStream {
        protected byte[] buf = null;
        protected int size = 0;

        public FastByteArrayOutputStream() {
            this(5120);
        }

        public FastByteArrayOutputStream(int initSize) {
            this.buf = new byte[initSize];
        }

        private void verifyBufferSize(int sz) {
            if (sz > this.buf.length) {
                byte[] old = this.buf;
                this.buf = new byte[Math.max(sz, 2 * this.buf.length)];
                System.arraycopy(old, 0, this.buf, 0, old.length);
                Object var2_2 = null;
            }
        }

        public int getSize() {
            return this.size;
        }

        public byte[] getByteArray() {
            return this.buf;
        }

        @Override
        public final void write(byte[] b2) {
            this.verifyBufferSize(this.size + b2.length);
            System.arraycopy(b2, 0, this.buf, this.size, b2.length);
            this.size += b2.length;
        }

        @Override
        public final void write(byte[] b2, int off, int len) {
            this.verifyBufferSize(this.size + len);
            System.arraycopy(b2, off, this.buf, this.size, len);
            this.size += len;
        }

        @Override
        public final void write(int b2) {
            this.verifyBufferSize(this.size + 1);
            this.buf[this.size++] = (byte)b2;
        }

        public void reset() {
            this.size = 0;
        }

        public InputStream getInputStream() {
            return new FastByteArrayInputStream(this.buf, this.size);
        }
    }
}

