/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.jaxb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.w3c.dom.Element;

public class MultiValuedStringMapAdapter
extends XmlAdapter<MultiValuedStringMapEntryList, Map<String, List<String>>> {
    @Override
    public MultiValuedStringMapEntryList marshal(Map<String, List<String>> map) throws Exception {
        if (map == null) {
            return null;
        }
        ArrayList<MultiValuedStringMapEntry> entries = new ArrayList<MultiValuedStringMapEntry>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            entries.add(new MultiValuedStringMapEntry(entry));
        }
        return new MultiValuedStringMapEntryList(entries);
    }

    @Override
    public Map<String, List<String>> unmarshal(MultiValuedStringMapEntryList entryList) throws Exception {
        if (entryList == null || entryList.getEntries() == null) {
            return null;
        }
        List<MultiValuedStringMapEntry> entries = entryList.getEntries();
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(entries.size());
        for (MultiValuedStringMapEntry entry : entries) {
            resultMap.put(entry.getKey(), entry.getValues());
        }
        return Collections.unmodifiableMap(resultMap);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="MultiValuedStringMapEntryListType")
    public static class MultiValuedStringMapEntryList
    extends AbstractDataTransferObject {
        private static final long serialVersionUID = 1L;
        @XmlElement(name="entry")
        private final List<MultiValuedStringMapEntry> entries;
        @XmlAnyElement
        private final Collection<Element> _futureElements = null;

        MultiValuedStringMapEntryList() {
            this.entries = null;
        }

        public MultiValuedStringMapEntryList(List<MultiValuedStringMapEntry> entries) {
            this.entries = new ArrayList<MultiValuedStringMapEntry>(entries);
        }

        public List<MultiValuedStringMapEntry> getEntries() {
            if (this.entries == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.entries);
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="MultiValuedStringMapEntryType")
    public static final class MultiValuedStringMapEntry
    implements Serializable {
        private static final long serialVersionUID = -9609663434312103L;
        @XmlAttribute(name="key")
        private final String key;
        @XmlElementWrapper(name="values")
        @XmlElement(name="value")
        private final List<String> values;

        MultiValuedStringMapEntry() {
            this.key = null;
            this.values = null;
        }

        public MultiValuedStringMapEntry(String key, List<String> values) {
            this.key = key;
            this.values = values;
        }

        public MultiValuedStringMapEntry(Map.Entry<String, List<String>> entry) {
            this.key = entry.getKey();
            this.values = Collections.unmodifiableList(new ArrayList(entry.getValue()));
        }

        public String getKey() {
            return this.key;
        }

        public List<String> getValues() {
            return this.values;
        }
    }
}

