/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.w3c.dom.Node;

public final class XmlJotter {
    private XmlJotter() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String jotDocument(Document document) {
        return XmlJotter.jotDocument(document, true);
    }

    public static String jotDocument(Document document, boolean indent) {
        XMLOutputter outputer = new XMLOutputter(XmlJotter.getJdomFormat(indent));
        StringWriter writer = new StringWriter();
        try {
            outputer.output(document, (Writer)writer);
        }
        catch (IOException e2) {
            throw new XmlException("Could not write XML data export.", e2);
        }
        return writer.toString();
    }

    public static String jotDocument(org.w3c.dom.Document document) {
        return XmlJotter.jotNode(document.getDocumentElement());
    }

    public static String jotDocument(org.w3c.dom.Document document, boolean indent) {
        return XmlJotter.jotNode(document.getDocumentElement(), indent);
    }

    public static String jotNode(Element node) {
        return XmlJotter.jotNode(node, true);
    }

    public static String jotNode(Element node, boolean indent) {
        XMLOutputter outputer = new XMLOutputter(XmlJotter.getJdomFormat(indent));
        StringWriter writer = new StringWriter();
        try {
            outputer.output(node, (Writer)writer);
        }
        catch (IOException e2) {
            throw new XmlException("Could not write XML data export.", e2);
        }
        return writer.toString();
    }

    public static String jotNode(Node node) {
        return XmlJotter.jotNode(node, true);
    }

    public static String jotNode(Node node, boolean indent) {
        try {
            return XmlJotter.nodeToString(node, indent);
        }
        catch (TransformerException te) {
            throw new XmlException(te);
        }
    }

    private static String nodeToString(Node node, boolean indent) throws TransformerException {
        DOMSource source = new DOMSource(node);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        if (indent) {
            transformer.setOutputProperty("indent", "yes");
        }
        transformer.transform(source, result);
        return writer.toString();
    }

    private static Format getJdomFormat(boolean indent) {
        return indent ? Format.getPrettyFormat() : Format.getRawFormat();
    }
}

