/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.bind.v2.runtime.reflect.Lister;

final class PrimitiveArrayListerFloat<BeanT>
extends Lister<BeanT, float[], Float, FloatArrayPack> {
    private PrimitiveArrayListerFloat() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Float.TYPE, new PrimitiveArrayListerFloat());
    }

    @Override
    public ListIterator<Float> iterator(final float[] objects, XMLSerializer context) {
        return new ListIterator<Float>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < objects.length;
            }

            @Override
            public Float next() {
                return Float.valueOf(objects[this.idx++]);
            }
        };
    }

    @Override
    public FloatArrayPack startPacking(BeanT current, Accessor<BeanT, float[]> acc) {
        return new FloatArrayPack();
    }

    @Override
    public void addToPack(FloatArrayPack objects, Float o2) {
        objects.add(o2);
    }

    @Override
    public void endPacking(FloatArrayPack pack, BeanT bean2, Accessor<BeanT, float[]> acc) throws AccessorException {
        acc.set(bean2, pack.build());
    }

    @Override
    public void reset(BeanT o2, Accessor<BeanT, float[]> acc) throws AccessorException {
        acc.set(o2, new float[0]);
    }

    static final class FloatArrayPack {
        float[] buf = new float[16];
        int size;

        FloatArrayPack() {
        }

        void add(Float b2) {
            if (this.buf.length == this.size) {
                float[] nb = new float[this.buf.length * 2];
                System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                this.buf = nb;
            }
            if (b2 != null) {
                this.buf[this.size++] = b2.floatValue();
            }
        }

        float[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            float[] r2 = new float[this.size];
            System.arraycopy(this.buf, 0, r2, 0, this.size);
            return r2;
        }
    }
}

