/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate.management.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BeanUtils {
    private static Method getMethod(Object bean2, String propertyName) {
        StringBuilder sb = new StringBuilder("get").append(Character.toUpperCase(propertyName.charAt(0)));
        if (propertyName.length() > 1) {
            sb.append(propertyName.substring(1));
        }
        String getterName = sb.toString();
        for (Method m3 : bean2.getClass().getMethods()) {
            if (!getterName.equals(m3.getName()) || m3.getParameterTypes().length != 0) continue;
            return m3;
        }
        return null;
    }

    private static Field getField(Object bean2, String propertyName) {
        for (Field f2 : bean2.getClass().getDeclaredFields()) {
            if (!propertyName.equals(f2.getName())) continue;
            return f2;
        }
        return null;
    }

    private static void validateArgs(Object bean2, String propertyName) {
        if (bean2 == null) {
            throw new IllegalArgumentException("bean is null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is null");
        }
        if (propertyName.trim().length() == 0) {
            throw new IllegalArgumentException("propertyName is empty");
        }
    }

    public static Object getBeanProperty(Object bean2, String propertyName) {
        Field field;
        BeanUtils.validateArgs(bean2, propertyName);
        Method getter = BeanUtils.getMethod(bean2, propertyName);
        if (getter != null) {
            try {
                return getter.invoke(bean2, new Object[0]);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if ((field = BeanUtils.getField(bean2, propertyName)) != null) {
            try {
                field.setAccessible(true);
                return field.get(bean2);
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        return null;
    }

    public static long getLongBeanProperty(Object bean2, String propertyName) throws NoSuchFieldException {
        BeanUtils.validateArgs(bean2, propertyName);
        Object o2 = BeanUtils.getBeanProperty(bean2, propertyName);
        if (o2 == null) {
            throw new NoSuchFieldException(propertyName);
        }
        if (!(o2 instanceof Number)) {
            throw new IllegalArgumentException(propertyName + " not an Number");
        }
        return ((Number)o2).longValue();
    }
}

