/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.hibernate.management.impl.EhcacheHibernateMbeanNames;
import net.sf.ehcache.management.CacheStatisticsMBean;

public class CacheStatistics
implements CacheStatisticsMBean,
Serializable {
    private static final long serialVersionUID = 8085302752781762030L;
    private final transient Ehcache ehcache;
    private final ObjectName objectName;
    private final long ttlInMillis;
    private Statistics statistics;
    private long lastUpdated;

    public CacheStatistics(Ehcache ehcache, long ttl, TimeUnit unit) {
        this.ttlInMillis = unit.toMillis(ttl);
        this.ehcache = ehcache;
        this.objectName = CacheStatistics.createObjectName(ehcache.getCacheManager().getName(), ehcache.getName());
    }

    public CacheStatistics(Ehcache ehcache) {
        this(ehcache, 0L, TimeUnit.MILLISECONDS);
    }

    static ObjectName createObjectName(String cacheManagerName, String cacheName) {
        ObjectName objectName;
        try {
            objectName = new ObjectName("net.sf.ehcache:type=CacheStatistics,CacheManager=" + cacheManagerName + ",name=" + EhcacheHibernateMbeanNames.mbeanSafe(cacheName));
        }
        catch (MalformedObjectNameException e2) {
            throw new CacheException(e2);
        }
        return objectName;
    }

    @Override
    public int getStatisticsAccuracy() {
        this.updateIfNeeded();
        return this.statistics.getStatisticsAccuracy();
    }

    private void updateIfNeeded() {
        long statsAge = System.currentTimeMillis() - this.lastUpdated;
        if (statsAge < 0L || statsAge > this.ttlInMillis) {
            this.statistics = this.ehcache.getStatistics();
            this.lastUpdated = System.currentTimeMillis();
        }
    }

    @Override
    public String getStatisticsAccuracyDescription() {
        this.updateIfNeeded();
        return this.statistics.getStatisticsAccuracyDescription();
    }

    @Override
    public String getAssociatedCacheName() {
        if (this.statistics == null) {
            return null;
        }
        return this.statistics.getAssociatedCacheName();
    }

    @Override
    public void clearStatistics() {
        this.statistics.clearStatistics();
    }

    @Override
    public long getCacheHits() {
        this.updateIfNeeded();
        return this.statistics.getCacheHits();
    }

    @Override
    public long getInMemoryHits() {
        this.updateIfNeeded();
        return this.statistics.getInMemoryHits();
    }

    @Override
    public long getOffHeapHits() {
        this.updateIfNeeded();
        return this.statistics.getOffHeapHits();
    }

    @Override
    public long getOnDiskHits() {
        this.updateIfNeeded();
        return this.statistics.getOnDiskHits();
    }

    @Override
    public long getCacheMisses() {
        this.updateIfNeeded();
        return this.statistics.getCacheMisses();
    }

    @Override
    public long getInMemoryMisses() {
        this.updateIfNeeded();
        return this.statistics.getInMemoryMisses();
    }

    @Override
    public long getOffHeapMisses() {
        this.updateIfNeeded();
        return this.statistics.getOffHeapMisses();
    }

    @Override
    public long getOnDiskMisses() {
        this.updateIfNeeded();
        return this.statistics.getOnDiskMisses();
    }

    @Override
    public long getObjectCount() {
        this.updateIfNeeded();
        return this.statistics.getObjectCount();
    }

    @Override
    public long getWriterQueueLength() {
        this.updateIfNeeded();
        return this.statistics.getWriterQueueSize();
    }

    @Override
    public int getWriterMaxQueueSize() {
        return this.ehcache.getCacheConfiguration().getCacheWriterConfiguration().getWriteBehindMaxQueueSize();
    }

    @Override
    public long getMemoryStoreObjectCount() {
        this.updateIfNeeded();
        return this.statistics.getMemoryStoreObjectCount();
    }

    @Override
    public long getOffHeapStoreObjectCount() {
        this.updateIfNeeded();
        return this.statistics.getOffHeapStoreObjectCount();
    }

    @Override
    public long getDiskStoreObjectCount() {
        this.updateIfNeeded();
        return this.statistics.getDiskStoreObjectCount();
    }

    ObjectName getObjectName() {
        return this.objectName;
    }

    public Ehcache getEhcache() {
        return this.ehcache;
    }

    private static double getPercentage(long number, long total) {
        if (total == 0L) {
            return 0.0;
        }
        return (double)number / (double)total;
    }

    @Override
    public double getCacheHitPercentage() {
        this.updateIfNeeded();
        long hits = this.statistics.getCacheHits();
        long misses = this.statistics.getCacheMisses();
        long total = hits + misses;
        return CacheStatistics.getPercentage(hits, total);
    }

    @Override
    public double getCacheMissPercentage() {
        this.updateIfNeeded();
        long hits = this.statistics.getCacheHits();
        long misses = this.statistics.getCacheMisses();
        long total = hits + misses;
        return CacheStatistics.getPercentage(misses, total);
    }

    @Override
    public double getInMemoryHitPercentage() {
        this.updateIfNeeded();
        long hits = this.statistics.getInMemoryHits();
        long misses = this.statistics.getInMemoryMisses();
        long total = hits + misses;
        return CacheStatistics.getPercentage(hits, total);
    }

    @Override
    public double getOffHeapHitPercentage() {
        this.updateIfNeeded();
        long hits = this.statistics.getOffHeapHits();
        long misses = this.statistics.getOffHeapMisses();
        long total = hits + misses;
        return CacheStatistics.getPercentage(hits, total);
    }

    @Override
    public double getOnDiskHitPercentage() {
        this.updateIfNeeded();
        long hits = this.statistics.getOnDiskHits();
        long misses = this.statistics.getOnDiskMisses();
        long total = hits + misses;
        return CacheStatistics.getPercentage(hits, total);
    }
}

