/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.pool.impl;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolableStore;
import net.sf.ehcache.pool.SizeOfEngine;
import net.sf.ehcache.pool.impl.AbstractPoolAccessor;

final class LockedPoolAccessor
extends AbstractPoolAccessor<PoolableStore> {
    private long size;
    private final Lock lock = new ReentrantLock();

    LockedPoolAccessor(Pool pool, PoolableStore store, SizeOfEngine sizeOfEngine, long currentSize) {
        super(pool, store, sizeOfEngine);
        this.size = currentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long add(long sizeOf, boolean force) {
        this.lock.lock();
        try {
            do {
                long l2;
                long newSize;
                if ((newSize = this.getPool().getSize() + sizeOf) <= this.getPool().getMaxSize()) {
                    this.size += sizeOf;
                    l2 = sizeOf;
                    return l2;
                }
                if (!force && sizeOf > this.getPool().getMaxSize()) {
                    l2 = -1L;
                    return l2;
                }
                long missingSize = newSize - this.getPool().getMaxSize();
                this.lock.unlock();
                try {
                    boolean successful = this.getPool().getEvictor().freeSpace(this.getPool().getPoolableStores(), missingSize);
                    if (force || successful) continue;
                    long l3 = -1L;
                    return l3;
                }
                finally {
                    this.lock.lock();
                }
            } while (!force && this.getPool().getSize() + sizeOf > this.getPool().getMaxSize());
            this.size += sizeOf;
            long l4 = sizeOf;
            return l4;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean canAddWithoutEvicting(long sizeOf) {
        this.lock.lock();
        try {
            long newSize = this.getPool().getSize() + sizeOf;
            boolean bl = newSize <= this.getPool().getMaxSize();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(long sizeOf) {
        this.checkLinked();
        this.lock.lock();
        try {
            this.size -= sizeOf;
        }
        finally {
            this.lock.unlock();
        }
        return sizeOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        this.lock.lock();
        try {
            long l2 = this.size;
            return l2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClear() {
        this.lock.lock();
        try {
            this.size = 0L;
        }
        finally {
            this.lock.unlock();
        }
    }
}

