/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.search.impl;

import java.util.List;
import java.util.Set;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Direction;
import net.sf.ehcache.search.SearchException;
import net.sf.ehcache.search.aggregator.AggregatorInstance;
import net.sf.ehcache.search.aggregator.Average;
import net.sf.ehcache.search.aggregator.Count;
import net.sf.ehcache.search.aggregator.Max;
import net.sf.ehcache.search.aggregator.Min;
import net.sf.ehcache.search.aggregator.Sum;
import net.sf.ehcache.search.expression.AlwaysMatch;
import net.sf.ehcache.search.expression.And;
import net.sf.ehcache.search.expression.Between;
import net.sf.ehcache.search.expression.ComparableValue;
import net.sf.ehcache.search.expression.Criteria;
import net.sf.ehcache.search.expression.EqualTo;
import net.sf.ehcache.search.expression.GreaterThan;
import net.sf.ehcache.search.expression.GreaterThanOrEqual;
import net.sf.ehcache.search.expression.ILike;
import net.sf.ehcache.search.expression.InCollection;
import net.sf.ehcache.search.expression.LessThan;
import net.sf.ehcache.search.expression.LessThanOrEqual;
import net.sf.ehcache.search.expression.Not;
import net.sf.ehcache.search.expression.NotEqualTo;
import net.sf.ehcache.search.expression.NotILike;
import net.sf.ehcache.search.expression.Or;
import net.sf.ehcache.store.StoreQuery;

public abstract class BaseQueryInterpreter {
    public void process(StoreQuery query) {
        this.includeKeys(this.shouldIncludeKeys(query));
        this.includeValues(this.shouldIncludeValues(query));
        this.maxResults(query.maxResults());
        this.processCriteria(query.getCriteria());
        this.processAttributes(query.requestedAttributes());
        this.processOrdering(query.getOrdering());
        this.processGroupBy(query.groupByAttributes());
        this.processAggregators(query.getAggregatorInstances());
    }

    protected boolean shouldIncludeValues(StoreQuery query) {
        return query.requestsValues();
    }

    protected boolean shouldIncludeKeys(StoreQuery query) {
        return query.requestsKeys();
    }

    private void processAggregators(List<AggregatorInstance<?>> aggregatorInstances) {
        for (AggregatorInstance<?> aggregatorInstance : aggregatorInstances) {
            if (aggregatorInstance instanceof Count) {
                this.count();
                continue;
            }
            if (aggregatorInstance instanceof Average) {
                this.average(aggregatorInstance.getAttribute().getAttributeName());
                continue;
            }
            if (aggregatorInstance instanceof Sum) {
                this.sum(aggregatorInstance.getAttribute().getAttributeName());
                continue;
            }
            if (aggregatorInstance instanceof Min) {
                this.min(aggregatorInstance.getAttribute().getAttributeName());
                continue;
            }
            if (aggregatorInstance instanceof Max) {
                this.max(aggregatorInstance.getAttribute().getAttributeName());
                continue;
            }
            throw new SearchException("unknown aggregator type: " + aggregatorInstance.getClass().getName());
        }
    }

    private void processAttributes(Set<Attribute<?>> attributes) {
        for (Attribute<?> attr : attributes) {
            this.attribute(attr.getAttributeName());
        }
    }

    private void processOrdering(List<StoreQuery.Ordering> orderings) {
        for (StoreQuery.Ordering ordering : orderings) {
            String attributeName = ordering.getAttribute().getAttributeName();
            if (Direction.DESCENDING.equals((Object)ordering.getDirection())) {
                this.attributeDescending(attributeName);
                continue;
            }
            this.attributeAscending(attributeName);
        }
    }

    private void processGroupBy(Set<Attribute<?>> attributes) {
        for (Attribute<?> attr : attributes) {
            this.groupBy(attr.getAttributeName());
        }
    }

    private void processCriteria(Criteria criteria) {
        if (criteria instanceof AlwaysMatch) {
            this.processAlwaysCriteria((AlwaysMatch)AlwaysMatch.class.cast(criteria));
        } else if (criteria instanceof And) {
            this.processAndCriteria((And)And.class.cast(criteria));
        } else if (criteria instanceof Or) {
            this.processOrCriteria((Or)Or.class.cast(criteria));
        } else if (criteria instanceof Not) {
            this.processNotCriteria((Not)Not.class.cast(criteria));
        } else if (criteria instanceof NotEqualTo) {
            this.processNotEqualCriteria((NotEqualTo)NotEqualTo.class.cast(criteria));
        } else if (criteria instanceof NotILike) {
            this.processNotLikeCriteria((NotILike)NotILike.class.cast(criteria));
        } else if (criteria instanceof Between) {
            this.processBetweenCriteria((Between)Between.class.cast(criteria));
        } else if (criteria instanceof EqualTo) {
            this.processEqualCriteria((EqualTo)EqualTo.class.cast(criteria));
        } else if (criteria instanceof ILike) {
            this.processLikeCriteria((ILike)ILike.class.cast(criteria));
        } else if (criteria instanceof GreaterThan) {
            this.processGreaterThanCriteria((GreaterThan)GreaterThan.class.cast(criteria));
        } else if (criteria instanceof GreaterThanOrEqual) {
            this.processGreaterThanOrEqualCriteria((GreaterThanOrEqual)GreaterThanOrEqual.class.cast(criteria));
        } else if (criteria instanceof InCollection) {
            this.processInCollectionCriteria((InCollection)InCollection.class.cast(criteria));
        } else if (criteria instanceof LessThan) {
            this.processLessThanCriteria((LessThan)LessThan.class.cast(criteria));
        } else if (criteria instanceof LessThanOrEqual) {
            this.processLessThanOrEqualCriteria((LessThanOrEqual)LessThanOrEqual.class.cast(criteria));
        } else {
            throw new SearchException("Unknown criteria type: " + criteria);
        }
    }

    private void processLikeCriteria(ILike criteria) {
        this.ilike(criteria.getAttributeName(), criteria.getRegex());
    }

    private void processNotLikeCriteria(NotILike criteria) {
        this.notIlike(criteria.getAttributeName(), criteria.getRegex());
    }

    private void processAlwaysCriteria(AlwaysMatch cast) {
        this.all();
    }

    private void processAndCriteria(And criteria) {
        this.beginGroup();
        this.and();
        for (Criteria element : criteria.getCriterion()) {
            this.processCriteria(element);
        }
        this.endGroup();
    }

    private void processOrCriteria(Or criteria) {
        this.beginGroup();
        this.or();
        for (Criteria element : criteria.getCriterion()) {
            this.processCriteria(element);
        }
        this.endGroup();
    }

    private void processInCollectionCriteria(InCollection criteria) {
        this.beginGroup();
        this.or();
        for (Object value : criteria.values()) {
            this.term(criteria.getAttributeName(), value);
        }
        this.endGroup();
    }

    private void processNotCriteria(Not not) {
        Criteria negated = not.getCriteria();
        this.processCriteria(BaseQueryInterpreter.notOf(negated));
    }

    private static Criteria notOf(Criteria c2) {
        if (c2 instanceof NotEqualTo) {
            return new EqualTo(((NotEqualTo)c2).getAttributeName(), ((NotEqualTo)c2).getValue());
        }
        if (c2 instanceof EqualTo) {
            return new NotEqualTo(((EqualTo)c2).getAttributeName(), ((EqualTo)c2).getValue());
        }
        if (c2 instanceof And) {
            Criteria[] criterion = ((And)c2).getCriterion();
            Criteria rv = new Or(BaseQueryInterpreter.notOf(criterion[0]), BaseQueryInterpreter.notOf(criterion[1]));
            for (int i2 = 2; i2 < criterion.length; ++i2) {
                rv = rv.or(BaseQueryInterpreter.notOf(criterion[i2]));
            }
            return rv;
        }
        if (c2 instanceof Or) {
            Criteria[] criterion = ((Or)c2).getCriterion();
            Criteria rv = new And(BaseQueryInterpreter.notOf(criterion[0]), BaseQueryInterpreter.notOf(criterion[1]));
            for (int i3 = 2; i3 < criterion.length; ++i3) {
                rv = rv.and(BaseQueryInterpreter.notOf(criterion[i3]));
            }
            return rv;
        }
        if (c2 instanceof Between) {
            Between b2 = (Between)c2;
            String name = b2.getAttributeName();
            ComparableValue lhs = b2.isMinInclusive() ? new LessThan(name, b2.getMin()) : new LessThanOrEqual(name, b2.getMin());
            ComparableValue rhs = b2.isMaxInclusive() ? new GreaterThan(name, b2.getMax()) : new GreaterThanOrEqual(name, b2.getMax());
            return new Or(lhs, (Criteria)rhs);
        }
        if (c2 instanceof GreaterThan) {
            return new LessThanOrEqual(((GreaterThan)c2).getAttributeName(), ((GreaterThan)c2).getComparableValue());
        }
        if (c2 instanceof GreaterThanOrEqual) {
            return new LessThan(((GreaterThanOrEqual)c2).getAttributeName(), ((GreaterThanOrEqual)c2).getComparableValue());
        }
        if (c2 instanceof LessThan) {
            return new GreaterThanOrEqual(((LessThan)c2).getAttributeName(), ((LessThan)c2).getComparableValue());
        }
        if (c2 instanceof LessThanOrEqual) {
            return new GreaterThan(((LessThanOrEqual)c2).getAttributeName(), ((LessThanOrEqual)c2).getComparableValue());
        }
        if (c2 instanceof Not) {
            return ((Not)c2).getCriteria();
        }
        if (c2 instanceof ILike) {
            ILike ilike = (ILike)c2;
            return new NotILike(ilike.getAttributeName(), ilike.getRegex());
        }
        if (c2 instanceof InCollection) {
            InCollection in = (InCollection)c2;
            String name = in.getAttributeName();
            Object[] values = in.values().toArray();
            if (values.length == 1) {
                return new NotEqualTo(in.getAttributeName(), values[0]);
            }
            Criteria rv = new And(new NotEqualTo(name, values[0]), (Criteria)new NotEqualTo(name, values[1]));
            for (int i4 = 2; i4 < values.length; ++i4) {
                rv = rv.and(new NotEqualTo(name, values[i4]));
            }
            return rv;
        }
        if (c2 instanceof AlwaysMatch) {
            throw new UnsupportedOperationException();
        }
        throw new AssertionError((Object)("negate for " + c2.getClass()));
    }

    private void processNotEqualCriteria(NotEqualTo criteria) {
        this.notEqualTerm(criteria.getAttributeName(), criteria.getValue());
    }

    private void processBetweenCriteria(Between criteria) {
        this.between(criteria.getAttributeName(), criteria.getMin(), criteria.getAttributeName(), criteria.getMax(), criteria.isMinInclusive(), criteria.isMaxInclusive());
    }

    private void processEqualCriteria(EqualTo criteria) {
        this.term(criteria.getAttributeName(), criteria.getValue());
    }

    private void processGreaterThanCriteria(GreaterThan criteria) {
        this.greaterThan(criteria.getAttributeName(), criteria.getComparableValue());
    }

    private void processGreaterThanOrEqualCriteria(GreaterThanOrEqual criteria) {
        this.greaterThanEqual(criteria.getAttributeName(), criteria.getComparableValue());
    }

    private void processLessThanCriteria(LessThan criteria) {
        this.lessThan(criteria.getAttributeName(), criteria.getComparableValue());
    }

    private void processLessThanOrEqualCriteria(LessThanOrEqual criteria) {
        this.lessThanEqual(criteria.getAttributeName(), criteria.getComparableValue());
    }

    protected abstract void maxResults(int var1);

    protected abstract void includeKeys(boolean var1);

    protected abstract void includeValues(boolean var1);

    protected abstract void max(String var1);

    protected abstract void min(String var1);

    protected abstract void sum(String var1);

    protected abstract void average(String var1);

    protected abstract void count();

    protected abstract void attribute(String var1);

    protected abstract void attributeAscending(String var1);

    protected abstract void attributeDescending(String var1);

    protected abstract void groupBy(String var1);

    protected abstract void ilike(String var1, String var2);

    protected abstract void all();

    protected abstract void endGroup();

    protected abstract void and();

    protected abstract void or();

    protected abstract void beginGroup();

    protected abstract void term(String var1, Object var2);

    protected abstract void notIlike(String var1, String var2);

    protected abstract void greaterThan(String var1, Object var2);

    protected abstract void greaterThanEqual(String var1, Object var2);

    protected abstract void between(String var1, Object var2, String var3, Object var4, boolean var5, boolean var6);

    protected abstract void notEqualTerm(String var1, Object var2);

    protected abstract void lessThanEqual(String var1, Object var2);

    protected abstract void lessThan(String var1, Object var2);
}

