/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.disk.ods;

import net.sf.ehcache.store.disk.ods.AATreeSet;

public class Region
extends AATreeSet.AbstractTreeNode<Comparable>
implements Comparable<Comparable> {
    private long start;
    private long end;
    private long contiguous;

    public Region(long value) {
        this(value, value);
    }

    public Region(long start, long end) {
        this.start = start;
        this.end = end;
        this.updateContiguous();
    }

    public Region(Region r2) {
        this(r2.start(), r2.end());
    }

    public long contiguous() {
        if (this.getLeft().getPayload() == null && this.getRight().getPayload() == null) {
            return this.size();
        }
        return this.contiguous;
    }

    private void updateContiguous() {
        Region left = (Region)this.getLeft().getPayload();
        Region right = (Region)this.getRight().getPayload();
        long leftContiguous = left == null ? 0L : left.contiguous();
        long rightContiguous = right == null ? 0L : right.contiguous();
        this.contiguous = Math.max(this.size(), Math.max(leftContiguous, rightContiguous));
    }

    @Override
    public void setLeft(AATreeSet.Node<Comparable> l2) {
        super.setLeft(l2);
        this.updateContiguous();
    }

    @Override
    public void setRight(AATreeSet.Node<Comparable> r2) {
        super.setRight(r2);
        this.updateContiguous();
    }

    public String toString() {
        return "Range(" + this.start + "," + this.end + ")" + " contiguous:" + this.contiguous();
    }

    public long size() {
        return this.isNull() ? 0L : this.end - this.start + 1L;
    }

    protected boolean isNull() {
        return this.start > this.end;
    }

    protected Region remove(Region r2) throws IllegalArgumentException {
        if (r2.start < this.start || r2.end > this.end) {
            throw new IllegalArgumentException("Ranges : Illegal value passed to remove : " + this + " remove called for : " + r2);
        }
        if (this.start == r2.start) {
            this.start = r2.end + 1L;
            this.updateContiguous();
            return null;
        }
        if (this.end == r2.end) {
            this.end = r2.start - 1L;
            this.updateContiguous();
            return null;
        }
        Region newRegion = new Region(r2.end + 1L, this.end);
        this.end = r2.start - 1L;
        this.updateContiguous();
        return newRegion;
    }

    protected void merge(Region r2) throws IllegalArgumentException {
        if (this.start == r2.end + 1L) {
            this.start = r2.start;
        } else if (this.end == r2.start - 1L) {
            this.end = r2.end;
        } else {
            throw new IllegalArgumentException("Ranges : Merge called on non contiguous values : [this]:" + this + " and " + r2);
        }
        this.updateContiguous();
    }

    @Override
    public int compareTo(Comparable other) {
        if (other instanceof Region) {
            return this.compareTo((Region)other);
        }
        if (other instanceof Long) {
            return this.compareTo((Long)other);
        }
        throw new AssertionError((Object)("Unusual Type " + other.getClass()));
    }

    @Override
    private int compareTo(Region r2) {
        if (this.start > r2.start || this.end > r2.end) {
            return 1;
        }
        if (this.start < r2.start || this.end < r2.end) {
            return -1;
        }
        return 0;
    }

    @Override
    private int compareTo(Long l2) {
        if (l2 > this.end) {
            return -1;
        }
        if (l2 < this.start) {
            return 1;
        }
        return 0;
    }

    @Override
    public void swapPayload(AATreeSet.Node<Comparable> other) {
        if (!(other instanceof Region)) {
            throw new AssertionError();
        }
        Region r2 = (Region)other;
        long temp = this.start;
        this.start = r2.start;
        r2.start = temp;
        temp = this.end;
        this.end = r2.end;
        r2.end = temp;
        this.updateContiguous();
    }

    @Override
    public Region getPayload() {
        return this;
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }
}

