/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.util.ClassLoaderUtil;

class TerracottaClusteredInstanceHelper {
    private static TerracottaClusteredInstanceHelper instance = new TerracottaClusteredInstanceHelper();
    private static final boolean TC_DSO_MODE = Boolean.getBoolean("tc.active");
    private static final String ENTERPRISE_EXPRESS_FACTORY = "net.sf.ehcache.terracotta.ExpressEnterpriseTerracottaClusteredInstanceFactory";
    private static final String ENTERPRISE_CUSTOM_FACTORY = "org.terracotta.modules.ehcache.store.EnterpriseTerracottaClusteredInstanceFactory";
    private static final String EXPRESS_FACTORY = "net.sf.ehcache.terracotta.StandaloneTerracottaClusteredInstanceFactory";
    private static final String CUSTOM_FACTORY = "org.terracotta.modules.ehcache.store.TerracottaClusteredInstanceFactory";
    private volatile TerracottaRuntimeType terracottaRuntimeType;

    private TerracottaClusteredInstanceHelper() {
        this.lookupTerracottaRuntime();
    }

    public static TerracottaClusteredInstanceHelper getInstance() {
        return instance;
    }

    private static void setTestMode(TerracottaClusteredInstanceHelper testHelper) {
        instance = testHelper;
    }

    private TerracottaRuntimeType lookupTerracottaRuntime() {
        if (this.terracottaRuntimeType == null) {
            TerracottaRuntimeType[] lookupSequence;
            for (TerracottaRuntimeType type : lookupSequence = new TerracottaRuntimeType[]{TerracottaRuntimeType.EnterpriseExpress, TerracottaRuntimeType.EnterpriseCustom, TerracottaRuntimeType.Express, TerracottaRuntimeType.Custom}) {
                if (type.getFactoryClassOrNull() == null) continue;
                this.terracottaRuntimeType = type;
                break;
            }
        }
        return this.terracottaRuntimeType;
    }

    ClusteredInstanceFactory newClusteredInstanceFactory(Map<String, CacheConfiguration> cacheConfigs, TerracottaClientConfiguration terracottaConfig) {
        this.lookupTerracottaRuntime();
        if (this.terracottaRuntimeType == null) {
            throw new CacheException("Terracotta cache classes are not available, you are missing jar(s) most likely");
        }
        if (this.terracottaRuntimeType == TerracottaRuntimeType.EnterpriseExpress || this.terracottaRuntimeType == TerracottaRuntimeType.Express) {
            TerracottaClusteredInstanceHelper.assertExpress(cacheConfigs, terracottaConfig);
        } else if (this.terracottaRuntimeType == TerracottaRuntimeType.EnterpriseCustom || this.terracottaRuntimeType == TerracottaRuntimeType.Custom) {
            TerracottaClusteredInstanceHelper.assertCustom(terracottaConfig);
        } else {
            throw new CacheException("Unknown Terracotta runtime type - " + (Object)((Object)this.terracottaRuntimeType));
        }
        Class factoryClass = this.terracottaRuntimeType.getFactoryClassOrNull();
        if (factoryClass == null) {
            throw new CacheException("Not able to get factory class for: " + this.terracottaRuntimeType.name());
        }
        try {
            return (ClusteredInstanceFactory)ClassLoaderUtil.createNewInstance(factoryClass.getName(), new Class[]{TerracottaClientConfiguration.class}, new Object[]{terracottaConfig});
        }
        catch (CacheException ce) {
            if (ce.getCause() instanceof NoClassDefFoundError) {
                throw new CacheException("Could not create ClusteredInstanceFactory due to missing class. Please verify that terracotta-toolkit is in your classpath.", ce.getCause().getCause());
            }
            throw ce;
        }
    }

    private static void assertCustom(TerracottaClientConfiguration terracottaConfig) {
        if (!TC_DSO_MODE) {
            throw new CacheException("When not using standalone deployment, you need to use full install of Terracotta in order to use Terracotta Clustered Caches.");
        }
        if (terracottaConfig != null) {
            throw new CacheException("The ehcache configuration specified Terracotta configuration information, but when using the full install of Terracotta, you must specify the Terracotta configuration only with an external tc-config.xml file, not embedded or referenced from the ehcache configuration file.");
        }
    }

    private static void assertExpress(Map<String, CacheConfiguration> cacheConfigs, TerracottaClientConfiguration terracottaConfig) {
        ArrayList<String> identityCaches = new ArrayList<String>();
        for (CacheConfiguration config : cacheConfigs.values()) {
            TerracottaConfiguration tcConfig = config.getTerracottaConfiguration();
            if (tcConfig == null || tcConfig.getValueMode() != TerracottaConfiguration.ValueMode.IDENTITY) continue;
            identityCaches.add(config.getName());
        }
        if (!identityCaches.isEmpty()) {
            throw TerracottaClusteredInstanceHelper.newExceptionIdentityNotSupportedInExpress(identityCaches);
        }
        if (terracottaConfig == null) {
            throw new CacheException("Terracotta caches are defined but no <terracottaConfig> element was used to specify the Terracotta configuration.");
        }
    }

    private static CacheException newExceptionIdentityNotSupportedInExpress(List<String> identityCaches) {
        return new CacheException("One or more caches are configured for identity value mode which is not permitted with standalone deployment " + identityCaches.toString());
    }

    TerracottaRuntimeType getTerracottaRuntimeTypeOrNull() {
        return this.terracottaRuntimeType;
    }

    static enum TerracottaRuntimeType {
        EnterpriseExpress("net.sf.ehcache.terracotta.ExpressEnterpriseTerracottaClusteredInstanceFactory"),
        Express("net.sf.ehcache.terracotta.StandaloneTerracottaClusteredInstanceFactory"),
        EnterpriseCustom("org.terracotta.modules.ehcache.store.EnterpriseTerracottaClusteredInstanceFactory"),
        Custom("org.terracotta.modules.ehcache.store.TerracottaClusteredInstanceFactory");

        private final String factoryClassName;

        private TerracottaRuntimeType(String factoryClassName) {
            this.factoryClassName = factoryClassName;
        }

        public Class getFactoryClassOrNull() {
            try {
                return ClassLoaderUtil.loadClass(this.factoryClassName);
            }
            catch (ClassNotFoundException e2) {
                return null;
            }
        }
    }
}

