/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.sf.ehcache.CacheException;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static ClassLoader getStandardClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getFallbackClassLoader() {
        return ClassLoaderUtil.class.getClassLoader();
    }

    public static Object createNewInstance(String className) throws CacheException {
        return ClassLoaderUtil.createNewInstance(className, new Class[0], new Object[0]);
    }

    public static Object createNewInstance(String className, Class[] argTypes, Object[] args) throws CacheException {
        Object newInstance;
        Class clazz;
        try {
            clazz = ClassLoaderUtil.loadClass(className);
        }
        catch (ClassNotFoundException e2) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e2.getMessage(), e2);
        }
        try {
            Constructor constructor = clazz.getConstructor(argTypes);
            newInstance = constructor.newInstance(args);
        }
        catch (IllegalAccessException e3) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e3.getMessage(), e3);
        }
        catch (InstantiationException e4) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e4.getMessage(), e4);
        }
        catch (NoSuchMethodException e5) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e5.getMessage(), e5);
        }
        catch (SecurityException e6) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e6.getMessage(), e6);
        }
        catch (IllegalArgumentException e7) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e7.getMessage(), e7);
        }
        catch (InvocationTargetException e8) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e8.getCause().getMessage(), e8.getCause());
        }
        return newInstance;
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = Class.forName(className, true, ClassLoaderUtil.getStandardClassLoader());
        }
        catch (ClassNotFoundException e2) {
            clazz = Class.forName(className, true, ClassLoaderUtil.getFallbackClassLoader());
        }
        return clazz;
    }
}

