/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.other;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.Clock;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.other.ConnectionProxy;
import oracle.ucp.jdbc.proxy.other.ResultSetProxy;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Post;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.Chain;
import oracle.ucp.util.MapChain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
@ProxyFor(value={CallableStatement.class, PreparedStatement.class, Statement.class, LogicalObject.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class StatementProxy
implements LogicalObject {
    private final long creationTS = Clock.clock();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private AtomicBoolean initialQueryTimeoutSet = new AtomicBoolean(false);
    protected Chain<ResultSetProxy> resultSetsToClose = new MapChain<ResultSetProxy>();
    private Chain.Atom<StatementProxy> statementChainAtom = null;
    private boolean sqlWithQueryTimeoutInProgress = false;

    void setStatementChainAtom(Chain.Atom<StatementProxy> atom) {
        this.statementChainAtom = atom;
    }

    private void prepare() {
        this.getUPC().heartbeat();
        if (this.initialQueryTimeoutSet.compareAndSet(false, true)) {
            try {
                this.getDelegate().setQueryTimeout(((UniversalConnectionPoolBase)this.getUCP()).getQueryTimeout());
            }
            catch (SQLException e2) {
                ClioSupport.ilogThrowing(null, null, null, null, e2);
            }
        }
    }

    @GetDelegate
    protected abstract Statement getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    UniversalPooledConnection getUPC() {
        return ((ConnectionProxy)this.getCreator()).getUPC();
    }

    UniversalConnectionPool getUCP() {
        return ((ConnectionProxy)this.getCreator()).getUCP();
    }

    @Override
    public boolean isLogicallyClosed() {
        this.prepare();
        return this.closed.get();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() throws SQLException {
        this.prepare();
        if (this.isClosed()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        return (Connection)this.getCreator();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.sqlWithQueryTimeoutInProgress = seconds > 0;
        this.prepare();
        this.getDelegate().setQueryTimeout(seconds);
        this.getUPC().heartbeat();
    }

    public void closeOnCompletion() throws SQLException {
        this.prepare();
        this.getDelegate().closeOnCompletion();
        this.getUPC().heartbeat();
    }

    public boolean isClosed() throws SQLException {
        this.prepare();
        return this.closed.get() || this.getDelegate().isClosed() || ((ConnectionProxy)this.getCreator()).closed.get();
    }

    public void close() throws SQLException {
        this.prepare();
        if (this.closed.get()) {
            return;
        }
        for (ResultSetProxy rs : this.resultSetsToClose.toList()) {
            rs.close();
        }
        this.resultSetsToClose.clear();
        this.statementChainAtom.remove();
        this.closed.set(true);
        this.getDelegate().close();
        this.getUPC().heartbeat();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.prepare();
        if (iface.isInterface()) {
            if (iface.isInstance(this.getDelegate())) {
                return (T)this.getDelegate();
            }
            return this.getDelegate().unwrap(iface);
        }
        throw new SQLException("unable to unwrap interface " + iface.toString());
    }

    @Pre
    protected void pre(Method m3, Object receiver, Object ... args) throws SQLException {
        ConnectionProxy connProxy;
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        this.prepare();
        this.getUPC().setSqlWithQueryTimeoutInProgress(this.sqlWithQueryTimeoutInProgress);
        if (Clock.isBefore(this.creationTS, this.getUPC().getAvailableStartTime()) || Clock.isBefore(this.creationTS, this.getUPC().getBorrowedStartTime())) {
            this.closed.set(true);
            ((Connection)this.getCreator()).close();
        }
        if ((connProxy = (ConnectionProxy)this.getCreator()).isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(31);
        }
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class}), @Signature(name="getResultSet", args={}), @Signature(name="getGeneratedKeys", args={})})
    protected ResultSet post(Method m3, ResultSet result) {
        this.getUPC().heartbeat();
        this.sqlWithQueryTimeoutInProgress = false;
        this.getUPC().setSqlWithQueryTimeoutInProgress(false);
        this.saveResultSetProxy(result);
        return result;
    }

    @Post
    protected Object postRest(Method m3, Object result) {
        this.getUPC().heartbeat();
        this.saveResultSetProxy(result);
        return result;
    }

    protected void saveResultSetProxy(Object result) {
        if (result instanceof ResultSetProxy) {
            ResultSetProxy resultSetProxy = (ResultSetProxy)result;
            resultSetProxy.setResultSetChainAtom(this.resultSetsToClose.add(resultSetProxy));
        }
    }

    @Post
    protected void postRestVoid(Method m3) {
        this.getUPC().heartbeat();
    }

    @OnError(value=SQLException.class)
    protected void onErrorVoid(Method m3, SQLException e2) throws SQLException {
        this.onError(m3, e2);
    }

    @OnError(value=SQLException.class)
    protected Object onError(Method m3, SQLException e2) throws SQLException {
        this.getUPC().heartbeat();
        ((ConnectionProxy)this.getCreator()).handleSQRecoverableException(e2);
        throw e2;
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof StatementProxy ? ((StatementProxy)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }
}

