/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.xpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.NamespaceAware;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.filter.Filters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XPathHelper {
    private XPathHelper() {
    }

    private static StringBuilder getPositionPath(Object node, List<?> siblings, String pathToken, StringBuilder buffer) {
        buffer.append(pathToken);
        if (siblings != null) {
            int position = 0;
            Iterator<?> i2 = siblings.iterator();
            while (i2.hasNext()) {
                ++position;
                if (i2.next() != node) continue;
            }
            if (position > 1 || i2.hasNext()) {
                buffer.append('[').append(position).append(']');
            }
        }
        return buffer;
    }

    private static final StringBuilder getSingleStep(NamespaceAware nsa, StringBuilder buffer) {
        if (nsa instanceof Content) {
            Content content = (Content)nsa;
            Element pnt = content.getParentElement();
            if (content instanceof Text) {
                List<Text> sibs = pnt == null ? null : pnt.getContent(Filters.text());
                return XPathHelper.getPositionPath(content, sibs, "text()", buffer);
            }
            if (content instanceof Comment) {
                List<Comment> sibs = pnt == null ? null : pnt.getContent(Filters.comment());
                return XPathHelper.getPositionPath(content, sibs, "comment()", buffer);
            }
            if (content instanceof ProcessingInstruction) {
                List<ProcessingInstruction> sibs = pnt == null ? null : pnt.getContent(Filters.processinginstruction());
                return XPathHelper.getPositionPath(content, sibs, "processing-instruction()", buffer);
            }
            if (content instanceof Element && ((Element)content).getNamespace() == Namespace.NO_NAMESPACE) {
                String ename = ((Element)content).getName();
                List<Element> sibs = pnt == null ? null : pnt.getChildren(ename);
                return XPathHelper.getPositionPath(content, sibs, ename, buffer);
            }
            if (content instanceof Element) {
                Element emt = (Element)content;
                List<Element> sibs = pnt == null ? null : pnt.getChildren(emt.getName(), emt.getNamespace());
                String xps = "*[local-name() = '" + emt.getName() + "' and namespace-uri() = '" + emt.getNamespaceURI() + "']";
                return XPathHelper.getPositionPath(content, sibs, xps, buffer);
            }
            List<NamespaceAware> sibs = pnt == null ? Collections.singletonList(nsa) : pnt.getContent();
            return XPathHelper.getPositionPath(content, sibs, "node()", buffer);
        }
        if (nsa instanceof Attribute) {
            Attribute att = (Attribute)nsa;
            if (att.getNamespace() == Namespace.NO_NAMESPACE) {
                buffer.append("@").append(att.getName());
            } else {
                buffer.append("@*[local-name() = '").append(att.getName());
                buffer.append("' and namespace-uri() = '");
                buffer.append(att.getNamespaceURI()).append("']");
            }
        }
        return buffer;
    }

    private static StringBuilder getRelativeElementPath(Element from, Element to, StringBuilder sb) {
        Element e2;
        if (from == to) {
            sb.append(".");
            return sb;
        }
        ArrayList<Element> tostack = new ArrayList<Element>();
        for (e2 = to; e2 != null && e2 != from; e2 = e2.getParentElement()) {
            tostack.add(e2);
        }
        int pos = tostack.size();
        if (e2 != from) {
            Element f2;
            int fcnt = 0;
            for (f2 = from; f2 != null && (pos = XPathHelper.locate(f2, tostack)) < 0; f2 = f2.getParentElement()) {
                ++fcnt;
            }
            if (f2 == null) {
                throw new IllegalArgumentException("The 'from' and 'to' Element have no common ancestor.");
            }
            while (--fcnt >= 0) {
                sb.append("../");
            }
        }
        while (--pos >= 0) {
            XPathHelper.getSingleStep((NamespaceAware)tostack.get(pos), sb);
            sb.append("/");
        }
        sb.setLength(sb.length() - 1);
        return sb;
    }

    private static int locate(Element f2, List<Element> tostack) {
        int ret = tostack.size();
        while (--ret >= 0) {
            if (f2 != tostack.get(ret)) continue;
            return ret;
        }
        return -1;
    }

    public static String getRelativePath(Content from, Content to) {
        Element efrom;
        if (from == null) {
            throw new NullPointerException("Cannot create a path from a null target");
        }
        if (to == null) {
            throw new NullPointerException("Cannot create a path to a null target");
        }
        StringBuilder sb = new StringBuilder();
        if (from == to) {
            return ".";
        }
        Element element = efrom = from instanceof Element ? (Element)from : from.getParentElement();
        if (from != efrom) {
            sb.append("../");
        }
        if (to instanceof Element) {
            XPathHelper.getRelativeElementPath(efrom, (Element)to, sb);
        } else {
            Element telement = to.getParentElement();
            if (telement == null) {
                throw new IllegalArgumentException("Cannot get a relative XPath to detached content.");
            }
            XPathHelper.getRelativeElementPath(efrom, telement, sb);
            sb.append("/");
            XPathHelper.getSingleStep(to, sb);
        }
        return sb.toString();
    }

    public static String getRelativePath(Content from, Attribute to) {
        if (from == null) {
            throw new NullPointerException("Cannot create a path from a null Content");
        }
        if (to == null) {
            throw new NullPointerException("Cannot create a path to a null Attribute");
        }
        Element t2 = to.getParent();
        if (t2 == null) {
            throw new IllegalArgumentException("Cannot create a path to detached Attribute");
        }
        StringBuilder sb = new StringBuilder(XPathHelper.getRelativePath(from, (Content)t2));
        sb.append("/");
        XPathHelper.getSingleStep(to, sb);
        return sb.toString();
    }

    public static String getRelativePath(Attribute from, Attribute to) {
        if (from == null) {
            throw new NullPointerException("Cannot create a path from a null 'from'");
        }
        if (to == null) {
            throw new NullPointerException("Cannot create a path to a null target");
        }
        if (from == to) {
            return ".";
        }
        Element f2 = from.getParent();
        if (f2 == null) {
            throw new IllegalArgumentException("Cannot create a path from a detached attrbibute");
        }
        return "../" + XPathHelper.getRelativePath((Content)f2, to);
    }

    public static String getRelativePath(Attribute from, Content to) {
        if (from == null) {
            throw new NullPointerException("Cannot create a path from a null 'from'");
        }
        if (to == null) {
            throw new NullPointerException("Cannot create a path to a null target");
        }
        Element f2 = from.getParent();
        if (f2 == null) {
            throw new IllegalArgumentException("Cannot create a path from a detached attrbibute");
        }
        if (f2 == to) {
            return "..";
        }
        return "../" + XPathHelper.getRelativePath((Content)f2, to);
    }

    public static String getAbsolutePath(Content to) {
        Element t2;
        if (to == null) {
            throw new NullPointerException("Cannot create a path to a null target");
        }
        StringBuilder sb = new StringBuilder();
        Element element = t2 = to instanceof Element ? (Element)to : to.getParentElement();
        if (t2 == null) {
            throw new IllegalArgumentException("Cannot create a path to detached target");
        }
        Element r2 = t2;
        while (r2.getParentElement() != null) {
            r2 = r2.getParentElement();
        }
        sb.append("/");
        XPathHelper.getSingleStep(r2, sb);
        if (r2 != t2) {
            sb.append("/");
            XPathHelper.getRelativeElementPath(r2, t2, sb);
        }
        if (t2 != to) {
            sb.append("/");
            XPathHelper.getSingleStep(to, sb);
        }
        return sb.toString();
    }

    public static String getAbsolutePath(Attribute to) {
        if (to == null) {
            throw new NullPointerException("Cannot create a path to a null target");
        }
        Element t2 = to.getParent();
        if (t2 == null) {
            throw new IllegalArgumentException("Cannot create a path to detached target");
        }
        Element r2 = t2;
        while (r2.getParentElement() != null) {
            r2 = r2.getParentElement();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        XPathHelper.getSingleStep(r2, sb);
        if (t2 != r2) {
            sb.append("/");
            XPathHelper.getRelativeElementPath(r2, t2, sb);
        }
        sb.append("/");
        XPathHelper.getSingleStep(to, sb);
        return sb.toString();
    }
}

