/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.criteria;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.criteria.AbstractPredicate;
import org.kuali.rice.core.api.criteria.AndPredicate;
import org.kuali.rice.core.api.criteria.CompositePredicate;
import org.kuali.rice.core.api.criteria.CriteriaSupportUtils;
import org.kuali.rice.core.api.criteria.EqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.EqualPredicate;
import org.kuali.rice.core.api.criteria.ExistsSubQueryPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanPredicate;
import org.kuali.rice.core.api.criteria.InIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.InPredicate;
import org.kuali.rice.core.api.criteria.LessThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.LessThanPredicate;
import org.kuali.rice.core.api.criteria.LikeIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.LikePredicate;
import org.kuali.rice.core.api.criteria.NotEqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotEqualPredicate;
import org.kuali.rice.core.api.criteria.NotInIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotInPredicate;
import org.kuali.rice.core.api.criteria.NotLikeIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotLikePredicate;
import org.kuali.rice.core.api.criteria.NotNullPredicate;
import org.kuali.rice.core.api.criteria.NullPredicate;
import org.kuali.rice.core.api.criteria.OrPredicate;
import org.kuali.rice.core.api.criteria.Predicate;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CompositePredicateType")
abstract class AbstractCompositePredicate
extends AbstractPredicate
implements CompositePredicate {
    private static final long serialVersionUID = 6164560054223588779L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    @XmlElements(value={@XmlElement(name="and", type=AndPredicate.class, required=false), @XmlElement(name="equal", type=EqualPredicate.class, required=false), @XmlElement(name="equalIgnoreCase", type=EqualIgnoreCasePredicate.class, required=false), @XmlElement(name="existsSubQuery", type=ExistsSubQueryPredicate.class, required=false), @XmlElement(name="greaterThan", type=GreaterThanPredicate.class, required=false), @XmlElement(name="greaterThanOrEqual", type=GreaterThanOrEqualPredicate.class, required=false), @XmlElement(name="in", type=InPredicate.class, required=false), @XmlElement(name="inIgnoreCase", type=InIgnoreCasePredicate.class, required=false), @XmlElement(name="lessThan", type=LessThanPredicate.class, required=false), @XmlElement(name="lessThanOrEqual", type=LessThanOrEqualPredicate.class, required=false), @XmlElement(name="like", type=LikePredicate.class, required=false), @XmlElement(name="likeIgnoreCase", type=LikeIgnoreCasePredicate.class, required=false), @XmlElement(name="notEqual", type=NotEqualPredicate.class, required=false), @XmlElement(name="notEqualIgnoreCase", type=NotEqualIgnoreCasePredicate.class, required=false), @XmlElement(name="notIn", type=NotInPredicate.class, required=false), @XmlElement(name="notInIgnoreCase", type=NotInIgnoreCasePredicate.class, required=false), @XmlElement(name="notLikeIgnoreCase", type=NotLikeIgnoreCasePredicate.class, required=false), @XmlElement(name="notLike", type=NotLikePredicate.class, required=false), @XmlElement(name="notNull", type=NotNullPredicate.class, required=false), @XmlElement(name="null", type=NullPredicate.class, required=false), @XmlElement(name="or", type=OrPredicate.class, required=false)})
    private final Set<Predicate> predicates;

    AbstractCompositePredicate() {
        this.predicates = null;
    }

    AbstractCompositePredicate(Set<Predicate> predicates) {
        if (predicates == null) {
            this.predicates = Collections.emptySet();
        } else {
            HashSet<Predicate> temp = new HashSet<Predicate>();
            for (Predicate predicate : predicates) {
                if (predicate == null) continue;
                temp.add(predicate);
            }
            this.predicates = Collections.unmodifiableSet(temp);
        }
    }

    @Override
    public Set<Predicate> getPredicates() {
        return Collections.unmodifiableSet(this.predicates);
    }

    @Override
    public final String toString() {
        StringBuilder b2 = new StringBuilder(CriteriaSupportUtils.findDynName(this.getClass().getSimpleName()));
        b2.append("(");
        if (!this.predicates.isEmpty()) {
            for (Predicate p2 : this.predicates) {
                b2.append(LINE_SEPARATOR);
                b2.append(p2);
                b2.append(", ");
            }
            b2.deleteCharAt(b2.lastIndexOf(", "));
            b2.append(LINE_SEPARATOR);
        }
        b2.append(')');
        return b2.toString();
    }

    static class Constants {
        static final String TYPE_NAME = "CompositePredicateType";

        Constants() {
        }
    }
}

