/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.criteria;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.kuali.rice.core.api.criteria.CriteriaValue;
import org.kuali.rice.core.api.util.type.KualiInteger;

@XmlRootElement(name="kualiIntegerValue")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CriteriaKualiIntegerValueType")
public final class CriteriaKualiIntegerValue
implements CriteriaValue<KualiInteger> {
    @XmlValue
    private final BigInteger value;

    CriteriaKualiIntegerValue() {
        this.value = null;
    }

    CriteriaKualiIntegerValue(KualiInteger value) {
        CriteriaKualiIntegerValue.validateValue(value);
        this.value = CriteriaKualiIntegerValue.safeInstance(value);
    }

    CriteriaKualiIntegerValue(long value) {
        CriteriaKualiIntegerValue.validateValue(value);
        this.value = new KualiInteger(value).bigIntegerValue();
    }

    CriteriaKualiIntegerValue(int value) {
        CriteriaKualiIntegerValue.validateValue(value);
        this.value = new KualiInteger(value).bigIntegerValue();
    }

    CriteriaKualiIntegerValue(String value) {
        CriteriaKualiIntegerValue.validateValue(value);
        this.value = new KualiInteger(value).bigIntegerValue();
    }

    CriteriaKualiIntegerValue(BigDecimal value) {
        CriteriaKualiIntegerValue.validateValue(value);
        this.value = new KualiInteger(value).bigIntegerValue();
    }

    private static void validateValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
    }

    private static BigInteger safeInstance(KualiInteger val) {
        return new BigInteger(val.bigIntegerValue().toString());
    }

    @Override
    public KualiInteger getValue() {
        return new KualiInteger(this.value);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(obj, this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "kualiIntegerValue";
        static final String TYPE_NAME = "CriteriaKualiIntegerValueType";

        Constants() {
        }
    }
}

