/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.criteria;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.criteria.CriteriaBooleanValue;
import org.kuali.rice.core.api.criteria.CriteriaDateTimeValue;
import org.kuali.rice.core.api.criteria.CriteriaDecimalValue;
import org.kuali.rice.core.api.criteria.CriteriaIntegerValue;
import org.kuali.rice.core.api.criteria.CriteriaKualiDecimalValue;
import org.kuali.rice.core.api.criteria.CriteriaKualiIntegerValue;
import org.kuali.rice.core.api.criteria.CriteriaKualiPercentValue;
import org.kuali.rice.core.api.criteria.CriteriaPropertyPathValue;
import org.kuali.rice.core.api.criteria.CriteriaStringValue;
import org.kuali.rice.core.api.criteria.CriteriaValue;
import org.kuali.rice.core.api.criteria.MultiValuedPredicate;
import org.kuali.rice.core.api.criteria.PropertyPath;
import org.kuali.rice.core.api.criteria.SingleValuedPredicate;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.core.api.util.type.KualiPercent;

final class CriteriaSupportUtils {
    private CriteriaSupportUtils() {
    }

    static void validateValuedConstruction(Class<? extends SingleValuedPredicate> valuedPredicateClass, String propertyPath, CriteriaValue<?> value) {
        if (StringUtils.isBlank(propertyPath)) {
            throw new IllegalArgumentException("Property path cannot be null or blank.");
        }
        if (value == null) {
            throw new IllegalArgumentException("CriteriaValue cannot be null.");
        }
        if (!CriteriaSupportUtils.supportsCriteriaValue(valuedPredicateClass, value)) {
            throw new IllegalArgumentException(valuedPredicateClass.getSimpleName() + " does not support the given CriteriaValue");
        }
    }

    static boolean supportsCriteriaValue(Class<? extends SingleValuedPredicate> simplePredicateClass, CriteriaValue<?> value) {
        if (simplePredicateClass == null) {
            throw new IllegalArgumentException("simplePredicateClass was null");
        }
        if (value == null) {
            throw new IllegalArgumentException("valueClass was null");
        }
        XmlElements elementsAnnotation = CriteriaSupportUtils.findXmlElementsAnnotation(simplePredicateClass);
        if (elementsAnnotation != null) {
            XmlElement[] elements;
            for (XmlElement element : elements = elementsAnnotation.value()) {
                if (!value.getClass().equals(element.type())) continue;
                return true;
            }
        }
        return false;
    }

    private static XmlElements findXmlElementsAnnotation(Class<?> simplePredicateClass) {
        if (simplePredicateClass != null) {
            XmlElements elementsAnnotation;
            try {
                Field valueField = simplePredicateClass.getDeclaredField("value");
                elementsAnnotation = valueField.getAnnotation(XmlElements.class);
                if (elementsAnnotation != null) {
                    return elementsAnnotation;
                }
            }
            catch (NoSuchFieldException valueField) {
                // empty catch block
            }
            try {
                Method valueMethod = simplePredicateClass.getDeclaredMethod("getValue", null);
                elementsAnnotation = valueMethod.getAnnotation(XmlElements.class);
                if (elementsAnnotation == null) {
                    return CriteriaSupportUtils.findXmlElementsAnnotation(simplePredicateClass.getSuperclass());
                }
                return elementsAnnotation;
            }
            catch (NoSuchMethodException e2) {
                return CriteriaSupportUtils.findXmlElementsAnnotation(simplePredicateClass.getSuperclass());
            }
        }
        return null;
    }

    static CriteriaValue<?> determineCriteriaValue(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Given criteria value cannot be null.");
        }
        if (object instanceof CharSequence) {
            return new CriteriaStringValue((CharSequence)object);
        }
        if (object instanceof Boolean) {
            return new CriteriaBooleanValue((Boolean)object);
        }
        if (object instanceof DateTime) {
            return new CriteriaDateTimeValue((DateTime)object);
        }
        if (object instanceof Calendar) {
            return new CriteriaDateTimeValue((Calendar)object);
        }
        if (object instanceof Date) {
            return new CriteriaDateTimeValue((Date)object);
        }
        if (object instanceof BigInteger) {
            return new CriteriaIntegerValue((BigInteger)object);
        }
        if (object instanceof Short) {
            return new CriteriaIntegerValue((Short)object);
        }
        if (object instanceof Integer) {
            return new CriteriaIntegerValue((Integer)object);
        }
        if (object instanceof AtomicInteger) {
            return new CriteriaIntegerValue((AtomicInteger)object);
        }
        if (object instanceof Long) {
            return new CriteriaIntegerValue((Long)object);
        }
        if (object instanceof AtomicLong) {
            return new CriteriaIntegerValue((AtomicLong)object);
        }
        if (object instanceof BigDecimal) {
            return new CriteriaDecimalValue((BigDecimal)object);
        }
        if (object instanceof Float) {
            return new CriteriaDecimalValue((Float)object);
        }
        if (object instanceof Double) {
            return new CriteriaDecimalValue((Double)object);
        }
        if (object instanceof KualiPercent) {
            return new CriteriaKualiPercentValue((KualiPercent)object);
        }
        if (object instanceof KualiDecimal) {
            return new CriteriaKualiDecimalValue((KualiDecimal)object);
        }
        if (object instanceof KualiInteger) {
            return new CriteriaKualiIntegerValue((KualiInteger)object);
        }
        if (object instanceof PropertyPath) {
            return new CriteriaPropertyPathValue((PropertyPath)object);
        }
        if (object instanceof CriteriaValue) {
            return (CriteriaValue)object;
        }
        throw new IllegalArgumentException("Failed to translate the given object to a CriteriaValue: " + object);
    }

    static Set<CriteriaValue<?>> determineCriteriaValueList(Object[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Collections.emptySet();
        }
        HashSet criteriaValues = new HashSet();
        for (Object value : values) {
            if (value == null) continue;
            criteriaValues.add(CriteriaSupportUtils.determineCriteriaValue(value));
        }
        return criteriaValues;
    }

    static Set<CriteriaValue<?>> determineCriteriaValueList(Collection<?> values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet criteriaValues = new HashSet();
        for (Object value : values) {
            if (value == null) continue;
            criteriaValues.add(CriteriaSupportUtils.determineCriteriaValue(value));
        }
        return criteriaValues;
    }

    static Set<CriteriaStringValue> createCriteriaStringValueList(CharSequence[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Collections.emptySet();
        }
        HashSet<CriteriaStringValue> criteriaValues = new HashSet<CriteriaStringValue>();
        for (CharSequence value : values) {
            if (value == null) continue;
            criteriaValues.add(new CriteriaStringValue(value));
        }
        return criteriaValues;
    }

    static Set<CriteriaStringValue> createCriteriaStringValueList(Collection<? extends CharSequence> values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<CriteriaStringValue> criteriaValues = new HashSet<CriteriaStringValue>();
        for (CharSequence charSequence : values) {
            if (charSequence == null) continue;
            criteriaValues.add(new CriteriaStringValue(charSequence));
        }
        return criteriaValues;
    }

    static void validateValuesForMultiValuedPredicate(Set<? extends CriteriaValue<?>> values) {
        if (values == null) {
            throw new IllegalArgumentException("Criteria values cannot be null.");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException("Criteria values cannot be empty.");
        }
        Class<?> previousType = null;
        for (CriteriaValue<?> value : values) {
            Class<?> currentType = value.getClass();
            if (previousType != null && !currentType.equals(previousType)) {
                throw new IllegalArgumentException("Encountered criteria values which do not match.  One was: " + previousType + " the other was: " + currentType);
            }
            previousType = currentType;
        }
    }

    static String findDynName(String name) {
        String correctedName = StringUtils.uncapitalize(name).replace("Predicate", "");
        if (correctedName.equals("null")) {
            correctedName = "isNull";
        } else if (correctedName.equals("notNull")) {
            correctedName = "isNotNull";
        }
        return correctedName;
    }

    public static String toString(SingleValuedPredicate p2) {
        return CriteriaSupportUtils.findDynName(p2.getClass().getSimpleName()) + "(" + p2.getPropertyPath() + ", " + p2.getValue().getValue() + ")";
    }

    public static String toString(MultiValuedPredicate p2) {
        ArrayList<String> values = new ArrayList<String>();
        for (CriteriaValue<?> value : p2.getValues()) {
            values.add(value.getValue().toString());
        }
        return CriteriaSupportUtils.findDynName(p2.getClass().getSimpleName()) + "(" + p2.getPropertyPath() + ", " + "[" + StringUtils.join(values, ", ") + "]" + ")";
    }

    static class PropertyConstants {
        static final String PROPERTY_PATH = "propertyPath";
        static final String VALUE = "value";
        static final String GET_VALUE_METHOD_NAME = "getValue";
        static final String VALUES = "values";
        static final String GET_VALUES_METHOD_NAME = "getValues";

        PropertyConstants() {
        }
    }
}

