/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.criteria;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.AbstractPredicate;
import org.kuali.rice.core.api.criteria.CriteriaDateTimeValue;
import org.kuali.rice.core.api.criteria.CriteriaDecimalValue;
import org.kuali.rice.core.api.criteria.CriteriaIntegerValue;
import org.kuali.rice.core.api.criteria.CriteriaKualiDecimalValue;
import org.kuali.rice.core.api.criteria.CriteriaKualiIntegerValue;
import org.kuali.rice.core.api.criteria.CriteriaKualiPercentValue;
import org.kuali.rice.core.api.criteria.CriteriaStringValue;
import org.kuali.rice.core.api.criteria.CriteriaSupportUtils;
import org.kuali.rice.core.api.criteria.CriteriaValue;
import org.kuali.rice.core.api.criteria.MultiValuedPredicate;
import org.w3c.dom.Element;

@XmlRootElement(name="in")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="InType", propOrder={"values", "_futureElements"})
public final class InPredicate
extends AbstractPredicate
implements MultiValuedPredicate {
    private static final long serialVersionUID = -1888858317314153374L;
    @XmlAttribute(name="propertyPath")
    private final String propertyPath;
    @XmlElements(value={@XmlElement(name="stringValue", type=CriteriaStringValue.class, required=true), @XmlElement(name="dateTimeValue", type=CriteriaDateTimeValue.class, required=true), @XmlElement(name="integerValue", type=CriteriaIntegerValue.class, required=true), @XmlElement(name="kualiDecimalValue", type=CriteriaKualiDecimalValue.class, required=true), @XmlElement(name="kualiPercentValue", type=CriteriaKualiPercentValue.class, required=true), @XmlElement(name="kualiIntegerValue", type=CriteriaKualiIntegerValue.class, required=true), @XmlElement(name="decimalValue", type=CriteriaDecimalValue.class, required=true)})
    private final Set<? extends CriteriaValue<?>> values;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private InPredicate() {
        this.propertyPath = null;
        this.values = null;
    }

    InPredicate(String propertyPath, Set<? extends CriteriaValue<?>> values) {
        if (StringUtils.isBlank(propertyPath)) {
            throw new IllegalArgumentException("Property path cannot be null or blank.");
        }
        CriteriaSupportUtils.validateValuesForMultiValuedPredicate(values);
        this.propertyPath = propertyPath;
        if (values == null) {
            this.values = Collections.emptySet();
        } else {
            HashSet temp = new HashSet();
            for (CriteriaValue<?> value : values) {
                if (value == null) continue;
                temp.add(value);
            }
            this.values = Collections.unmodifiableSet(temp);
        }
    }

    @Override
    public String getPropertyPath() {
        return this.propertyPath;
    }

    public Set<CriteriaValue<?>> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    @Override
    public String toString() {
        return CriteriaSupportUtils.toString(this);
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "in";
        static final String TYPE_NAME = "InType";

        Constants() {
        }
    }
}

