/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.criteria;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.AndPredicate;
import org.kuali.rice.core.api.criteria.CriteriaPropertyPathValue;
import org.kuali.rice.core.api.criteria.CriteriaStringValue;
import org.kuali.rice.core.api.criteria.CriteriaSupportUtils;
import org.kuali.rice.core.api.criteria.EqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.EqualPredicate;
import org.kuali.rice.core.api.criteria.ExistsSubQueryPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanPredicate;
import org.kuali.rice.core.api.criteria.InIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.InPredicate;
import org.kuali.rice.core.api.criteria.LessThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.LessThanPredicate;
import org.kuali.rice.core.api.criteria.LikeIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.LikePredicate;
import org.kuali.rice.core.api.criteria.NotEqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotEqualPredicate;
import org.kuali.rice.core.api.criteria.NotInIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotInPredicate;
import org.kuali.rice.core.api.criteria.NotLikeIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotLikePredicate;
import org.kuali.rice.core.api.criteria.NotNullPredicate;
import org.kuali.rice.core.api.criteria.NullPredicate;
import org.kuali.rice.core.api.criteria.OrPredicate;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PropertyPath;
import org.kuali.rice.core.api.search.SearchOperator;

public final class PredicateFactory {
    private PredicateFactory() {
        throw new IllegalArgumentException("do not call");
    }

    public static Predicate equal(String propertyPath, Object value) {
        return new EqualPredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValue(value));
    }

    public static Predicate equalsProperty(String propertyPath, String targetDataType, String targetPropertyPath) {
        return new EqualPredicate(propertyPath, new CriteriaPropertyPathValue(new PropertyPath(targetDataType, targetPropertyPath)));
    }

    public static Predicate notEqual(String propertyPath, Object value) {
        return new NotEqualPredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValue(value));
    }

    public static Predicate notEqualsProperty(String propertyPath, String targetDataType, String targetPropertyPath) {
        return new NotEqualPredicate(propertyPath, new CriteriaPropertyPathValue(new PropertyPath(targetDataType, targetPropertyPath)));
    }

    public static Predicate equalIgnoreCase(String propertyPath, CharSequence value) {
        return new EqualIgnoreCasePredicate(propertyPath, new CriteriaStringValue(value));
    }

    public static Predicate likeIgnoreCase(String propertyPath, CharSequence value) {
        return new LikeIgnoreCasePredicate(propertyPath, new CriteriaStringValue(value));
    }

    public static Predicate notLikeIgnoreCase(String propertyPath, CharSequence value) {
        return new NotLikeIgnoreCasePredicate(propertyPath, new CriteriaStringValue(value));
    }

    public static Predicate notEqualIgnoreCase(String propertyPath, CharSequence value) {
        return new NotEqualIgnoreCasePredicate(propertyPath, new CriteriaStringValue(value));
    }

    public static Predicate like(String propertyPath, CharSequence value) {
        return new LikePredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValue(value));
    }

    public static Predicate notLike(String propertyPath, CharSequence value) {
        return new NotLikePredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValue(value));
    }

    public static <T> Predicate in(String propertyPath, Collection<T> values) {
        return new InPredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValueList(values));
    }

    public static <T> Predicate in(String propertyPath, T ... values) {
        return new InPredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValueList(values));
    }

    public static <T> Predicate notIn(String propertyPath, T ... values) {
        return new NotInPredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValueList(values));
    }

    public static <T> Predicate notIn(String propertyPath, Collection<T> values) {
        return new NotInPredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValueList(values));
    }

    public static <T extends CharSequence> Predicate inIgnoreCase(String propertyPath, T ... values) {
        return new InIgnoreCasePredicate(propertyPath, CriteriaSupportUtils.createCriteriaStringValueList(values));
    }

    public static <T extends CharSequence> Predicate inIgnoreCase(String propertyPath, Collection<T> values) {
        return new InIgnoreCasePredicate(propertyPath, CriteriaSupportUtils.createCriteriaStringValueList(values));
    }

    public static <T extends CharSequence> Predicate notInIgnoreCase(String propertyPath, T ... values) {
        return new NotInIgnoreCasePredicate(propertyPath, CriteriaSupportUtils.createCriteriaStringValueList(values));
    }

    public static <T extends CharSequence> Predicate notInIgnoreCase(String propertyPath, Collection<T> values) {
        return new NotInIgnoreCasePredicate(propertyPath, CriteriaSupportUtils.createCriteriaStringValueList(values));
    }

    public static Predicate greaterThan(String propertyPath, Object value) {
        return new GreaterThanPredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValue(value));
    }

    public static Predicate greaterThanOrEqual(String propertyPath, Object value) {
        return new GreaterThanOrEqualPredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValue(value));
    }

    public static Predicate lessThan(String propertyPath, Object value) {
        return new LessThanPredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValue(value));
    }

    public static Predicate lessThanOrEqual(String propertyPath, Object value) {
        return new LessThanOrEqualPredicate(propertyPath, CriteriaSupportUtils.determineCriteriaValue(value));
    }

    public static Predicate isNull(String propertyPath) {
        return new NullPredicate(propertyPath);
    }

    public static Predicate isNotNull(String propertyPath) {
        return new NotNullPredicate(propertyPath);
    }

    public static Predicate between(String propertyPath, Object value1, Object value2) {
        return PredicateFactory.between(propertyPath, value1, value2, SearchOperator.BETWEEN);
    }

    public static Predicate notBetween(String propertyPath, Object value1, Object value2) {
        return PredicateFactory.notBetween(propertyPath, value1, value2, SearchOperator.BETWEEN);
    }

    public static Predicate between(String propertyPath, Object value1, Object value2, SearchOperator betweenType) {
        Predicate upper;
        Predicate lower;
        switch (betweenType) {
            case BETWEEN: {
                lower = PredicateFactory.greaterThanOrEqual(propertyPath, value1);
                upper = PredicateFactory.lessThanOrEqual(propertyPath, value2);
                break;
            }
            case BETWEEN_EXCLUSIVE: {
                lower = PredicateFactory.greaterThan(propertyPath, value1);
                upper = PredicateFactory.lessThan(propertyPath, value2);
                break;
            }
            case BETWEEN_EXCLUSIVE_LOWER: {
                lower = PredicateFactory.greaterThan(propertyPath, value1);
                upper = PredicateFactory.lessThanOrEqual(propertyPath, value2);
                break;
            }
            case BETWEEN_EXCLUSIVE_UPPER: 
            case BETWEEN_EXCLUSIVE_UPPER2: {
                lower = PredicateFactory.greaterThanOrEqual(propertyPath, value1);
                upper = PredicateFactory.lessThan(propertyPath, value2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid between operator: " + betweenType);
            }
        }
        return PredicateFactory.and(lower, upper);
    }

    public static Predicate notBetween(String propertyPath, Object value1, Object value2, SearchOperator betweenType) {
        Predicate upper;
        Predicate lower;
        switch (betweenType) {
            case BETWEEN: {
                lower = PredicateFactory.lessThan(propertyPath, value1);
                upper = PredicateFactory.greaterThan(propertyPath, value2);
                break;
            }
            case BETWEEN_EXCLUSIVE: {
                lower = PredicateFactory.lessThanOrEqual(propertyPath, value1);
                upper = PredicateFactory.greaterThanOrEqual(propertyPath, value2);
                break;
            }
            case BETWEEN_EXCLUSIVE_LOWER: {
                lower = PredicateFactory.lessThanOrEqual(propertyPath, value1);
                upper = PredicateFactory.greaterThan(propertyPath, value2);
                break;
            }
            case BETWEEN_EXCLUSIVE_UPPER: 
            case BETWEEN_EXCLUSIVE_UPPER2: {
                lower = PredicateFactory.lessThan(propertyPath, value1);
                upper = PredicateFactory.greaterThanOrEqual(propertyPath, value2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid between operator: " + betweenType);
            }
        }
        return PredicateFactory.and(lower, upper);
    }

    public static Predicate and(Predicate ... predicates) {
        if (predicates != null && predicates.length == 1 && predicates[0] != null) {
            return predicates[0];
        }
        HashSet<Predicate> predicateSet = new HashSet<Predicate>();
        CollectionUtils.addAll(predicateSet, predicates);
        return new AndPredicate(predicateSet);
    }

    public static Predicate or(Predicate ... predicates) {
        if (predicates != null && predicates.length == 1 && predicates[0] != null) {
            return predicates[0];
        }
        HashSet<Predicate> predicateSet = new HashSet<Predicate>();
        CollectionUtils.addAll(predicateSet, predicates);
        return new OrPredicate(predicateSet);
    }

    public static Predicate existsSubquery(String subQueryType, Predicate subQueryPredicate) {
        if (StringUtils.isBlank(subQueryType)) {
            throw new IllegalArgumentException("subQueryBaseClass is blank or null");
        }
        return new ExistsSubQueryPredicate(subQueryType, subQueryPredicate);
    }

    public static Predicate dynConstruct(String name, Object ... args) {
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException("name is blank");
        }
        String correctedName = CriteriaSupportUtils.findDynName(name);
        block3: for (Method m3 : PredicateFactory.class.getMethods()) {
            if (!m3.getName().equals(correctedName)) continue;
            Class<?>[] parameterTypes = m3.getParameterTypes();
            for (int parameterIndex = 0; parameterIndex < parameterTypes.length; ++parameterIndex) {
                Class<?> parameterType = parameterTypes[parameterIndex];
                Object arg = args[parameterIndex];
                if (arg != null && !parameterType.isInstance(arg)) continue block3;
            }
            try {
                return (Predicate)m3.invoke(null, args);
            }
            catch (InvocationTargetException e2) {
                throw new DynPredicateException(e2);
            }
            catch (IllegalAccessException e3) {
                throw new DynPredicateException(e3);
            }
        }
        throw new DynPredicateException("predicate: " + name + " doesn't exist");
    }

    private static class DynPredicateException
    extends RuntimeException {
        DynPredicateException(Throwable t2) {
            super(t2);
        }

        DynPredicateException(String s2) {
            super(s2);
        }
    }
}

