/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.search.SearchOperator;

public final class PredicateUtils {
    private PredicateUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static Predicate convertObjectMapToPredicate(Map<String, Object> criteria) {
        ArrayList<Predicate> p2 = new ArrayList<Predicate>();
        for (Map.Entry<String, Object> entry : criteria.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof String) {
                p2.add(PredicateFactory.equalIgnoreCase(entry.getKey(), (String)entry.getValue()));
                continue;
            }
            p2.add(PredicateFactory.equal(entry.getKey(), entry.getValue()));
        }
        return PredicateFactory.and(p2.toArray(new Predicate[p2.size()]));
    }

    public static Predicate convertMapToPredicate(Map<String, String> criteria) {
        ArrayList p2 = new ArrayList();
        for (Map.Entry<String, String> entry : criteria.entrySet()) {
            if (!StringUtils.isNotBlank(entry.getValue())) continue;
            ArrayList<String> values = new ArrayList<String>();
            PredicateUtils.getValueRecursive(entry.getValue(), values);
            ArrayList<Predicate> tempPredicates = new ArrayList<Predicate>();
            p2.addAll(tempPredicates);
            for (String value : values) {
                tempPredicates.add(PredicateUtils.parsePredicate(entry.getKey(), value));
            }
            if (entry.getValue().contains(SearchOperator.AND.op())) {
                p2.add(PredicateFactory.and(tempPredicates.toArray(new Predicate[tempPredicates.size()])));
                continue;
            }
            if (entry.getValue().contains(SearchOperator.OR.op())) {
                p2.add(PredicateFactory.or(tempPredicates.toArray(new Predicate[tempPredicates.size()])));
                continue;
            }
            p2.addAll(tempPredicates);
        }
        return PredicateFactory.and(p2.toArray(new Predicate[p2.size()]));
    }

    private static Predicate parsePredicate(String key, String value) {
        if (value.contains(SearchOperator.NULL.op())) {
            if (PredicateUtils.isNot(value)) {
                return PredicateFactory.isNotNull(key);
            }
            return PredicateFactory.isNull(key);
        }
        if (value.contains(SearchOperator.BETWEEN_EXCLUSIVE_UPPER.op())) {
            String[] betweenVals = StringUtils.split(value, SearchOperator.BETWEEN_EXCLUSIVE_UPPER.op());
            if (betweenVals.length == 2) {
                return PredicateFactory.between(key, betweenVals[0], betweenVals[1], SearchOperator.BETWEEN_EXCLUSIVE_UPPER);
            }
            return null;
        }
        if (value.contains(SearchOperator.BETWEEN.op())) {
            String[] betweenVals = StringUtils.split(value, SearchOperator.BETWEEN.op());
            if (betweenVals.length == 2) {
                return PredicateFactory.between(key, betweenVals[0], betweenVals[1]);
            }
            return null;
        }
        if (value.contains(SearchOperator.GREATER_THAN_EQUAL.op())) {
            return PredicateFactory.greaterThanOrEqual(key, StringUtils.replace(value, SearchOperator.GREATER_THAN_EQUAL.op(), ""));
        }
        if (value.contains(SearchOperator.LESS_THAN_EQUAL.op())) {
            return PredicateFactory.lessThanOrEqual(key, StringUtils.replace(value, SearchOperator.LESS_THAN_EQUAL.op(), ""));
        }
        if (value.contains(SearchOperator.GREATER_THAN.op())) {
            return PredicateFactory.greaterThan(key, StringUtils.replace(value, SearchOperator.GREATER_THAN.op(), ""));
        }
        if (value.contains(SearchOperator.LESS_THAN.op())) {
            return PredicateFactory.lessThan(key, StringUtils.replace(value, SearchOperator.LESS_THAN.op(), ""));
        }
        if (value.contains(SearchOperator.LIKE_MANY.op()) || value.contains(SearchOperator.LIKE_ONE.op())) {
            if (PredicateUtils.isNot(value)) {
                return PredicateFactory.notLikeIgnoreCase(key, PredicateUtils.stripNot(value));
            }
            return PredicateFactory.likeIgnoreCase(key, value);
        }
        if (PredicateUtils.isNot(value)) {
            return PredicateFactory.notEqualIgnoreCase(key, PredicateUtils.stripNot(value));
        }
        return PredicateFactory.equalIgnoreCase(key, value);
    }

    private static void getValueRecursive(String valueEntered, List<String> lRet) {
        if (valueEntered == null) {
            return;
        }
        valueEntered = valueEntered.trim();
        valueEntered = valueEntered.replaceAll("%", "*");
        if (lRet == null) {
            throw new NullPointerException("The list passed in is by reference and should never be null.");
        }
        if (StringUtils.contains(valueEntered, SearchOperator.OR.op())) {
            List<String> l2 = Arrays.asList(StringUtils.split(valueEntered, SearchOperator.OR.op()));
            for (String value : l2) {
                PredicateUtils.getValueRecursive(value, lRet);
            }
            return;
        }
        if (StringUtils.contains(valueEntered, SearchOperator.AND.op())) {
            List<String> l3 = Arrays.asList(StringUtils.split(valueEntered, SearchOperator.AND.op()));
            for (String value : l3) {
                PredicateUtils.getValueRecursive(value, lRet);
            }
            return;
        }
        lRet.add(valueEntered);
    }

    private static boolean isNot(String value) {
        if (value == null) {
            return false;
        }
        return value.contains(SearchOperator.NOT.op());
    }

    private static String stripNot(String value) {
        if (value.trim().startsWith(SearchOperator.NOT.op())) {
            value = value.trim().replaceFirst(SearchOperator.NOT.op(), "");
        }
        return value;
    }
}

