/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.criteria;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.rice.core.api.criteria.AndPredicate;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.EqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.EqualPredicate;
import org.kuali.rice.core.api.criteria.ExistsSubQueryPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanPredicate;
import org.kuali.rice.core.api.criteria.InIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.InPredicate;
import org.kuali.rice.core.api.criteria.LessThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.LessThanPredicate;
import org.kuali.rice.core.api.criteria.LikeIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.LikePredicate;
import org.kuali.rice.core.api.criteria.NotEqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotEqualPredicate;
import org.kuali.rice.core.api.criteria.NotInIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotInPredicate;
import org.kuali.rice.core.api.criteria.NotLikeIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotLikePredicate;
import org.kuali.rice.core.api.criteria.NotNullPredicate;
import org.kuali.rice.core.api.criteria.NullPredicate;
import org.kuali.rice.core.api.criteria.OrPredicate;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.collect.CollectionUtils;
import org.w3c.dom.Element;

@XmlRootElement(name="queryByCriteria")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="QueryByCriteriaType", propOrder={"predicate", "startAtIndex", "maxResults", "countFlag", "orderByFields", "_futureElements"})
public final class QueryByCriteria
extends AbstractDataTransferObject {
    private static final long serialVersionUID = 2210627777648920180L;
    @XmlElements(value={@XmlElement(name="and", type=AndPredicate.class, required=false), @XmlElement(name="equal", type=EqualPredicate.class, required=false), @XmlElement(name="equalIgnoreCase", type=EqualIgnoreCasePredicate.class, required=false), @XmlElement(name="existsSubQuery", type=ExistsSubQueryPredicate.class, required=false), @XmlElement(name="greaterThan", type=GreaterThanPredicate.class, required=false), @XmlElement(name="greaterThanOrEqual", type=GreaterThanOrEqualPredicate.class, required=false), @XmlElement(name="in", type=InPredicate.class, required=false), @XmlElement(name="inIgnoreCase", type=InIgnoreCasePredicate.class, required=false), @XmlElement(name="lessThan", type=LessThanPredicate.class, required=false), @XmlElement(name="lessThanOrEqual", type=LessThanOrEqualPredicate.class, required=false), @XmlElement(name="like", type=LikePredicate.class, required=false), @XmlElement(name="likeIgnoreCase", type=LikeIgnoreCasePredicate.class, required=false), @XmlElement(name="notEqual", type=NotEqualPredicate.class, required=false), @XmlElement(name="notEqualIgnoreCase", type=NotEqualIgnoreCasePredicate.class, required=false), @XmlElement(name="notIn", type=NotInPredicate.class, required=false), @XmlElement(name="notInIgnoreCase", type=NotInIgnoreCasePredicate.class, required=false), @XmlElement(name="notLikeIgnoreCase", type=NotLikeIgnoreCasePredicate.class, required=false), @XmlElement(name="notLike", type=NotLikePredicate.class, required=false), @XmlElement(name="notNull", type=NotNullPredicate.class, required=false), @XmlElement(name="null", type=NullPredicate.class, required=false), @XmlElement(name="or", type=OrPredicate.class, required=false)})
    private final Predicate predicate;
    @XmlElement(name="startAtIndex", required=false)
    private final Integer startAtIndex;
    @XmlElement(name="maxResults", required=false)
    private final Integer maxResults;
    @XmlJavaTypeAdapter(value=CountFlag.Adapter.class)
    @XmlElement(name="countFlag", required=true)
    private final String countFlag;
    @XmlElementWrapper(name="orderByFields", required=false)
    @XmlElement(name="orderByField", required=false)
    private final List<OrderByField> orderByFields;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private QueryByCriteria() {
        this.predicate = null;
        this.startAtIndex = null;
        this.maxResults = null;
        this.countFlag = null;
        this.orderByFields = null;
    }

    private QueryByCriteria(Builder builder) {
        Predicate[] preds = builder.predicates;
        this.predicate = preds != null && preds.length > 1 ? PredicateFactory.and(builder.predicates) : (preds != null && preds.length == 1 ? builder.predicates[0] : null);
        this.startAtIndex = builder.getStartAtIndex();
        this.maxResults = builder.getMaxResults();
        this.countFlag = builder.getCountFlag() == null ? null : builder.getCountFlag().getFlag();
        this.orderByFields = new ArrayList<OrderByField>(builder.getOrderByFields());
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Integer getStartAtIndex() {
        return this.startAtIndex;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public CountFlag getCountFlag() {
        return this.countFlag == null ? null : CountFlag.valueOf(this.countFlag);
    }

    public List<OrderByField> getOrderByFields() {
        return CollectionUtils.unmodifiableListNullSafe(this.orderByFields);
    }

    static class Elements {
        static final String PREDICATE = "predicate";
        static final String START_AT_INDEX = "startAtIndex";
        static final String MAX_RESULTS = "maxResults";
        static final String COUNT_FLAG = "countFlag";
        static final String ORDER_BY_FIELDS = "orderByFields";
        static final String ORDER_BY_FIELD = "orderByField";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "queryByCriteria";
        static final String TYPE_NAME = "QueryByCriteriaType";

        Constants() {
        }
    }

    public static final class Builder
    implements ModelBuilder,
    Serializable {
        private Predicate[] predicates;
        private Integer startAtIndex;
        private Integer maxResults;
        private CountFlag countFlag;
        private List<OrderByField> orderByFields;

        private Builder() {
            this.setCountFlag(CountFlag.NONE);
            this.setOrderByFields(new ArrayList<OrderByField>());
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(QueryByCriteria queryByCriteria) {
            Builder builder = new Builder();
            builder.setPredicates(queryByCriteria.getPredicate());
            builder.setStartAtIndex(queryByCriteria.getStartAtIndex());
            builder.setMaxResults(queryByCriteria.getMaxResults());
            builder.setCountFlag(queryByCriteria.getCountFlag());
            builder.setOrderByFields(queryByCriteria.getOrderByFields());
            return builder;
        }

        public Integer getStartAtIndex() {
            return this.startAtIndex;
        }

        public void setStartAtIndex(Integer startAtIndex) {
            if (startAtIndex != null && startAtIndex < 0) {
                throw new IllegalArgumentException("startAtIndex < 0");
            }
            this.startAtIndex = startAtIndex;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        public void setMaxResults(Integer maxResults) {
            if (maxResults != null && maxResults < 0) {
                throw new IllegalArgumentException("maxResults < 0");
            }
            this.maxResults = maxResults;
        }

        public CountFlag getCountFlag() {
            return this.countFlag;
        }

        public Builder setCountFlag(CountFlag countFlag) {
            if (countFlag == null) {
                throw new IllegalArgumentException("countFlag was null");
            }
            this.countFlag = countFlag;
            return this;
        }

        public List<OrderByField> getOrderByFields() {
            return this.orderByFields;
        }

        public Builder setOrderByFields(List<OrderByField> orderByFields) {
            if (orderByFields == null) {
                throw new IllegalArgumentException("orderByFields was null");
            }
            this.orderByFields = orderByFields;
            return this;
        }

        public Builder setOrderByFields(OrderByField ... orderByFields) {
            if (orderByFields == null) {
                throw new IllegalArgumentException("orderByFields was null");
            }
            this.setOrderByFields(new ArrayList<OrderByField>(Arrays.asList(orderByFields)));
            return this;
        }

        public Builder setOrderByAscending(String ... orderByFields) {
            if (orderByFields == null) {
                throw new IllegalArgumentException("orderByFields was null");
            }
            ArrayList<OrderByField> obf = new ArrayList<OrderByField>(orderByFields.length);
            for (String fieldName : orderByFields) {
                obf.add(OrderByField.Builder.create(fieldName, OrderDirection.ASCENDING).build());
            }
            this.setOrderByFields(obf);
            return this;
        }

        public Predicate[] getPredicates() {
            if (this.predicates == null) {
                return null;
            }
            return Arrays.copyOf(this.predicates, this.predicates.length);
        }

        public Builder setPredicates(Predicate ... predicates) {
            this.predicates = predicates != null ? Arrays.copyOf(predicates, predicates.length) : null;
            return this;
        }

        @Override
        public QueryByCriteria build() {
            return new QueryByCriteria(this);
        }

        public static QueryByCriteria fromPredicates(Predicate ... predicates) {
            Builder b2 = Builder.create();
            b2.setPredicates(predicates);
            return b2.build();
        }

        public static QueryByCriteria fromPredicates(Collection<Predicate> predicates) {
            Builder b2 = Builder.create();
            if (predicates != null) {
                b2.setPredicates(predicates.toArray(new Predicate[predicates.size()]));
            } else {
                b2.setPredicates(null);
            }
            return b2.build();
        }

        public static Builder orAttributes(Map<String, ?> attributes) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (attributes != null) {
                for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                    if (entry.getValue() instanceof Collection) {
                        for (Object entryVal : (Collection)entry.getValue()) {
                            predicates.add(Builder.buildPredicate(entry.getKey(), entryVal));
                        }
                        continue;
                    }
                    predicates.add(Builder.buildPredicate(entry.getKey(), entry.getValue()));
                }
            }
            Builder qbc = Builder.create();
            qbc.setPredicates(PredicateFactory.or(predicates.toArray(new Predicate[predicates.size()])));
            return qbc;
        }

        public static Builder andAttributes(Map<String, ?> attributes) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (attributes != null) {
                for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                    if (entry.getValue() instanceof Collection) {
                        Collection values = (Collection)entry.getValue();
                        if (values.isEmpty()) continue;
                        ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
                        for (Object entryVal : values) {
                            orPredicates.add(Builder.buildPredicate(entry.getKey(), entryVal));
                        }
                        predicates.add(PredicateFactory.or(orPredicates.toArray(new Predicate[orPredicates.size()])));
                        continue;
                    }
                    predicates.add(Builder.buildPredicate(entry.getKey(), entry.getValue()));
                }
            }
            Builder qbc = Builder.create();
            qbc.setPredicates(PredicateFactory.and(predicates.toArray(new Predicate[predicates.size()])));
            return qbc;
        }

        private static Predicate buildPredicate(String attributeKey, Object attributeValue) {
            if (attributeValue == null) {
                return PredicateFactory.isNull(attributeKey);
            }
            return PredicateFactory.equal(attributeKey, attributeValue);
        }

        public static Builder forAttribute(String name, Object value) {
            HashMap<String, Object> attrib = new HashMap<String, Object>();
            attrib.put(name, value);
            return Builder.andAttributes(attrib);
        }

        public static Builder orAttributes(Object object, Collection<String> attributes) {
            return Builder.orAttributes(Builder.getAttributeValueMap(object, attributes));
        }

        public static Builder andAttributes(Object object, Collection<String> attributes) {
            return Builder.andAttributes(Builder.getAttributeValueMap(object, attributes));
        }

        private static Map<String, ?> getAttributeValueMap(Object object, Collection<String> attribNames) {
            HashMap<String, Object> attributeMap = new HashMap<String, Object>();
            for (String attr : attribNames) {
                Object value;
                try {
                    value = PropertyUtils.getProperty(object, attr);
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException(iae);
                }
                catch (InvocationTargetException ite) {
                    throw new RuntimeException(ite);
                }
                catch (NoSuchMethodException nsme) {
                    throw new RuntimeException(nsme);
                }
                attributeMap.put(attr, value);
            }
            return attributeMap;
        }
    }
}

