/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.impex.xml;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.impex.xml.BaseXmlDoc;
import org.kuali.rice.core.api.impex.xml.XmlDocCollection;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class LocationXmlDoc
extends BaseXmlDoc {
    private final String location;
    private final Resource resource;
    private final String name;

    public LocationXmlDoc(String location, XmlDocCollection collection) {
        this(location, LocationXmlDoc.getName(location), collection);
    }

    public LocationXmlDoc(String location, String name, XmlDocCollection collection) {
        super(collection);
        Preconditions.checkArgument(!StringUtils.isBlank(location), "'location' cannot be blank");
        Preconditions.checkArgument(!StringUtils.isBlank(name), "'name' cannot be blank");
        Preconditions.checkNotNull(collection, "'collection' cannot be null");
        this.location = location;
        this.name = name;
        this.resource = LocationXmlDoc.getResource(location);
        Preconditions.checkArgument(this.resource.exists(), "[" + location + "] does not exist");
    }

    static Resource getResource(String location) {
        if (LocationXmlDoc.isExistingFile(location)) {
            return new FileSystemResource(location);
        }
        DefaultResourceLoader loader = new DefaultResourceLoader();
        return loader.getResource(location);
    }

    static boolean isExistingFile(String location) {
        return new File(location).exists();
    }

    static String getName(String location) {
        Resource resource = LocationXmlDoc.getResource(location);
        return resource.getFilename();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getStream() throws IOException {
        return this.resource.getInputStream();
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object o2) {
        if (o2 == null || o2.getClass() != this.getClass()) {
            return false;
        }
        LocationXmlDoc doc = (LocationXmlDoc)o2;
        return this.location.equals(doc.getLocation());
    }

    public String getLocation() {
        return this.location;
    }
}

