/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.impex.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.kuali.rice.core.api.impex.xml.BaseXmlDoc;
import org.kuali.rice.core.api.impex.xml.XmlDocCollection;

public class StreamXmlDoc
extends BaseXmlDoc {
    private byte[] bytes;
    private InputStream stream;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public StreamXmlDoc(InputStream stream, XmlDocCollection collection) {
        super(collection);
        this.stream = stream;
    }

    @Override
    public synchronized InputStream getStream() throws IOException {
        if (this.bytes == null) {
            this.bytes = StreamXmlDoc.toByteArray(this.stream);
        }
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public String getName() {
        return this.stream.toString();
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StreamXmlDoc.copy(input, output);
        return output.toByteArray();
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        long count = StreamXmlDoc.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n2 = 0;
        while (-1 != (n2 = input.read(buffer))) {
            output.write(buffer, 0, n2);
            count += (long)n2;
        }
        return count;
    }
}

