/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.security.credentials;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.security.credentials.CredentialsSource;
import org.kuali.rice.core.api.security.credentials.CredentialsType;
import org.springframework.beans.factory.InitializingBean;

public final class CredentialsSourceFactory
implements InitializingBean {
    private final Logger log = LogManager.getLogger(this.getClass());
    private List<CredentialsSource> credentialsSources;
    private Map<CredentialsType, CredentialsSource> credentialsSourcesByType = new HashMap<CredentialsType, CredentialsSource>();

    public CredentialsSource getCredentialsForType(CredentialsType credentialsType) {
        return this.credentialsSourcesByType.get((Object)credentialsType);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.credentialsSources != null) {
            for (CredentialsSource credentialsSource : this.credentialsSources) {
                this.credentialsSourcesByType.put(credentialsSource.getSupportedCredentialsType(), credentialsSource);
            }
        } else {
            this.log.warn("No CredentialsSources set.  No security will be provided on the bus.");
        }
    }

    public void setCredentialsSources(List<CredentialsSource> credentialsSources) {
        this.credentialsSources = credentialsSources;
    }
}

