/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.uif;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.uif.RemotableAbstractWidget;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.w3c.dom.Element;

@XmlRootElement(name="quickFinder")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="QuickFinderType", propOrder={"baseLookupUrl", "dataObjectClass", "lookupParameters", "fieldConversions", "_futureElements"})
public final class RemotableQuickFinder
extends RemotableAbstractWidget {
    @XmlElement(name="baseLookupUrl", required=false)
    private final String baseLookupUrl;
    @XmlElement(name="dataObjectClass", required=true)
    private final String dataObjectClass;
    @XmlElement(name="lookupParameters", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> lookupParameters;
    @XmlElement(name="fieldConversions", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> fieldConversions;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RemotableQuickFinder() {
        this.baseLookupUrl = null;
        this.dataObjectClass = null;
        this.lookupParameters = null;
        this.fieldConversions = null;
    }

    private RemotableQuickFinder(Builder b2) {
        this.baseLookupUrl = b2.baseLookupUrl;
        this.dataObjectClass = b2.dataObjectClass;
        this.lookupParameters = b2.lookupParameters;
        this.fieldConversions = b2.fieldConversions;
    }

    public String getBaseLookupUrl() {
        return this.baseLookupUrl;
    }

    public String getDataObjectClass() {
        return this.dataObjectClass;
    }

    public Map<String, String> getLookupParameters() {
        return Collections.unmodifiableMap(this.lookupParameters);
    }

    public Map<String, String> getFieldConversions() {
        return Collections.unmodifiableMap(this.fieldConversions);
    }

    static final class Elements {
        static final String BASE_LOOKUP_URL = "baseLookupUrl";
        static final String DATA_OBJECT_CLASS = "dataObjectClass";
        static final String LOOKUP_PARAMETERS = "lookupParameters";
        static final String FIELD_CONVERSIONS = "fieldConversions";

        Elements() {
        }
    }

    static final class Constants {
        static final String TYPE_NAME = "QuickFinderType";
        static final String ROOT_ELEMENT_NAME = "quickFinder";

        Constants() {
        }
    }

    public static final class Builder
    extends RemotableAbstractWidget.Builder {
        private String baseLookupUrl;
        private String dataObjectClass;
        private Map<String, String> lookupParameters = Collections.emptyMap();
        private Map<String, String> fieldConversions = Collections.emptyMap();

        private Builder(String baseLookupUrl, String dataObjectClass) {
            this.setBaseLookupUrl(baseLookupUrl);
            this.setDataObjectClass(dataObjectClass);
        }

        public static Builder create(String baseLookupUrl, String dataObjectClass) {
            return new Builder(baseLookupUrl, dataObjectClass);
        }

        public String getBaseLookupUrl() {
            return this.baseLookupUrl;
        }

        public void setBaseLookupUrl(String baseLookupUrl) {
            this.baseLookupUrl = baseLookupUrl;
        }

        public String getDataObjectClass() {
            return this.dataObjectClass;
        }

        public void setDataObjectClass(String dataObjectClass) {
            if (StringUtils.isBlank(dataObjectClass)) {
                throw new IllegalArgumentException("dataObjectClass is blank");
            }
            this.dataObjectClass = dataObjectClass;
        }

        public Map<String, String> getLookupParameters() {
            return Collections.unmodifiableMap(this.lookupParameters);
        }

        public void setLookupParameters(Map<String, String> lookupParameters) {
            if (lookupParameters != null) {
                this.lookupParameters = new HashMap<String, String>(lookupParameters);
            }
        }

        public Map<String, String> getFieldConversions() {
            return Collections.unmodifiableMap(this.fieldConversions);
        }

        public void setFieldConversions(Map<String, String> fieldConversions) {
            if (fieldConversions != null) {
                this.fieldConversions = new HashMap<String, String>(fieldConversions);
            }
        }

        @Override
        public RemotableQuickFinder build() {
            return new RemotableQuickFinder(this);
        }
    }
}

