/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.uif;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableSelectContract;
import org.kuali.rice.core.api.uif.RemotableSelectGroup;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.w3c.dom.Element;

@XmlRootElement(name="select")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="SelectType", propOrder={"keyLabels", "groups", "size", "multiple", "refreshOnChange", "_futureElements"})
public final class RemotableSelect
extends RemotableAbstractControl
implements RemotableSelectContract {
    @XmlElement(name="keyLabels", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> keyLabels;
    @XmlElementWrapper(name="groups", required=true)
    @XmlElement(name="group", required=false)
    private final List<RemotableSelectGroup> groups;
    @XmlElement(name="size", required=false)
    private final Integer size;
    @XmlElement(name="multiple", required=false)
    private final boolean multiple;
    @XmlElement(name="refreshOnChange", required=false)
    private final boolean refreshOnChange;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RemotableSelect() {
        this.size = null;
        this.keyLabels = null;
        this.groups = null;
        this.multiple = false;
        this.refreshOnChange = false;
    }

    private RemotableSelect(Builder b2) {
        this.size = b2.size;
        this.keyLabels = b2.keyLabels;
        ArrayList<RemotableSelectGroup> temp = new ArrayList<RemotableSelectGroup>();
        for (RemotableSelectGroup.Builder attr : b2.groups) {
            temp.add(attr.build());
        }
        this.groups = Collections.unmodifiableList(temp);
        this.multiple = b2.multiple;
        this.refreshOnChange = b2.refreshOnChange;
    }

    @Override
    public Map<String, String> getKeyLabels() {
        return this.keyLabels;
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    public List<RemotableSelectGroup> getGroups() {
        return this.groups;
    }

    @Override
    public boolean isMultiple() {
        return this.multiple;
    }

    @Override
    public boolean isRefreshOnChange() {
        return this.refreshOnChange;
    }

    static final class Elements {
        static final String SIZE = "size";
        static final String KEY_LABELS = "keyLabels";
        static final String GROUPS = "groups";
        static final String GROUP = "group";
        static final String MULTIPLE = "multiple";
        static final String REFRESH_ON_CHANGE = "refreshOnChange";

        Elements() {
        }
    }

    static final class Constants {
        static final String TYPE_NAME = "SelectType";
        static final String ROOT_ELEMENT_NAME = "select";

        Constants() {
        }
    }

    public static final class Builder
    extends RemotableAbstractControl.Builder
    implements RemotableSelectContract {
        private Integer size;
        private Map<String, String> keyLabels = Collections.emptyMap();
        private List<RemotableSelectGroup.Builder> groups = Collections.emptyList();
        private boolean multiple;
        private boolean refreshOnChange;

        private Builder(Map<String, String> keyLabels) {
            this.setKeyLabels(keyLabels);
        }

        private Builder(List<RemotableSelectGroup.Builder> groups) {
            this.setGroups(groups);
        }

        public static Builder create(Map<String, String> keyLabels) {
            return new Builder(keyLabels);
        }

        public static Builder create(List<RemotableSelectGroup.Builder> groups) {
            return new Builder(groups);
        }

        @Override
        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            if (size != null && size < 1) {
                throw new IllegalArgumentException("size was < 1");
            }
            this.size = size;
        }

        @Override
        public Map<String, String> getKeyLabels() {
            return this.keyLabels;
        }

        public void setKeyLabels(Map<String, String> keyLabels) {
            if (keyLabels == null) {
                throw new IllegalArgumentException("keyLabels was null");
            }
            this.keyLabels = Collections.unmodifiableMap(new LinkedHashMap<String, String>(keyLabels));
        }

        public List<RemotableSelectGroup.Builder> getGroups() {
            return this.groups;
        }

        public void setGroups(List<RemotableSelectGroup.Builder> groups) {
            if (groups == null) {
                throw new IllegalArgumentException("groups was null");
            }
            this.groups = Collections.unmodifiableList(new ArrayList<RemotableSelectGroup.Builder>(groups));
        }

        @Override
        public boolean isMultiple() {
            return this.multiple;
        }

        public void setMultiple(boolean multiple) {
            this.multiple = multiple;
        }

        @Override
        public boolean isRefreshOnChange() {
            return this.refreshOnChange;
        }

        public void setRefreshOnChange(boolean refreshOnChange) {
            this.refreshOnChange = refreshOnChange;
        }

        @Override
        public RemotableSelect build() {
            if (this.keyLabels.isEmpty() && this.groups.isEmpty()) {
                throw new IllegalStateException("the keyLabels or groups must be set to a non-empty collection");
            }
            return new RemotableSelect(this);
        }
    }
}

