/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.collect;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static boolean collectionsEquivalent(Collection<?> a2, Collection<?> b2) {
        if (a2 == null && b2 == null) {
            return true;
        }
        if (a2 == null ^ b2 == null) {
            return false;
        }
        return a2.containsAll(b2) && b2.containsAll(a2);
    }

    public static <T> Iterable<T> toIterable(Iterator<T> i2) {
        return new IterableIterator<T>(i2);
    }

    public static <T> Iterable<T> toIterable(Enumeration<T> e2) {
        return new IterableEnumeration<T>(e2);
    }

    public static <T> Collection<T> unmodifiableCollectionNullSafe(Collection<? extends T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    public static <T> List<T> unmodifiableListNullSafe(List<? extends T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> Set<T> unmodifiableSetNullSafe(Set<? extends T> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public static <K, V> Map<K, V> unmodifiableMapNullSafe(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeUnmodifiableAndNullSafe(Object o2) throws IllegalAccessException {
        if (o2 == null) {
            return;
        }
        Class<?> targetClass = o2.getClass();
        for (Field f2 : targetClass.getDeclaredFields()) {
            f2.setAccessible(true);
            try {
                if (f2.getType().isAssignableFrom(List.class)) {
                    f2.set(o2, CollectionUtils.unmodifiableListNullSafe((List)f2.get(o2)));
                    continue;
                }
                if (f2.getType().isAssignableFrom(Set.class)) {
                    f2.set(o2, CollectionUtils.unmodifiableSetNullSafe((Set)f2.get(o2)));
                    continue;
                }
                if (f2.getType().isAssignableFrom(Collection.class)) {
                    f2.set(o2, CollectionUtils.unmodifiableCollectionNullSafe((Collection)f2.get(o2)));
                    continue;
                }
                if (!f2.getType().isAssignableFrom(Map.class)) continue;
                f2.set(o2, CollectionUtils.unmodifiableMapNullSafe((Map)f2.get(o2)));
            }
            finally {
                f2.setAccessible(false);
            }
        }
    }

    public static <T> Enumeration<T> concat(Enumeration<? extends T> ... inputs) {
        return new SimpleEnumeration<T>(inputs);
    }

    private static class IterableIterator<T>
    implements Iterable<T> {
        private final Iterator<T> i;

        private IterableIterator(Iterator<T> i2) {
            if (i2 == null) {
                throw new IllegalArgumentException("the iterator is null");
            }
            this.i = i2;
        }

        @Override
        public Iterator<T> iterator() {
            return this.i;
        }
    }

    private static class IterableEnumeration<T>
    implements Iterable<T> {
        private final Enumeration<T> e;

        private IterableEnumeration(Enumeration<T> e2) {
            if (e2 == null) {
                throw new IllegalArgumentException("the enumeration is null");
            }
            this.e = e2;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return e.hasMoreElements();
                }

                @Override
                public T next() {
                    return e.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("this iterator does not support remove");
                }
            };
        }
    }

    private static class SimpleEnumeration<T>
    implements Enumeration<T> {
        private final Iterator<T> iterator;

        private SimpleEnumeration(Enumeration<? extends T> ... enumerations) {
            if (enumerations == null) {
                throw new NullPointerException("enumerations is null");
            }
            ArrayList<T> internalList = new ArrayList<T>();
            for (Enumeration<T> enumeration : enumerations) {
                if (enumeration == null) {
                    throw new NullPointerException("input is null");
                }
                while (enumeration.hasMoreElements()) {
                    internalList.add(enumeration.nextElement());
                }
            }
            this.iterator = internalList.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }
    }
}

