/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.jaxb;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.mo.common.Coded;

public abstract class EnumStringAdapter<T extends Enum<T>>
extends XmlAdapter<String, String> {
    private static final Logger LOG = LogManager.getLogger(EnumStringAdapter.class);

    @Override
    public String marshal(String value) throws Exception {
        return this.processValue(value, false);
    }

    @Override
    public String unmarshal(String value) throws Exception {
        return this.processValue(value, true);
    }

    private String processValue(String value, boolean unmarshal) throws Exception {
        if (value == null) {
            return null;
        }
        Class<T> enumClass = this.getEnumClass();
        if (Coded.class.isAssignableFrom(enumClass)) {
            Enum[] enumConstants;
            for (Enum enumConstant : enumConstants = (Enum[])enumClass.getEnumConstants()) {
                Coded codedEnumConstant = (Coded)((Object)enumConstant);
                if (!codedEnumConstant.getCode().equals(value)) continue;
                return value;
            }
        } else {
            try {
                Enum.valueOf(enumClass, value);
                return value;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (unmarshal) {
            LOG.warn("Failed to unmarshal enumeration value '" + value + "' for enum type: " + enumClass.getName());
            return null;
        }
        throw new RiceIllegalArgumentException("Failed to marshal enumeration value '" + value + "' for enum type: " + this.getEnumClass().getName());
    }

    protected abstract Class<T> getEnumClass();
}

