/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Node<T, K>
implements Serializable {
    private static final long serialVersionUID = -2650587832812603561L;
    private T data;
    private List<Node<T, K>> children = new ArrayList<Node<T, K>>();
    private K nodeLabel;
    private String nodeType;

    public Node() {
    }

    public Node(T data) {
        this();
        this.setData(data);
    }

    public Node(T data, K label) {
        this();
        this.setData(data);
        this.setNodeLabel(label);
    }

    public List<Node<T, K>> getChildren() {
        if (this.children == null) {
            return new ArrayList<Node<T, K>>();
        }
        return this.children;
    }

    public void setChildren(List<Node<T, K>> children) {
        this.children = children;
    }

    public int getNumberOfChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void addChild(Node<T, K> child) {
        if (this.children == null) {
            this.children = new ArrayList<Node<T, K>>();
        }
        this.children.add(child);
    }

    public void insertChildAt(int index, Node<T, K> child) throws IndexOutOfBoundsException {
        if (index == this.getNumberOfChildren()) {
            this.addChild(child);
            return;
        }
        this.children.get(index);
        this.children.add(index, child);
    }

    public void removeChildAt(int index) throws IndexOutOfBoundsException {
        this.children.remove(index);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public K getNodeLabel() {
        return this.nodeLabel;
    }

    public void setNodeLabel(K nodeLabel) {
        this.nodeLabel = nodeLabel;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String toString() {
        if (this.getData() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append(this.getData().toString()).append(",[");
            int i2 = 0;
            for (Node<T, K> e2 : this.getChildren()) {
                if (i2 > 0) {
                    sb.append(",");
                }
                sb.append(e2.getData().toString());
                ++i2;
            }
            sb.append("]").append("}");
            return sb.toString();
        }
        return super.toString();
    }
}

