/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.web.format;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.core.web.format.Formatter;

@Deprecated
public class CurrencyFormatter
extends Formatter {
    private static final long serialVersionUID = -7986953503122821012L;
    private static Logger LOG = LogManager.getLogger(CurrencyFormatter.class);
    public static final String SHOW_SYMBOL = "showCurrencySymbol";
    private static final Pattern CURRENCY_PATTERN = Pattern.compile("[-\\(\\)\\$\\.,0-9]*");
    private static final Pattern TRAILING_DECIMAL_PATTERN = Pattern.compile("^(\\.[0-9]{0,2}){0,1}\\)?$");

    @Override
    protected Object convertToObject(String target) {
        KualiDecimal value = null;
        LOG.debug("convertToObject '" + (String)target + "'");
        if (target != null) {
            target = ((String)target).trim();
            String rawString = target;
            if (((String)target).startsWith("(") && !((String)target).startsWith("($")) {
                target = "($" + StringUtils.substringAfter((String)target, "(");
            }
            if (!((String)target).startsWith("(") && !((String)target).startsWith(this.getSymbol())) {
                target = this.interpolateSymbol((String)target);
            }
            if (!CURRENCY_PATTERN.matcher((CharSequence)target).matches()) {
                throw new FormatException("parsing", "error.currency", rawString);
            }
            if (rawString.contains(".") && !TRAILING_DECIMAL_PATTERN.matcher(((String)target).substring(((String)target).indexOf("."), ((String)target).length())).matches()) {
                throw new FormatException("parsing", "error.currency.decimal", rawString);
            }
            NumberFormat formatter = CurrencyFormatter.getCurrencyInstanceUsingParseBigDecimal();
            try {
                Number parsedNumber = formatter.parse((String)target);
                value = new KualiDecimal(parsedNumber.toString());
            }
            catch (NumberFormatException e2) {
                throw new FormatException("parsing", "error.currency", rawString, e2);
            }
            catch (ParseException e3) {
                throw new FormatException("parsing", "error.currency", rawString, e3);
            }
        }
        return value;
    }

    protected String interpolateSymbol(String target) {
        if (target.startsWith("-")) {
            int symbolPos;
            int dashPos = target.indexOf(45);
            int index = dashPos > (symbolPos = target.indexOf(this.getSymbol())) ? dashPos : symbolPos;
            return "($" + target.substring(index + 1) + ")";
        }
        return target.startsWith("(") ? "($" + target.indexOf("(1") : "$" + target;
    }

    protected String removeSymbol(String target) {
        int index = target.indexOf(this.getSymbol());
        String prefix = index > 0 ? target.substring(0, index) : "";
        return prefix + target.substring(index + 1);
    }

    protected String getSymbol() {
        return "$";
    }

    protected boolean showSymbol() {
        String showSymbol = this.settings == null ? null : (String)this.settings.get(SHOW_SYMBOL);
        return Boolean.valueOf(showSymbol);
    }

    @Override
    public Object format(Object obj) {
        LOG.debug("format '" + obj + "'");
        if (obj == null) {
            return null;
        }
        if (obj instanceof String && StringUtils.isEmpty((String)obj)) {
            return null;
        }
        NumberFormat formatter = CurrencyFormatter.getCurrencyInstanceUsingParseBigDecimal();
        String string = null;
        try {
            Number number;
            if (obj instanceof KualiInteger) {
                formatter.setMaximumFractionDigits(0);
                number = (KualiInteger)obj;
            } else {
                number = (KualiDecimal)obj;
            }
            KualiDecimal convertedNumber = (KualiDecimal)this.convertToObject(((Object)number).toString());
            string = formatter.format(convertedNumber.bigDecimalValue());
        }
        catch (IllegalArgumentException e2) {
            throw new FormatException("formatting", "error.currency", obj.toString(), e2);
        }
        catch (ClassCastException e3) {
            throw new FormatException("formatting", "error.currency", obj.toString(), e3);
        }
        return this.showSymbol() ? string : this.removeSymbol(string);
    }

    static final NumberFormat getCurrencyInstanceUsingParseBigDecimal() {
        NumberFormat formatter = NumberFormat.getCurrencyInstance();
        if (formatter instanceof DecimalFormat) {
            ((DecimalFormat)formatter).setParseBigDecimal(true);
        }
        return formatter;
    }

    public boolean validate(String currencyString) {
        Object currencyObject = null;
        try {
            currencyObject = this.convertToObject(currencyString);
        }
        catch (Exception e2) {
            currencyObject = null;
        }
        return currencyObject != null;
    }
}

