/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.access.kim;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.dc.access.kim.DocumentAccess;
import org.kuali.coeus.dc.access.kim.KimAttributeDocumentValueHandler;
import org.kuali.coeus.dc.access.kim.KimTypeDao;
import org.kuali.coeus.dc.access.kim.Role;
import org.kuali.coeus.dc.access.kim.RoleDao;
import org.kuali.coeus.dc.access.kim.RoleMember;
import org.kuali.coeus.dc.access.kim.RoleMemberAttributeData;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;
import org.kuali.coeus.dc.common.db.PreparedStatementUtils;
import org.kuali.coeus.dc.common.db.SequenceDaoService;

public class RoleDaoImpl
implements RoleDao {
    private static final Logger LOG = LogManager.getLogger(RoleDaoImpl.class.getName());
    private ConnectionDaoService connectionDaoService;
    private KimTypeDao kimTypeDao;
    private SequenceDaoService sequenceDaoService;

    @Override
    public void copyRoleMembersToDocAccessType(Collection<String> roleIds, KimAttributeDocumentValueHandler handler) {
        String kimTypeId = this.kimTypeDao.getDocAccessKimTypeId();
        if (kimTypeId == null || kimTypeId.trim().equals("")) {
            throw new IllegalStateException("Doc Access Kim Type is not found");
        }
        for (String roleId : roleIds) {
            Role existingRole = this.getRole(roleId);
            if (existingRole.getKimTypeId().equals(kimTypeId) || !this.copyExists(this.createNewRoleName(existingRole.getName()), existingRole.getNamespaceCode())) continue;
            this.copyRoleMembers(existingRole, handler);
        }
        handler.cleanup();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean copyExists(String name, String namespace) {
        Connection connection = this.connectionDaoService.getRiceConnection();
        try (PreparedStatement stmt = PreparedStatementUtils.setString(2, namespace, PreparedStatementUtils.setString(1, name, connection.prepareStatement("SELECT count(*) from KRIM_ROLE_T WHERE ROLE_NM = ? AND NMSPC_CD = ?")));){
            boolean bl;
            block18: {
                ResultSet result;
                block16: {
                    boolean bl2;
                    block17: {
                        result = stmt.executeQuery();
                        try {
                            boolean exists;
                            result.next();
                            boolean bl3 = exists = result.getInt(1) > 0;
                            if (!exists) break block16;
                            bl2 = true;
                            if (result == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return bl2;
                }
                LOG.warn("Copy Role does not exist for name: " + name + " and namespace: " + namespace);
                bl = false;
                if (result == null) break block18;
                result.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private String createNewRoleName(String name) {
        return name + " Document Level";
    }

    protected void copyRoleMembers(Role existingRole, KimAttributeDocumentValueHandler handler) {
        ArrayList<DocumentAccess> accessesToSave = new ArrayList<DocumentAccess>();
        HashSet<String> roleMbrDeleteIds = new HashSet<String>();
        for (RoleMember member : this.getRoleMembers(existingRole.getId())) {
            if (!"P".equals(member.getTypeCode())) continue;
            Collection<RoleMemberAttributeData> attrs = this.getRoleMemberAttributeData(member.getId());
            for (RoleMemberAttributeData attr : attrs) {
                String documentNumber;
                if (!handler.isDocumentValueType(attr.getKimAttributeId()) || attr.getAttributeValue() == null || (documentNumber = handler.transform(attr.getAttributeValue())) == null) continue;
                DocumentAccess access = new DocumentAccess();
                access.setId(this.sequenceDaoService.getNextCoeusSequence("SEQ_DOCUMENT_ACCESS_ID", ""));
                access.setDocumentNumber(documentNumber);
                access.setPrincipalId(member.getMemberId());
                access.setRoleName(this.createNewRoleName(existingRole.getName()));
                access.setNamespaceCode(existingRole.getNamespaceCode());
                access.setUpdateUser("kc-doc-access-conv");
                access.setUpdateTimestamp(new Timestamp(new Date().getTime()));
                access.setVersionNumber(1L);
                access.setObjectId(UUID.randomUUID().toString());
                accessesToSave.add(access);
                roleMbrDeleteIds.add(member.getId());
            }
        }
        TreeSet<DocumentAccess> filtered = new TreeSet<DocumentAccess>(new Comparator<DocumentAccess>(){

            @Override
            public int compare(DocumentAccess o1, DocumentAccess o2) {
                if (o1.getPrincipalId().equals(o2.getPrincipalId()) && o1.getDocumentNumber().equals(o2.getDocumentNumber()) && o1.getRoleName().equals(o2.getRoleName()) && o1.getNamespaceCode().equals(o2.getNamespaceCode())) {
                    return 0;
                }
                return o1.getDocumentNumber().compareTo(o2.getDocumentNumber());
            }
        });
        filtered.addAll(accessesToSave);
        if (filtered.size() != accessesToSave.size()) {
            LOG.warn("Duplicate role member document qualifiers detected");
        }
        this.saveDocumentAccess(filtered);
        this.deleteRoleMembers(roleMbrDeleteIds);
    }

    private void deleteRoleMembers(Collection<String> roleMemberIdsToDelete) {
        for (String roleMbrId : roleMemberIdsToDelete) {
            PreparedStatement stmt;
            LOG.info("Removing KRIM_ROLE_MBR_T for ROLE_MBR_ID=" + roleMbrId);
            Connection connection = this.connectionDaoService.getRiceConnection();
            try {
                stmt = PreparedStatementUtils.setString(1, roleMbrId, connection.prepareStatement("DELETE FROM KRIM_ROLE_MBR_ATTR_DATA_T WHERE ROLE_MBR_ID = ?"));
                try {
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            try {
                stmt = PreparedStatementUtils.setString(1, roleMbrId, connection.prepareStatement("DELETE FROM KRIM_ROLE_MBR_T WHERE ROLE_MBR_ID = ?"));
                try {
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void saveDocumentAccess(Collection<DocumentAccess> accesses) {
        for (DocumentAccess access : accesses) {
            Connection connection = this.connectionDaoService.getCoeusConnection();
            try {
                PreparedStatement stmt = PreparedStatementUtils.setString(9, access.getObjectId(), PreparedStatementUtils.setLong(8, access.getVersionNumber(), PreparedStatementUtils.setString(7, access.getUpdateUser(), PreparedStatementUtils.setTimestamp(6, access.getUpdateTimestamp(), PreparedStatementUtils.setString(5, access.getNamespaceCode(), PreparedStatementUtils.setString(4, access.getRoleName(), PreparedStatementUtils.setString(3, access.getPrincipalId(), PreparedStatementUtils.setString(2, access.getDocumentNumber(), PreparedStatementUtils.setString(1, access.getId(), connection.prepareStatement("INSERT INTO DOCUMENT_ACCESS (DOC_ACCESS_ID, DOC_HDR_ID, PRNCPL_ID, ROLE_NM, NMSPC_CD, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)"))))))))));
                try {
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Collection<RoleMember> getRoleMembers(String roleId) {
        Connection connection = this.connectionDaoService.getRiceConnection();
        try (PreparedStatement stmt = PreparedStatementUtils.setString(1, roleId, connection.prepareStatement("SELECT ROLE_MBR_ID, VER_NBR, OBJ_ID, ROLE_ID, MBR_ID, MBR_TYP_CD, ACTV_FRM_DT, ACTV_TO_DT, LAST_UPDT_DT FROM KRIM_ROLE_MBR_T WHERE ROLE_ID = ?"));){
            ArrayList<RoleMember> arrayList;
            block15: {
                ResultSet result = stmt.executeQuery();
                try {
                    ArrayList<RoleMember> members = new ArrayList<RoleMember>();
                    while (result.next()) {
                        RoleMember member = new RoleMember();
                        member.setId(result.getString(1));
                        member.setVersionNumber(result.getLong(2));
                        member.setObjectId(result.getString(3));
                        member.setRoleId(result.getString(4));
                        member.setMemberId(result.getString(5));
                        member.setTypeCode(result.getString(6));
                        member.setActiveFromDateValue(result.getTimestamp(7));
                        member.setActiveToDateValue(result.getTimestamp(8));
                        member.setLastUpdatedDate(result.getTimestamp(9));
                        members.add(member);
                    }
                    arrayList = members;
                    if (result == null) break block15;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Collection<RoleMemberAttributeData> getRoleMemberAttributeData(String roleMemberId) {
        Connection connection = this.connectionDaoService.getRiceConnection();
        try (PreparedStatement stmt = PreparedStatementUtils.setString(1, roleMemberId, connection.prepareStatement("SELECT ATTR_DATA_ID, OBJ_ID, VER_NBR, ROLE_MBR_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL FROM KRIM_ROLE_MBR_ATTR_DATA_T WHERE ROLE_MBR_ID = ?"));){
            ArrayList<RoleMemberAttributeData> arrayList;
            block15: {
                ResultSet result = stmt.executeQuery();
                try {
                    ArrayList<RoleMemberAttributeData> attrs = new ArrayList<RoleMemberAttributeData>();
                    while (result.next()) {
                        RoleMemberAttributeData attr = new RoleMemberAttributeData();
                        attr.setId(result.getString(1));
                        attr.setObjectId(result.getString(2));
                        attr.setVersionNumber(result.getLong(3));
                        attr.setRoleMemberId(result.getString(4));
                        attr.setKimTypeId(result.getString(5));
                        attr.setKimAttributeId(result.getString(6));
                        attr.setAttributeValue(result.getString(7));
                        attrs.add(attr);
                    }
                    arrayList = attrs;
                    if (result == null) break block15;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Role getRole(String roleId) {
        Connection connection = this.connectionDaoService.getRiceConnection();
        try (PreparedStatement stmt = PreparedStatementUtils.setString(1, roleId, connection.prepareStatement("SELECT ROLE_ID, ROLE_NM, NMSPC_CD, DESC_TXT, KIM_TYP_ID, ACTV_IND, OBJ_ID, VER_NBR, LAST_UPDT_DT FROM KRIM_ROLE_T WHERE ROLE_ID = ?"));
             ResultSet result = stmt.executeQuery();){
            if (!result.next()) throw new IllegalStateException("role not found");
            Role role = new Role();
            role.setId(result.getString(1));
            role.setName(result.getString(2));
            role.setNamespaceCode(result.getString(3));
            role.setDescription(result.getString(4));
            role.setKimTypeId(result.getString(5));
            role.setActive(result.getString(6));
            role.setObjectId(result.getString(7));
            role.setVersionNumber(result.getLong(8));
            role.setLastUpdatedDate(result.getTimestamp(9));
            Role role2 = role;
            return role2;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectionDaoService getConnectionDaoService() {
        return this.connectionDaoService;
    }

    public void setConnectionDaoService(ConnectionDaoService connectionDaoService) {
        this.connectionDaoService = connectionDaoService;
    }

    public KimTypeDao getKimTypeDao() {
        return this.kimTypeDao;
    }

    public void setKimTypeDao(KimTypeDao kimTypeDao) {
        this.kimTypeDao = kimTypeDao;
    }

    public SequenceDaoService getSequenceDaoService() {
        return this.sequenceDaoService;
    }

    public void setSequenceDaoService(SequenceDaoService sequenceDaoService) {
        this.sequenceDaoService = sequenceDaoService;
    }
}

