/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.pprole;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;
import org.kuali.coeus.dc.common.db.PreparedStatementUtils;
import org.kuali.coeus.dc.common.rice.parameter.Parameter;
import org.kuali.coeus.dc.common.rice.parameter.ParameterDao;
import org.kuali.coeus.dc.common.rice.parameter.ParameterKey;
import org.kuali.coeus.dc.pprole.ProposalPersonRoleDao;

public class ProposalPersonRoleDaoImpl
implements ProposalPersonRoleDao {
    private static final Logger LOG = LogManager.getLogger((String)ProposalPersonRoleDaoImpl.class.getName());
    private static final ParameterKey COI = new ParameterKey("KC-GEN", "All", "personrole.coi", "KC");
    private static final ParameterKey KP = new ParameterKey("KC-GEN", "All", "personrole.kp", "KC");
    private static final ParameterKey NIH_COI = new ParameterKey("KC-GEN", "All", "personrole.nih.coi", "KC");
    private static final ParameterKey NIH_COI_MPI = new ParameterKey("KC-GEN", "All", "personrole.nih.coi.mpi", "KC");
    private static final ParameterKey NIH_KP = new ParameterKey("KC-GEN", "All", "personrole.nih.kp", "KC");
    private static final ParameterKey NIH_PI = new ParameterKey("KC-GEN", "All", "personrole.nih.pi", "KC");
    private static final ParameterKey PI = new ParameterKey("KC-GEN", "All", "personrole.pi", "KC");
    private static final ParameterKey READ_ONLY_ROLES = new ParameterKey("KC-GEN", "All", "personrole.readonly.roles", "KC");
    private static final String DEFAULT = "DEFAULT";
    private static final String NIH_MULTIPLE_PI = "NIH Multiple PI";
    private ParameterDao parameterDao;
    private ConnectionDaoService connectionDaoService;

    @Override
    public void convertParameterValues() {
        Parameter pReadOnlyRoles;
        Parameter pNihKp;
        Parameter pNihCoi;
        Parameter pNihCoiMpi;
        Parameter pNihPi;
        Parameter pPi;
        Parameter pKp;
        Parameter pCoi = this.getParameter(COI);
        if (pCoi != null) {
            this.updateProposalPersonRoleDescription("COI", DEFAULT, pCoi.getValue());
            this.deleteParameter(COI);
        }
        if ((pKp = this.getParameter(KP)) != null) {
            this.updateProposalPersonRoleDescription("KP", DEFAULT, pKp.getValue());
            this.deleteParameter(KP);
        }
        if ((pPi = this.getParameter(PI)) != null) {
            this.updateProposalPersonRoleDescription("PI", DEFAULT, pPi.getValue());
            this.deleteParameter(PI);
        }
        if ((pNihPi = this.getParameter(NIH_PI)) != null) {
            this.updateProposalPersonRoleDescription("PI", NIH_MULTIPLE_PI, pNihPi.getValue());
            this.deleteParameter(NIH_PI);
        }
        if ((pNihCoiMpi = this.getParameter(NIH_COI_MPI)) != null) {
            this.updateProposalPersonRoleDescription("MPI", NIH_MULTIPLE_PI, pNihCoiMpi.getValue());
            this.deleteParameter(NIH_COI_MPI);
        }
        if ((pNihCoi = this.getParameter(NIH_COI)) != null) {
            this.updateProposalPersonRoleDescription("COI", NIH_MULTIPLE_PI, pNihCoi.getValue());
            this.deleteParameter(NIH_COI);
        }
        if ((pNihKp = this.getParameter(NIH_KP)) != null) {
            this.updateProposalPersonRoleDescription("KP", NIH_MULTIPLE_PI, pNihKp.getValue());
            this.deleteParameter(NIH_KP);
        }
        if ((pReadOnlyRoles = this.getParameter(READ_ONLY_ROLES)) != null) {
            HashSet<String> roles = new HashSet<String>();
            for (String role : Arrays.asList(pReadOnlyRoles.getValue().split(","))) {
                roles.add(role.trim().toUpperCase());
            }
            if (roles.contains("COI")) {
                this.updateProposalPersonRoleToReadOnly("COI", DEFAULT, true);
                this.updateProposalPersonRoleToReadOnly("MPI", NIH_MULTIPLE_PI, true);
                this.updateProposalPersonRoleToReadOnly("COI", NIH_MULTIPLE_PI, true);
            } else {
                this.updateProposalPersonRoleToReadOnly("COI", DEFAULT, false);
                this.updateProposalPersonRoleToReadOnly("MPI", NIH_MULTIPLE_PI, false);
                this.updateProposalPersonRoleToReadOnly("COI", NIH_MULTIPLE_PI, false);
            }
            if (roles.contains("KP")) {
                this.updateProposalPersonRoleToReadOnly("KP", DEFAULT, true);
                this.updateProposalPersonRoleToReadOnly("KP", NIH_MULTIPLE_PI, true);
            } else {
                this.updateProposalPersonRoleToReadOnly("KP", DEFAULT, false);
                this.updateProposalPersonRoleToReadOnly("KP", NIH_MULTIPLE_PI, false);
            }
            if (roles.contains("PI")) {
                this.updateProposalPersonRoleToReadOnly("PI", DEFAULT, true);
                this.updateProposalPersonRoleToReadOnly("PI", NIH_MULTIPLE_PI, true);
            } else {
                this.updateProposalPersonRoleToReadOnly("PI", DEFAULT, false);
                this.updateProposalPersonRoleToReadOnly("PI", NIH_MULTIPLE_PI, false);
            }
            this.deleteParameter(READ_ONLY_ROLES);
        }
    }

    private Parameter getParameter(ParameterKey key) {
        Parameter p = this.parameterDao.getParameter(key);
        if (p != null) {
            LOG.info("Found parameter " + key + " with value " + p.getValue());
        }
        return p;
    }

    private void deleteParameter(ParameterKey key) {
        LOG.info("Delete parameter " + key);
        this.parameterDao.deleteParameter(key);
    }

    private void updateProposalPersonRoleDescription(String roleCode, String shn, String description) {
        LOG.info("Updating Proposal Person Role with role code " + roleCode + " and sponsor hierarchy name " + shn + ". Setting description to " + description + ".");
        Connection connection = this.connectionDaoService.getCoeusConnection();
        try (PreparedStatement stmt = PreparedStatementUtils.setString(3, shn, PreparedStatementUtils.setString(2, roleCode, PreparedStatementUtils.setString(1, description, connection.prepareStatement("UPDATE eps_prop_person_role SET DESCRIPTION = ? WHERE PROP_PERSON_ROLE_CODE = ? AND SPONSOR_HIERARCHY_NAME = ?"))));){
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateProposalPersonRoleToReadOnly(String roleCode, String shn, boolean readOnly) {
        String flag = readOnly ? "Y" : "N";
        LOG.info("Updating Proposal Person Role with role code " + roleCode + " and sponsor hierarchy name " + shn + ". Setting read only to " + flag + ".");
        Connection connection = this.connectionDaoService.getCoeusConnection();
        try (PreparedStatement stmt = PreparedStatementUtils.setString(3, shn, PreparedStatementUtils.setString(2, roleCode, PreparedStatementUtils.setString(1, flag, connection.prepareStatement("UPDATE eps_prop_person_role SET READ_ONLY_ROLE = ? WHERE PROP_PERSON_ROLE_CODE = ? AND SPONSOR_HIERARCHY_NAME = ?"))));){
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public ParameterDao getParameterDao() {
        return this.parameterDao;
    }

    public void setParameterDao(ParameterDao parameterDao) {
        this.parameterDao = parameterDao;
    }

    public ConnectionDaoService getConnectionDaoService() {
        return this.connectionDaoService;
    }

    public void setConnectionDaoService(ConnectionDaoService connectionDaoService) {
        this.connectionDaoService = connectionDaoService;
    }
}

