--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

INSERT INTO SPONSOR_FORM_TEMPLATES (SPONSOR_FORM_TEMPLATE_ID,SPONSOR_FORM_ID,PAGE_NUMBER,PAGE_DESCRIPTION,FILE_NAME,CONTENT_TYPE,FORM_TEMPLATE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
    VALUES (SEQ_SPONSOR_FORM_TEMPLATES.NEXTVAL,(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)'),10,'Additional sites','Additional sites.xslt','text/xml',EMPTY_CLOB(),'admin',SYSDATE,SYS_GUID(),1);
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://era.nih.gov/Projectmgmt/SBIR/CGAP/common.namespace" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:nih="http://era.nih.gov/Projectmgmt/SBIR/CGAP/nihspecific.namespace" xmlns:phs398="http://era.nih.gov/Projectmgmt/SBIR/CGAP/phs398.namespace" xmlns:rar="http://era.nih.gov/Projectmgmt/SBIR/CGAP/researchandrelated.namespace" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
    <xsl:param name="SV_OutputFormat" select="''PDF''"/>
    <xsl:variable name="XML" select="/"/>
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
                <fo:region-body margin-top=".6in" margin-bottom="1in"/>
                <fo:region-after extent="1in"/>
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="/">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <xsl:call-template name="footerall"/>
                <fo:flow flow-name="xsl-region-body">
                    <fo:block>
                        <xsl:for-each select="$XML">
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                <fo:table-column column-width="30%"/>
                                <fo:table-column column-width="70%"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row>
                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="12" display-align="center">
                                            <fo:block>
                                                <fo:inline font-size="8pt">
                                                    <xsl:text>Program Director/Principal Investigator: </xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="12" text-align="left" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="nih:ResearchAndRelatedProject">
                                                    <xsl:for-each select="nih:ResearchCoverPage">
                                                        <xsl:for-each select="nih:ProgramDirectorPrincipalInvestigator">
                                                            <xsl:for-each select="Name">
                                                                <xsl:for-each select="LastName">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block font-size="8pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-size="8pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:for-each>
                                                                <fo:inline font-size="8pt">
                                                                    <xsl:text>, </xsl:text>
                                                                </fo:inline>
                                                                <xsl:for-each select="FirstName">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block fo';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'nt-size="8pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-size="8pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:for-each>
                                                                <fo:inline font-size="8pt">
                                                                    <xsl:text>&#160;</xsl:text>
                                                                </fo:inline>
                                                                <xsl:for-each select="MiddleName">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block font-size="8pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-size="8pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                            <fo:inline font-size="8pt">
                                <xsl:text>Use only if additional space is needed to list additional project/performance sites</xsl:text>
                            </fo:inline>
                            <fo:block/>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [2] )">
                                <fo:block/>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[2]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'ResearchCoverPage/AlternateProjectSites[2]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[2]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[2]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[2]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[2]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[2]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[2]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
    ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '                                 </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [3] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[3]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[3]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[3]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '/AlternateProjectSites[3]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[3]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[3]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[3]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[3]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [4] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="b';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'efore">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[4]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[4]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[4]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[4]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[4]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:Researc';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'hAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[4]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[4]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[4]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [5] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[5]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:Research';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'AndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[5]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[5]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[5]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[5]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[5]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[5]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/Alternate';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'ProjectSites[5]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [6] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[6]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[6]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[6]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </f';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'o:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[6]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[6]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[6]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[6]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[6]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [7] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-col';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'umn-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[7]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[7]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[7]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[7]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[7]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="ce';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'nter">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[7]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[7]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[7]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [8] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[8]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xs';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'l:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[8]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[8]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[8]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[8]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[8]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[8]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inl';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'ine>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[8]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [9] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[9]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[9]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[9]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                        ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '                 <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[9]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[9]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[9]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[9]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[9]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [10] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[10]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[10]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[10]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[10]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[10]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[10]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[10]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[10]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [11] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[11]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[11]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[11]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[11]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[11]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[11]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[11]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" bor';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'der="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[11]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [12] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[12]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[12]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
        ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '                                         <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[12]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[12]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[12]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[12]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[12]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[12]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [13] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[13]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[13]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[13]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[13]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[13]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center"';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '>
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[13]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[13]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[13]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [14] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[14]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
            ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '                                 </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[14]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[14]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[14]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[14]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[14]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[14]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                            ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '             <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[14]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [15] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[15]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[15]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[15]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[15]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[15]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[15]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[15]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[15]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [16] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-contai';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'ner>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[16]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[16]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[16]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[16]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[16]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[16]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[16]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[16]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [17] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[17]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" d';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'isplay-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[17]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[17]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[17]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[17]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[17]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[17]/PostalA';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'ddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[17]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [18] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[18]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[18]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell borde';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'r="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[18]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[18]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[18]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[18]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[18]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[18]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [19] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
        ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '                     <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[19]/OrganizationName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[19]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[19]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[19]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                            ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '     </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[19]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[19]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[19]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[19]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                            <xsl:if test="boolean(  nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites [20] )">
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block/>
                                </fo:block>
                                <fo:inline font-size="8pt" font-weight="bold">
                                    <xsl:text>Additional Project/Performance Site Location</xsl:text>
                                </fo:inline>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:table font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                    <fo:table-body start-indent="0pt">
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Organizational Name:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[20]/OrganizationName"/>
                ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '                                 </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell line-height="normal" number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>DUNS: </xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street1: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[20]/PostalAddress/Street"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell number-columns-spanned="2" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Street2:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="before">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>City:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[20]/PostalAddress/City"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>County:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[20]/CountyName"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>State: </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160;</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[20]/PostalAddress/State"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Province:</xsl:text>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Country:&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[20]/PostalAddress/Country"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := 'size="8pt">
                                                        <xsl:text>Zip/Postal Code:&#160;&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[20]/PostalAddress/PostalCode"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="3" border="solid 1pt gray" padding="0" height="10" display-align="center">
                                                <fo:block>
                                                    <fo:inline font-size="8pt">
                                                        <xsl:text>Project/Performance Site Congressional Districts:</xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:text>&#160; </xsl:text>
                                                    </fo:inline>
                                                    <fo:inline>
                                                        <xsl:value-of select="nih:ResearchAndRelatedProject/nih:ResearchCoverPage/AlternateProjectSites[20]/CongressionalDistrict"/>
                                                    </fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </xsl:if>
                        </xsl:for-each>
                    </fo:block>
                    <fo:block id="SV_RefID_PageTotal"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <xsl:template name="footerall">
        <fo:static-content flow-name="xsl-region-after">
            <fo:block>
                <fo:inline-container>
                    <fo:block>
                        <xsl:text>&#x2029;</xsl:text>
                    </fo:block>
                </fo:inline-container>
                <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                    <fo:table-column column-width="proportional-column-width(1)"/>
                    <fo:table-column column-width="150"/>
                    <fo:table-body start-indent="0pt">
                        <fo:table-row>
                            <fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
                                <fo:block/>
                            </fo:table-cell>
                        </fo:table-row>
                        <fo:table-row>
                            <fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
                                <fo:block>
                                    <fo:block text-align="center">
                                        <fo:leader top="-37pt" leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
                                    </fo:block>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <fo:table-row>
                            <fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
                                <fo:block>
                                    <fo:inline font-size="7pt" font-weight="bold">
                                        <xsl:text>PHS 398/2590 (Rev 11/07) </xsl:text>
                                    </fo:inline>
                                    <fo:inline font-weight="bold">
                                        <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
                                    </fo:inline>
                                    <fo:inline font-size="7pt" font-weight="bold">
                                        <xsl:text>Page ___</xsl:text>
                                    </fo:inline>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell font-size="smaller" padding="0" display-align="center">
                                <fo:block>
                                    <fo:inline font-size="7pt">
                                        <xsl:text>Project/Performance Site Format Page</xsl:text>
                                    </fo:inline>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:static-content>
    </xsl:template>
    <xsl:template name="double-backslash">
        <xsl:param name="text"/>
        <xsl:param name="text-length"/>
        <xsl:variable name="text-after-bs" select="substring-after($text, ''\'')"/>
        <xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
        <xsl:choose>
            <xsl:when test="$text-after-bs-length = 0">
                <xsl:choose>
                    <xsl:when test="substring($text, $text';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT FORM_TEMPLATE INTO data FROM SPONSOR_FORM_TEMPLATES WHERE SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)') AND PAGE_NUMBER = 10 FOR UPDATE;
buffer := '-length) = ''\''">
                        <xsl:value-of select="concat(substring($text,1,$text-length - 1), ''\\'')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$text"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), ''\\'')"/>
                <xsl:call-template name="double-backslash">
                    <xsl:with-param name="text" select="$text-after-bs"/>
                    <xsl:with-param name="text-length" select="$text-after-bs-length"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
