--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

DELIMITER /
UPDATE WATERMARK SET GROUP_NAME = 'IRB' WHERE STATUS_CODE = '-1' AND WATERMARK_TEXT = 'INVALID'
/
UPDATE WATERMARK SET GROUP_NAME = 'IRB' WHERE STATUS_CODE = '100' AND WATERMARK_TEXT = 'Pending/In Progress'
/
UPDATE WATERMARK SET GROUP_NAME = 'IRB' WHERE STATUS_CODE = '101' AND WATERMARK_TEXT = 'Submitted To IRB'
/
UPDATE WATERMARK SET GROUP_NAME = 'IRB' WHERE STATUS_CODE = '102' AND WATERMARK_TEXT = 'Specific Minor Revisions Required'
/
UPDATE WATERMARK SET GROUP_NAME = 'IRB' WHERE STATUS_CODE = '103' AND WATERMARK_TEXT = 'Deferred'
/
UPDATE WATERMARK SET GROUP_NAME = 'IRB' WHERE STATUS_CODE = '104' AND WATERMARK_TEXT = 'Substantive Revisions Required'
/
UPDATE WATERMARK SET GROUP_NAME = 'IRB' WHERE STATUS_CODE = '200' AND WATERMARK_TEXT = 'Approved'
/
UPDATE WATERMARK SET GROUP_NAME = 'IRB' WHERE STATUS_CODE = '304' AND WATERMARK_TEXT = 'Withdrawn'
/
UPDATE WATERMARK SET GROUP_NAME = 'IRB' WHERE STATUS_CODE = '305' AND WATERMARK_TEXT = 'Expired'
/
UPDATE WATERMARK SET GROUP_NAME = 'IRB' WHERE STATUS_CODE = '306' AND WATERMARK_TEXT = 'Withdrawn'
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '100', 'Pending/In Progress', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '101', 'Submitted to IACUC', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '102', 'Return to PI', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '103', 'Tabled', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '104', 'Minor Revisions Required', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '105', 'Withdrawn', 'Y', '50', 'DARKGRAY',  NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '107', 'Major Revisions Required', 'Y', '50', 'DARKGRAY',  NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '108', 'Routing In Progress', 'Y', '50', 'DARKGRAY',  NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '200', 'Active', 'Y', '50', 'DARKGRAY',  NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '201', 'Active - On Hold', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '202', 'Administratively Approved', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '203', 'Administratively Incomplete', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '300', 'IACUC Review Not Required', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '302', 'Administratively Withdrawn', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '303', 'Disapproved', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '304', 'Suspended', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '305', 'Deactivated', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '306', 'Administratively Deactivated', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '307', 'Terminated', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '308', 'Expired', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
INSERT INTO SEQ_WATERMARK_ID VALUES(NULL)
/
INSERT INTO WATERMARK (WATERMARK_ID,GROUP_NAME, STATUS_CODE, WATERMARK_TEXT, WATERMARK_STATUS, FONT_SIZE, FONT_COLOUR, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID, UPDATE_USER, WATERMARK_TYPE, POSITION_FONT, POSITION, ALIGNMENT)
VALUES ((SELECT (MAX(ID)) FROM SEQ_WATERMARK_ID),'IACUC', '309', 'Abandoned', 'Y', '50', 'DARKGRAY', NOW(), 0, UUID(),'admin','TEXT','25','HEADER','CENTER')
/
DELIMITER ;
