/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.core.groups;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.core.groups.GroupsPushService;
import org.kuali.coeus.common.framework.core.groups.GroupsPushStatus;
import org.kuali.coeus.sys.framework.controller.BackLocationAction;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class GroupsPushAction
extends KualiAction
implements BackLocationAction {
    private static final String PUSH_MESSAGE_KEY = "info.group.bulk.push.complete";
    private static final String GROUPS_SERVICE_BULK_PUSH = "GroupServiceBulkPush";
    private static final String PERMISSION_PUSH_UNITS_TO_CORE_GROUPS = "Push Units to the Core Groups Service";
    private transient GroupsPushService groupsPushService;
    private transient GlobalVariableService globalVariableService;
    private transient PermissionService permissionService;

    public ActionForward pushAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String principalId = this.getGlobalVariableService().getUserSession().getPrincipalId();
        boolean isAuthorized = this.getPermissionService().hasPermission(principalId, "KC-IDM", PERMISSION_PUSH_UNITS_TO_CORE_GROUPS);
        if (!isAuthorized) {
            throw new UnauthorizedAccessException("Unauthorized to push units to the core groups service.");
        }
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, GROUPS_SERVICE_BULK_PUSH, "Are you sure you want to push all units to the core groups service", "confirmationQuestion", "cancel", "");
        }
        if (GROUPS_SERVICE_BULK_PUSH.equals(question)) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("0".equals(buttonClicked)) {
                GroupsPushStatus status = this.getGroupsPushService().pushAllGroups();
                this.getGlobalVariableService().getMessageList().add(PUSH_MESSAGE_KEY, new String[]{Integer.toString(status.getNumberOfUnits()), Integer.toString(status.getCategoriesAdded()), Integer.toString(status.getCategoriesUpdated()), Integer.toString(status.getGroupsAdded()), Integer.toString(status.getGroupsUpdated())});
            } else {
                return this.returnToSender(request, mapping, (KualiForm)form);
            }
        }
        return mapping.findForward("basic");
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KcServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public GroupsPushService getGroupsPushService() {
        if (this.groupsPushService == null) {
            this.groupsPushService = KcServiceLocator.getService(GroupsPushService.class);
        }
        return this.groupsPushService;
    }

    public void setGroupsPushService(GroupsPushService groupsPushService) {
        this.groupsPushService = groupsPushService;
    }
}

