/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup.keyvalue;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.bo.NsfCode;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="nsfCodeYearConstrainedFinder")
public class NsfCodeYearConstrainedFinder
extends UifKeyValuesFinderBase {
    private static final String YEAR = "year";
    private static final String NSF_CODE_YEAR = "NSF_CODE_YEAR";
    @Autowired
    @Qualifier(value="businessObjectService")
    private transient BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private transient ParameterService parameterService;

    public List<KeyValue> getKeyValues() {
        return Stream.concat(Stream.of(ValuesFinderUtils.getSelectOption()), this.getBusinessObjectService().findMatching(NsfCode.class, Collections.singletonMap(YEAR, this.getNsfCodeYear())).stream().map(nsfCode -> new ConcreteKeyValue(nsfCode.getNsfSequenceNumber().toString(), nsfCode.getDescription()))).collect(Collectors.toList());
    }

    private Integer getNsfCodeYear() {
        return Integer.valueOf(this.getParameterService().getParameterValueAsString("KC-GEN", "All", NSF_CODE_YEAR));
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

