/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.model;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;

public class ScaleTwoDecimalEditor
extends PropertyEditorSupport
implements Serializable {
    private DecimalFormat numberFormat;
    private boolean allowEmpty;

    public ScaleTwoDecimalEditor(DecimalFormat numberFormat, boolean allowEmpty) {
        this.numberFormat = numberFormat;
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setGroupingSize(3);
        this.allowEmpty = allowEmpty;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && StringUtils.isBlank((CharSequence)text)) {
            this.setValue(null);
        } else if (this.numberFormat != null) {
            try {
                this.setValue(new ScaleTwoDecimal(this.numberFormat.parse(text).toString()));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(text + " is not parsable by the NumberFormat provided(" + this.numberFormat.toString() + ")", e);
            }
        } else {
            this.setValue(new ScaleTwoDecimal(text));
        }
    }

    @Override
    public String getAsText() {
        String strValue = "";
        ScaleTwoDecimal value = this.getValue();
        if (value == null) {
            if (this.numberFormat != null) {
                strValue = this.numberFormat.format(0L);
            }
        } else {
            strValue = this.numberFormat != null ? this.numberFormat.format(value) : value.toString();
        }
        return strValue;
    }

    public ScaleTwoDecimal getValue() {
        Object o = super.getValue();
        return o instanceof ScaleTwoDecimal ? (ScaleTwoDecimal)o : (o != null ? new ScaleTwoDecimal(o.toString()) : null);
    }

    public DecimalFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(DecimalFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }
}

