/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.xmlstream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardTransferringSponsor;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentSchedule;
import org.kuali.kra.award.printing.AwardPrintParameters;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.award.printing.xmlstream.AwardBaseStream;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.printing.schema.AwardNoticeDocument;
import org.kuali.kra.printing.schema.AwardType;
import org.kuali.kra.printing.schema.SpecialReviewType;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;

public class AwardDeltaXmlStream
extends AwardBaseStream {
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private VersionHistoryService versionHistoryService;

    @Override
    public Map<String, AwardNoticeDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, AwardNoticeDocument> xmlObjectList = new LinkedHashMap<String, AwardNoticeDocument>();
        AwardNoticeDocument awardNoticeDocument = (AwardNoticeDocument)AwardNoticeDocument.Factory.newInstance();
        this.initialize((Award)printableBusinessObject, reportParameters);
        if (this.award != null) {
            awardNoticeDocument.setAwardNotice(this.getAwardNotice(reportParameters));
        }
        xmlObjectList.put(AwardPrintType.AWARD_DELTA_REPORT.getAwardPrintType(), awardNoticeDocument);
        return xmlObjectList;
    }

    private void initialize(Award award1, Map<String, Object> reportParameters) {
        this.awardDocument = award1.getAwardDocument();
        this.award = award1;
        String awardNumber = this.getAwardNumberFromAward(this.awardDocument);
        if (awardNumber != null) {
            List<VersionHistory> awardSequenceHistoryList = this.versionHistoryService.loadVersionHistory(Award.class, awardNumber);
            int sequenceNumber = 0;
            int prevSequenceNumber = 0;
            Long transactionId = 0L;
            long prevTransactionId = 0L;
            if (reportParameters.get(SEQUENCE_NUMBER) != null) {
                sequenceNumber = (Integer)reportParameters.get(SEQUENCE_NUMBER);
                this.award = this.getAwardForSeqenceNumber(awardNumber, sequenceNumber);
            }
            if (reportParameters.get(AwardPrintParameters.TRANSACTION_ID_INDEX.getAwardPrintParameter()) != null) {
                int transactionIdx = (Integer)reportParameters.get(AwardPrintParameters.TRANSACTION_ID_INDEX.getAwardPrintParameter());
                if (this.award != null) {
                    this.awardAmountInfo = this.award.getAwardAmountInfos().get(transactionIdx);
                    transactionId = this.awardAmountInfo.getTransactionId();
                }
            }
            boolean sequenceNumberFound = false;
            for (VersionHistory versionHistory : awardSequenceHistoryList) {
                if (sequenceNumber == versionHistory.getSequenceOwnerSequenceNumber()) {
                    sequenceNumberFound = true;
                }
                if (!sequenceNumberFound) continue;
                prevSequenceNumber = sequenceNumber - 1;
                break;
            }
            if (sequenceNumber != 0) {
                this.award = this.getAwardForSeqenceNumber(awardNumber, sequenceNumber);
            }
            List<AwardAmountTransaction> awardAmountTransactions = this.getAwardAmountTransactions(awardNumber);
            boolean transactionIdFound = false;
            for (AwardAmountTransaction timeAndMoneyActionSummary : awardAmountTransactions) {
                if (transactionId != null && transactionId.equals(timeAndMoneyActionSummary.getAwardAmountTransactionId())) {
                    transactionIdFound = true;
                }
                if (!transactionIdFound) continue;
                prevTransactionId = transactionId - 1L;
                break;
            }
            if (prevSequenceNumber != 0) {
                this.initializePrevAward(awardNumber, prevSequenceNumber, prevTransactionId);
            }
        }
    }

    private List<AwardAmountTransaction> getAwardAmountTransactions(String awardNumber) {
        List<AwardAmountTransaction> awardAmountTransactions = new ArrayList<AwardAmountTransaction>();
        HashMap<String, String> timeAndMoneyMap = new HashMap<String, String>();
        timeAndMoneyMap.put("rootAwardNumber", awardNumber);
        List timeAndMoneyList = this.businessObjectService.findMatching(TimeAndMoneyDocument.class, timeAndMoneyMap);
        if (timeAndMoneyList != null && !timeAndMoneyList.isEmpty()) {
            TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)timeAndMoneyList.get(0);
            awardAmountTransactions = timeAndMoneyDocument.getAwardAmountTransactions();
        }
        return awardAmountTransactions;
    }

    private String getAwardNumberFromAward(AwardDocument awardDocument) {
        String awardNumber = null;
        if (awardDocument != null && awardDocument.getAward() != null && awardDocument.getAward().getAwardNumber() != null) {
            awardNumber = awardDocument.getAward().getAwardNumber();
        }
        return awardNumber;
    }

    private void initializePrevAward(String awardNumber, long sequenceNumber, long transactionId) {
        if (transactionId > 1L) {
            this.prevAward = this.award;
            if (this.award != null) {
                this.prevAwardAmountInfo = this.getPrevAwardAmountInfo(this.award, transactionId);
            }
        } else {
            List<AwardAmountInfo> awardAmountInfos;
            this.prevAward = this.getAwardForSeqenceNumber(awardNumber, sequenceNumber);
            if (this.prevAward != null && (awardAmountInfos = this.prevAward.getAwardAmountInfos()) != null && !awardAmountInfos.isEmpty()) {
                this.prevAwardAmountInfo = awardAmountInfos.get(0);
            }
        }
    }

    private AwardAmountInfo getPrevAwardAmountInfo(Award award, long transactionId) {
        AwardAmountInfo awardAmountInfo = null;
        for (AwardAmountInfo awardAmount : award.getAwardAmountInfos()) {
            if (awardAmount.getTransactionId() == null || !awardAmount.getTransactionId().equals(transactionId)) continue;
            awardAmountInfo = awardAmount;
            break;
        }
        return awardAmountInfo;
    }

    private Award getAwardForSeqenceNumber(String awardNumber, long sequenceNumber) {
        Award awardForSeqenceNumber = null;
        HashMap<String, String> awardMap = new HashMap<String, String>();
        awardMap.put("awardNumber", awardNumber);
        awardMap.put(SEQUENCE_NUMBER, String.valueOf(sequenceNumber));
        List awardList = this.businessObjectService.findMatching(Award.class, awardMap);
        if (awardList != null && !awardList.isEmpty()) {
            awardForSeqenceNumber = (Award)awardList.get(0);
        }
        return awardForSeqenceNumber;
    }

    @Override
    protected AwardType getAward() {
        AwardType awardType = super.getAward();
        awardType.setAwardTransferringSponsors(this.getAwardTransferringSponsors());
        awardType.setAwardPaymentSchedules(this.getAwardPaymentSchedules());
        awardType.setAwardSpecialReviews(this.getAwardSpecialReviews());
        awardType.setAwardOtherDatas(this.getAwardOtherDatas());
        return awardType;
    }

    private AwardType.AwardSpecialReviews getAwardSpecialReviews() {
        AwardType.AwardSpecialReviews awardSpecialReviews = (AwardType.AwardSpecialReviews)AwardType.AwardSpecialReviews.Factory.newInstance();
        String specialReviewIndicator = this.award.getSpecialReviewIndicator();
        LinkedList<SpecialReviewType> specialReviewTypesList = new LinkedList<SpecialReviewType>();
        if (specialReviewIndicator != null && !specialReviewIndicator.equals("")) {
            String string = specialReviewIndicator = specialReviewIndicator.length() == 1 ? specialReviewIndicator : specialReviewIndicator.substring(1, 2);
            if (specialReviewIndicator.equals("1")) {
                List<AwardSpecialReview> specialReviewList = this.award.getSpecialReviews();
                for (AwardSpecialReview awardSpecialReview : specialReviewList) {
                    SpecialReviewType specialReviewType = this.getAwardSpecialReview(awardSpecialReview);
                    specialReviewTypesList.add(specialReviewType);
                }
            }
        }
        awardSpecialReviews.setSpecialReviewArray(specialReviewTypesList.toArray(new SpecialReviewType[0]));
        return awardSpecialReviews;
    }

    private AwardType.AwardPaymentSchedules getAwardPaymentSchedules() {
        AwardType.AwardPaymentSchedules awardPaymentSchedules = (AwardType.AwardPaymentSchedules)AwardType.AwardPaymentSchedules.Factory.newInstance();
        String paymentScheduleIndicator = this.award.getPaymentScheduleIndicator();
        LinkedList<AwardType.AwardPaymentSchedules.PaymentSchedule> paymentSchedulesList = new LinkedList<AwardType.AwardPaymentSchedules.PaymentSchedule>();
        if (paymentScheduleIndicator != null && !paymentScheduleIndicator.equals("")) {
            String string = paymentScheduleIndicator = paymentScheduleIndicator.length() == 1 ? paymentScheduleIndicator : paymentScheduleIndicator.substring(1, 2);
            if (paymentScheduleIndicator.equals("1")) {
                List<AwardPaymentSchedule> paymentScheduleItems = this.award.getPaymentScheduleItems();
                for (AwardPaymentSchedule awardPaymentSchedule : paymentScheduleItems) {
                    AwardType.AwardPaymentSchedules.PaymentSchedule paymentSchedule = this.getAwardPaymentSchedule(awardPaymentSchedule);
                    paymentSchedulesList.add(paymentSchedule);
                }
            }
        }
        awardPaymentSchedules.setPaymentScheduleArray(paymentSchedulesList.toArray(new AwardType.AwardPaymentSchedules.PaymentSchedule[0]));
        return awardPaymentSchedules;
    }

    private AwardType.AwardTransferringSponsors getAwardTransferringSponsors() {
        AwardType.AwardTransferringSponsors.TransferringSponsor transferringSponsor;
        AwardType.AwardTransferringSponsors transferringSponsors = (AwardType.AwardTransferringSponsors)AwardType.AwardTransferringSponsors.Factory.newInstance();
        LinkedList<AwardType.AwardTransferringSponsors.TransferringSponsor> transferringSponsorList = new LinkedList<AwardType.AwardTransferringSponsors.TransferringSponsor>();
        List<AwardTransferringSponsor> awardTransferringSponsorList = this.award.getAwardTransferringSponsors();
        List<Object> prevTransferringSponsorList = this.prevAward == null ? new ArrayList() : this.prevAward.getAwardTransferringSponsors();
        for (AwardTransferringSponsor awardTransferringSponsor : awardTransferringSponsorList) {
            transferringSponsor = this.checkSponsorCodeChange(awardTransferringSponsor, prevTransferringSponsorList) ? this.getAwardTransferringSponsor(awardTransferringSponsor) : this.getAwardTransferringSponsor(awardTransferringSponsor, "ADDED - ");
            transferringSponsorList.add(transferringSponsor);
        }
        for (AwardTransferringSponsor awardTransferringSponsor : prevTransferringSponsorList) {
            if (this.checkSponsorCodeChange(awardTransferringSponsor, awardTransferringSponsorList)) continue;
            transferringSponsor = this.getAwardTransferringSponsor(awardTransferringSponsor, "DELETED - ");
            transferringSponsorList.add(transferringSponsor);
        }
        transferringSponsors.setTransferringSponsorArray(transferringSponsorList.toArray(new AwardType.AwardTransferringSponsors.TransferringSponsor[0]));
        return transferringSponsors;
    }

    private boolean checkSponsorCodeChange(AwardTransferringSponsor awardTransferringSponsor, List<AwardTransferringSponsor> awardTransferringSponsors) {
        for (AwardTransferringSponsor currentAwardTransferringSponsor : awardTransferringSponsors) {
            if (!awardTransferringSponsor.getSponsorCode().equals(currentAwardTransferringSponsor.getSponsorCode())) continue;
            return true;
        }
        return false;
    }

    protected AwardType.AwardTransferringSponsors.TransferringSponsor getAwardTransferringSponsor(AwardTransferringSponsor awardTransferringSponsor, String prefix) {
        AwardType.AwardTransferringSponsors.TransferringSponsor transferringSponsor = (AwardType.AwardTransferringSponsors.TransferringSponsor)AwardType.AwardTransferringSponsors.TransferringSponsor.Factory.newInstance();
        if (awardTransferringSponsor.getAwardNumber() != null) {
            transferringSponsor.setAwardNumber(awardTransferringSponsor.getAwardNumber());
        }
        if (awardTransferringSponsor.getSequenceNumber() != null) {
            transferringSponsor.setSequenceNumber(awardTransferringSponsor.getSequenceNumber());
        }
        transferringSponsor.setSponsorCode(prefix + awardTransferringSponsor.getSponsorCode());
        Sponsor sponsor = awardTransferringSponsor.getSponsor();
        if (sponsor != null && sponsor.getSponsorName() != null) {
            transferringSponsor.setSponsorDescription(sponsor.getSponsorName());
        }
        return transferringSponsor;
    }

    private AwardType.AwardOtherDatas getAwardOtherDatas() {
        AwardType.AwardOtherDatas awardOtherDatas = (AwardType.AwardOtherDatas)AwardType.AwardOtherDatas.Factory.newInstance();
        List<AwardCustomData> awardCustomDataList = this.award.getAwardCustomDataList();
        ArrayList<AwardType.AwardOtherDatas.OtherData> otherDatas = new ArrayList<AwardType.AwardOtherDatas.OtherData>();
        int count = 0;
        for (AwardCustomData awardCustomData : awardCustomDataList) {
            AwardType.AwardOtherDatas.OtherData otherData = (AwardType.AwardOtherDatas.OtherData)AwardType.AwardOtherDatas.OtherData.Factory.newInstance();
            String columnValue = awardCustomData.getValue();
            if (awardCustomData.getCustomAttribute() != null && awardCustomData.getCustomAttribute().getName() != null) {
                otherData.setColumnName(awardCustomData.getCustomAttribute().getName());
            }
            if (columnValue != null) {
                if (this.prevAward != null && !this.prevAward.getAwardCustomDataList().isEmpty()) {
                    String prevColumValue = this.prevAward.getAwardCustomDataList().get(count).getValue();
                    columnValue = this.getModColumValue(columnValue, prevColumValue);
                }
                otherData.setColumnValue(columnValue);
            }
            otherDatas.add(otherData);
            ++count;
        }
        awardOtherDatas.setOtherDataArray(otherDatas.toArray(new AwardType.AwardOtherDatas.OtherData[0]));
        return awardOtherDatas;
    }

    private String getModColumValue(String columnValue, String prevColumValue) {
        String columnValueMod = null;
        if (columnValue != null) {
            columnValueMod = prevColumValue == null || !columnValue.equals(prevColumValue) ? "* " + columnValue : columnValue;
        }
        return columnValueMod;
    }

    @Override
    protected AwardNoticeDocument.AwardNotice.PrintRequirement getPrintRequirement(Map<String, Object> reportParameters) {
        AwardNoticeDocument.AwardNotice.PrintRequirement printRequirement = (AwardNoticeDocument.AwardNotice.PrintRequirement)AwardNoticeDocument.AwardNotice.PrintRequirement.Factory.newInstance();
        if (reportParameters != null) {
            printRequirement.setAddressListRequired("1");
            printRequirement.setCloseoutRequired("1");
            printRequirement.setCommentsRequired("1");
            printRequirement.setCostSharingRequired("1");
            printRequirement.setEquipmentRequired("1");
            printRequirement.setFlowThruRequired("1");
            printRequirement.setForeignTravelRequired("1");
            printRequirement.setHierarchyInfoRequired("1");
            printRequirement.setIndirectCostRequired("1");
            printRequirement.setPaymentRequired("1");
            printRequirement.setProposalDueRequired("1");
            printRequirement.setSubcontractRequired("1");
            printRequirement.setScienceCodeRequired("1");
            printRequirement.setSpecialReviewRequired("1");
            printRequirement.setTermsRequired("1");
            printRequirement.setTechnicalReportingRequired("1");
            printRequirement.setReportingRequired("1");
            printRequirement.setCurrentDate(this.dateTimeService.getCurrentCalendar());
            printRequirement.setSignatureRequired(this.getSignatureRequired(reportParameters));
        }
        return printRequirement;
    }

    private String getSignatureRequired(Map<String, Object> reportParameters) {
        String signatureRequired = reportParameters.get("signatureRequired") != null && (Boolean)reportParameters.get("signatureRequired") != false ? "1" : "0";
        return signatureRequired;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }
}

