/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.sponsor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.kuali.coeus.propdev.api.core.SubmissionInfoService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalTypeService;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunityCfda;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentSponsorProgramInformationAuditRule
implements DocumentAuditRule {
    private ParameterService parameterService;
    private SubmissionInfoService submissionInfoService;
    private ProposalTypeService proposalTypeService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal proposal = proposalDevelopmentDocument.getDevelopmentProposal();
        if (proposal.getDeadlineDate() == null) {
            valid = false;
            this.getAuditErrors("Sponsor & Program Info", "Warnings").add(new AuditError("document.developmentProposal.deadlineDate", "warning.empty.deadline.date", "PropDev-SponsorProgramInfoPage"));
        } else if (this.isDeadlineDateBeforeCurrentDate(proposal)) {
            valid = false;
            this.getAuditErrors("Sponsor & Program Info", "Warnings").add(new AuditError("document.developmentProposal.deadlineDate", "warning.past.deadline.date", "PropDev-SponsorProgramInfoPage"));
        }
        if (proposal.hasS2sOpportunity()) {
            String federalIdComesFromAwardStr;
            if (proposal.getS2sOpportunity().getOpportunityId() != null && proposal.getProgramAnnouncementNumber() != null && !StringUtils.equalsIgnoreCase((CharSequence)proposal.getS2sOpportunity().getOpportunityId(), (CharSequence)proposal.getProgramAnnouncementNumber())) {
                valid = false;
                this.getAuditErrors("Sponsor & Program Info", "Error").add(new AuditError("document.developmentProposal.programAnnouncementNumber", "error.opportunityId.differ", "PropDev-SponsorProgramInfoPage"));
            }
            if (CollectionUtils.isNotEmpty(proposal.getS2sOpportunity().getS2sOpportunityCfdas()) && CollectionUtils.isNotEmpty(proposal.getProposalCfdas()) && !CollectionUtils.isEqualCollection((Collection)proposal.getS2sOpportunity().getS2sOpportunityCfdas().stream().map(S2sOpportunityCfda::getCfdaNumber).collect(Collectors.toList()), (Collection)proposal.getProposalCfdas().stream().map(ProposalCfda::getCfdaNumber).collect(Collectors.toList()))) {
                valid = false;
                IntStream.range(0, proposal.getProposalCfdas().size()).forEach(i -> this.getAuditErrors("Sponsor & Program Info", "Error").add(new AuditError(String.format("document.developmentProposal.proposalCfdas[%s].cfdaNumber", i), "error.cfdaNumber.differ", "PropDev-SponsorProgramInfoPage")));
            }
            if (proposal.getProgramAnnouncementTitle() == null || StringUtils.equalsIgnoreCase((CharSequence)proposal.getProgramAnnouncementTitle().trim(), (CharSequence)"")) {
                valid = false;
                this.getAuditErrors("Sponsor & Program Info", "Error").add(new AuditError("document.developmentProposal.programAnnouncementTitle", "error.opportunityTitle.deleted", "PropDev-SponsorProgramInfoPage"));
            }
            if (proposal.isSponsorProgramAndDivCodeRequired()) {
                if (StringUtils.isEmpty((CharSequence)proposal.getAgencyDivisionCode())) {
                    valid = false;
                    this.getAuditErrors("Sponsor & Program Info", "Error").add(new AuditError("document.developmentProposal.agencyDivisionCode", "error.required.divisionCode", "PropDev-SponsorProgramInfoPage", new String[]{proposal.getSponsorName()}));
                }
                if (StringUtils.isEmpty((CharSequence)proposal.getAgencyProgramCode())) {
                    this.getAuditErrors("Sponsor & Program Info", "Error").add(new AuditError("document.developmentProposal.agencyProgramCode", "error.required.programCode", "PropDev-SponsorProgramInfoPage", new String[]{proposal.getSponsorName()}));
                }
            }
            if (StringUtils.equals((CharSequence)proposal.getS2sOpportunity().getS2sSubmissionTypeCode(), (CharSequence)"3") && StringUtils.equals((CharSequence)proposal.getProposalTypeCode(), (CharSequence)this.getProposalTypeService().getNewProposalTypeCode()) && StringUtils.isEmpty((CharSequence)proposal.getPrevGrantsGovTrackingID())) {
                this.getAuditErrors("Sponsor & Program Info", "Error").add(new AuditError("document.developmentProposal.prevGrantsGovTrackingID", "error.ggtrackingid.required", "PropDev-SponsorProgramInfoPage"));
                valid = false;
            }
            try {
                federalIdComesFromAwardStr = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "FEDERAL_ID_COMES_FROM_CURRENT_AWARD");
            }
            catch (Exception e) {
                throw new RuntimeException("error retrieving FEDERAL_ID_COMES_FROM_CURRENT_AWARD parameter", e);
            }
            boolean federalIdComesFromAward = federalIdComesFromAwardStr != null && federalIdComesFromAwardStr.equalsIgnoreCase("Y");
            String sponsorAwardNumber = null;
            if (StringUtils.isNotBlank((CharSequence)proposal.getCurrentAwardNumber())) {
                sponsorAwardNumber = this.getSubmissionInfoService().getProposalCurrentAwardSponsorAwardNumber(proposal.getCurrentAwardNumber());
            }
            if (!(!this.getProposalTypeService().isProposalTypeRenewalRevisionContinuation(proposal.getProposalTypeCode()) || StringUtils.isNotBlank((CharSequence)proposal.getSponsorProposalNumber()) || StringUtils.isNotBlank((CharSequence)sponsorAwardNumber) && federalIdComesFromAward)) {
                valid = false;
                this.getAuditErrors("Sponsor & Program Info", "Error").add(new AuditError("document.developmentProposal.sponsorProposalNumber", "error.proposal.require.priorAward", "PropDev-SponsorProgramInfoPage"));
            }
            String sponsorProposalNumber = null;
            if (StringUtils.isNotBlank((CharSequence)proposal.getContinuedFrom())) {
                sponsorProposalNumber = this.getSubmissionInfoService().getProposalContinuedFromVersionSponsorProposalNumber(proposal.getContinuedFrom());
            }
            if (this.isProposalTypeResubmission(proposal.getProposalTypeCode()) && StringUtils.isBlank((CharSequence)proposal.getSponsorProposalNumber()) && StringUtils.isBlank((CharSequence)sponsorProposalNumber)) {
                valid = false;
                this.getAuditErrors("Sponsor & Program Info", "Error").add(new AuditError("document.developmentProposal.sponsorProposalNumber", "error.proposal.require.priorAwardResubmit", "PropDev-SponsorProgramInfoPage"));
            }
        }
        for (int i2 = 0; i2 < proposalDevelopmentDocument.getDevelopmentProposal().getProposalCfdas().size(); ++i2) {
            String cfdaNumber = proposalDevelopmentDocument.getDevelopmentProposal().getProposalCfdas().get(i2).getCfdaNumber();
            if (!StringUtils.isNotBlank((CharSequence)cfdaNumber) || cfdaNumber.matches("(\\d{2})(\\.)(\\d{3})[a-zA-z]?")) continue;
            this.getAuditErrors("Sponsor & Program Info", "Warnings").add(new AuditError(String.format("document.developmentProposal.proposalCfdas[%s].cfdaNumber", i2), "error.format.cfda", "PropDev-SponsorProgramInfoPage", new String[]{cfdaNumber}));
            valid = true;
        }
        return valid;
    }

    protected boolean isDeadlineDateBeforeCurrentDate(DevelopmentProposal proposal) {
        DateTime deadlineDate = new DateTime((Object)proposal.getDeadlineDate());
        DateTime currentDate = new DateTime();
        return DateTimeComparator.getDateOnlyInstance().compare((Object)currentDate, (Object)deadlineDate) > 0;
    }

    private boolean isProposalTypeResubmission(String proposalTypeCode) {
        return !StringUtils.isEmpty((CharSequence)proposalTypeCode) && proposalTypeCode.equals(this.getProposalTypeService().getResubmissionProposalTypeCode());
    }

    private List<AuditError> getAuditErrors(String clusterKey, String severity) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!GlobalVariables.getAuditErrorMap().containsKey(clusterKey + severity)) {
            GlobalVariables.getAuditErrorMap().put(clusterKey + severity, new AuditCluster(clusterKey, auditErrors, severity));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(clusterKey + severity)).getAuditErrorList();
        }
        return auditErrors;
    }

    protected SubmissionInfoService getSubmissionInfoService() {
        if (this.submissionInfoService == null) {
            this.submissionInfoService = KcServiceLocator.getService(SubmissionInfoService.class);
        }
        return this.submissionInfoService;
    }

    public void setSubmissionInfoService(SubmissionInfoService submissionInfoService) {
        this.submissionInfoService = submissionInfoService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ProposalTypeService getProposalTypeService() {
        if (this.proposalTypeService == null) {
            this.proposalTypeService = KcServiceLocator.getService(ProposalTypeService.class);
        }
        return this.proposalTypeService;
    }

    public void setProposalTypeService(ProposalTypeService proposalTypeService) {
        this.proposalTypeService = proposalTypeService;
    }
}

