/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.finance.timeAndMoney.dao.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.award.finance.timeAndMoney.TimeAndMoneyPosts;
import org.kuali.coeus.award.finance.timeAndMoney.dao.TimeAndMoneyPostsDao;
import org.kuali.kra.award.home.AwardService;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="timeAndMoneyPostsDao")
public class TimeAndMoneyPostsDaoJpa
implements TimeAndMoneyPostsDao {
    public static final String DOCUMENT_NUMBER = "documentNumber";
    public static final String AWARD_FAMILY = "awardFamily";
    public static final String UPDATE_TIMESTAMP = "updateTimestamp";
    public static final String ACTIVE = "active";
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    @Override
    public TimeAndMoneyPosts getTimeAndMoneyPostsByDocumentNumber(String documentNumber) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put(DOCUMENT_NUMBER, documentNumber);
        return (TimeAndMoneyPosts)this.dataObjectService.findUnique(TimeAndMoneyPosts.class, QueryByCriteria.Builder.andAttributes(keys).build());
    }

    @Override
    public List<TimeAndMoneyPosts> getActiveTimeAndMoneyPosts() {
        HashMap<String, Boolean> keys = new HashMap<String, Boolean>();
        keys.put(ACTIVE, true);
        return this.dataObjectService.findMatching(TimeAndMoneyPosts.class, QueryByCriteria.Builder.andAttributes(keys).build()).getResults();
    }

    @Override
    public List<TimeAndMoneyPosts> getActiveTimeAndMoneyPostsForAwardHierarchy(String awardNumber) {
        String awardFamily = AwardService.getAwardFamily(awardNumber);
        HashMap<String, Object> keys = new HashMap<String, Object>();
        keys.put(ACTIVE, true);
        keys.put(AWARD_FAMILY, awardFamily);
        ArrayList<OrderByField> orderByFields = new ArrayList<OrderByField>();
        orderByFields.add(OrderByField.Builder.create((String)UPDATE_TIMESTAMP, (OrderDirection)OrderDirection.DESCENDING).build());
        return this.dataObjectService.findMatching(TimeAndMoneyPosts.class, QueryByCriteria.Builder.andAttributes(keys).setOrderByFields(orderByFields).build()).getResults();
    }

    @Override
    public TimeAndMoneyPosts getTimeAndMoneyPost(Long id) {
        return (TimeAndMoneyPosts)this.dataObjectService.find(TimeAndMoneyPosts.class, (Object)id);
    }
}

