/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.person.PersonRolodexComparator;
import org.kuali.coeus.common.framework.person.attr.DegreeType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.AddKeyPersonRule;
import org.kuali.coeus.propdev.impl.person.ChangeKeyPersonRule;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelService;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonDegree;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.creditsplit.CalculateCreditSplitRule;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalPersonCreditSplit;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalUnitCreditSplit;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentKeyPersonsRule
extends KcTransactionalDocumentRuleBase
implements AddKeyPersonRule,
ChangeKeyPersonRule,
CalculateCreditSplitRule {
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentKeyPersonsRule.class);
    private static final String ADD_KEY_PERSON_HELPER_PARAMETER_MAP_KEY_PERSON_PROJECT_ROLE = "addKeyPersonHelper.parameterMap['keyPersonProjectRole']";
    private static final String ADD_KEY_PERSON_HELPER_PARAMETER_MAP_PERSON_ROLE = "addKeyPersonHelper.parameterMap['personRole']";
    private static final String KEY_PERSON_S_ROLE = "Key Person's Role";
    private static final String ROLE = "Role";
    private KcPersonService kcPersonService;

    public boolean processCustomSaveDocumentBusinessRules(Document document) {
        return this.processSaveKeyPersonBusinessRules((ProposalDevelopmentDocument)document);
    }

    public boolean processSaveKeyPersonBusinessRules(ProposalDevelopmentDocument document) {
        LOG.debug("Processing Key Personnel Save Document Rule");
        boolean retval = true;
        int pi_cnt = 0;
        int personIndex = 0;
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            if (person.isPrincipalInvestigator()) {
                ++pi_cnt;
            }
            if (StringUtils.isBlank((CharSequence)person.getProposalPersonRoleId()) && person.getRole() == null) {
                LOG.debug("error.missingPersonRole");
                this.reportError("document.developmentProposalList[0].proposalPersons[" + personIndex + "]", "error.missingPersonRole", new String[0]);
            }
            ++personIndex;
        }
        if (pi_cnt > 1) {
            retval = false;
            this.reportError("newProposalPerson", "error.principalInvestigators.upbound", document.getDevelopmentProposal().getPrincipalInvestigator().getRole().getDescription());
        }
        personIndex = 0;
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            if (person.isCoInvestigator() && person.getUnits() != null && person.getUnits().size() == 0) {
                this.reportError("newProposalPersonUnit[" + personIndex + "].unitNumber", "error.one.unit", person.getFullName());
                retval = false;
            }
            if (person.isKeyPerson() && person.getOptInUnitStatus().booleanValue() && person.getUnits() != null && person.getUnits().size() == 0) {
                this.reportError("newProposalPersonUnit[" + personIndex + "].unitNumber", "error.one.unit", person.getFullName());
                retval = false;
            }
            if (person.isKeyPerson() && StringUtils.isBlank((CharSequence)person.getProjectRole())) {
                this.reportError("document.developmentProposalList[0].proposalPersons[" + personIndex + "].projectRole", "error.required", "Key Person Role");
            }
            if (person.getPercentageEffort() != null && (person.getPercentageEffort().isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO) || person.getPercentageEffort().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100)))) {
                GlobalVariables.getMessageMap().putError("document.developmentProposalList[0].proposalPersons[" + personIndex + "].percentageEffort", "error.percentage", new String[]{"Percentage Effort"});
            }
            ++personIndex;
        }
        if (retval &= this.processCalculateCreditSplitBusinessRules(document)) {
            boolean leadunit = false;
            ProposalPersonUnit unit = null;
            for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
                if (person.getProposalPersonRoleId().equals("PI")) {
                    for (ProposalPersonUnit personunit : person.getUnits()) {
                        if (!personunit.isLeadUnit()) continue;
                        leadunit = true;
                    }
                    if (!leadunit) {
                        this.getKeyPersonnelService().assignLeadUnit(person, document.getDevelopmentProposal().getOwnedByUnitNumber());
                    }
                    leadunit = false;
                    continue;
                }
                if (!person.getProposalPersonRoleId().equals("COI")) continue;
                for (ProposalPersonUnit personunit : person.getUnits()) {
                    if (!personunit.isLeadUnit() || !StringUtils.isNotBlank((CharSequence)person.getHomeUnit()) || person.getHomeUnit().equals(document.getDevelopmentProposal().getOwnedByUnitNumber())) continue;
                    leadunit = true;
                    personunit.setLeadUnit(false);
                    unit = person.getUnit(personunit.getUnitNumber());
                }
                if (!leadunit || unit == null) continue;
                person.getUnits().remove(unit);
            }
            document.getDevelopmentProposal().getProposalPersons().sort(PersonRolodexComparator.INSTANCE);
        }
        return retval;
    }

    @Override
    public boolean processAddKeyPersonBusinessRules(ProposalDevelopmentDocument document, ProposalPerson person) {
        if (StringUtils.isBlank((CharSequence)person.getProposalPersonRoleId())) {
            this.reportError(ADD_KEY_PERSON_HELPER_PARAMETER_MAP_PERSON_ROLE, "error.required", ROLE);
            return false;
        }
        if ("KP".equals(person.getProposalPersonRoleId()) && StringUtils.isEmpty((CharSequence)person.getProjectRole())) {
            this.reportError(ADD_KEY_PERSON_HELPER_PARAMETER_MAP_KEY_PERSON_PROJECT_ROLE, "error.required", KEY_PERSON_S_ROLE);
            return false;
        }
        return true;
    }

    private KeyPersonnelService getKeyPersonnelService() {
        return KcServiceLocator.getService(KeyPersonnelService.class);
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    @Override
    public boolean processChangeKeyPersonBusinessRules(ProposalPerson proposalPerson, BusinessObject source, int index) {
        boolean retval = true;
        if (source instanceof ProposalPersonDegree) {
            retval &= this.validateDegree((ProposalPersonDegree)source, index);
        } else if (source instanceof ProposalPersonUnit) {
            retval &= this.validateUnit((ProposalPersonUnit)source, proposalPerson, index);
        }
        return retval;
    }

    private boolean validateUnit(ProposalPersonUnit source, ProposalPerson person, int index) {
        boolean retval = true;
        if (source == null) {
            LOG.debug("validated null unit");
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating unit " + String.valueOf(source));
        }
        if (source.getUnit() == null && StringUtils.isBlank((CharSequence)source.getUnitNumber()) && GlobalVariables.getMessageMap().getMessages("newProposalPersonUnit*") == null) {
            GlobalVariables.getMessageMap().putError("newProposalPersonUnit[" + index + "].unitNumber", "error.select.unit", new String[0]);
            retval = false;
        }
        if (StringUtils.isNotBlank((CharSequence)source.getUnitNumber()) && this.isInvalid(Unit.class, this.keyValue("unitNumber", source.getUnitNumber())) && GlobalVariables.getMessageMap().getMessages("newProposalPersonUnit*") == null) {
            GlobalVariables.getMessageMap().putError("newProposalPersonUnit[" + index + "].unitNumber", "error.invalid.unit", new String[]{source.getUnitNumber(), person.getFullName()});
            retval = false;
        }
        LOG.debug("isLeadUnit " + source.isLeadUnit());
        if (source.isDelete()) {
            if (person.getProposalPersonRoleId().equals("PI") && this.isDeletingUnitFromPrincipalInvestigator(source, person) && GlobalVariables.getMessageMap().getMessages("newProposalPersonUnit*") == null) {
                GlobalVariables.getMessageMap().putError("newProposalPersonUnit[" + index + "].unitNumber", "error.deleteLeadUnit", new String[]{source.getUnitNumber(), person.getFullName()});
                retval = false;
            }
        } else if (this.unitExists(source, person) && GlobalVariables.getMessageMap().getMessages("newProposalPersonUnit*") == null) {
            GlobalVariables.getMessageMap().putError("newProposalPersonUnit[" + index + "].unitNumber", "error.addExistingUnit", new String[]{source.getUnitNumber(), person.getFullName()});
            retval = false;
        }
        LOG.debug("validateUnit = " + retval);
        return retval;
    }

    private boolean unitExists(ProposalPersonUnit source, ProposalPerson person) {
        for (ProposalPersonUnit unit : person.getUnits()) {
            if (!unit.getUnitNumber().equals(source.getUnitNumber())) continue;
            return true;
        }
        return false;
    }

    private boolean isDeletingUnitFromPrincipalInvestigator(ProposalPersonUnit unit, ProposalPerson person) {
        boolean retval = false;
        LOG.debug("Person " + person.getProposalPersonNumber() + " has unit " + unit.getUnitNumber());
        return retval && unit.isDelete() && unit.isLeadUnit() && person.isPrincipalInvestigator();
    }

    private boolean validateDegree(ProposalPersonDegree source, int index) {
        boolean retval = true;
        String regExpr = "^(16|17|18|19|20)[0-9]{2}$";
        if (source.getGraduationYear() != null && !source.getGraduationYear().matches(regExpr) && GlobalVariables.getMessageMap().getMessages("document.newProposalPersonDegree") == null) {
            GlobalVariables.getMessageMap().putError("newProposalPersonDegree[" + index + "].graduationYear", "error.invalid.year", new String[]{source.getGraduationYear(), "Graduation Year"});
            retval = false;
        }
        if (StringUtils.isNotBlank((CharSequence)source.getDegreeCode()) && this.isInvalid(DegreeType.class, this.keyValue("code", source.getDegreeCode()))) {
            retval = false;
        }
        if (StringUtils.isBlank((CharSequence)source.getDegreeCode())) {
            GlobalVariables.getMessageMap().putError("newProposalPersonDegree[" + index + "].degreeCode", "error.required", new String[]{"Degree Type"});
            retval = false;
        }
        if (StringUtils.isBlank((CharSequence)source.getDegree())) {
            GlobalVariables.getMessageMap().putError("newProposalPersonDegree[" + index + "].degree", "error.required", new String[]{"Degree Description"});
            retval = false;
        }
        if (StringUtils.isBlank((CharSequence)source.getGraduationYear())) {
            GlobalVariables.getMessageMap().putError("newProposalPersonDegree[" + index + "].graduationYear", "error.required", new String[]{"Graduation year"});
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean processCalculateCreditSplitBusinessRules(ProposalDevelopmentDocument document) {
        List<ProposalPerson> person = document.getDevelopmentProposal().getInvestigators();
        boolean retval = true;
        for (int i = 0; i < person.size(); ++i) {
            int j;
            ProposalPerson propPerson = person.get(i);
            List<ProposalPersonCreditSplit> personCreditSplit = propPerson.getCreditSplits();
            List<ProposalPersonUnit> propUnitCreditSplit = propPerson.getUnits();
            for (j = 0; j < personCreditSplit.size(); ++j) {
                ProposalPersonCreditSplit creditSplit = personCreditSplit.get(j);
                if (creditSplit.getCredit() == null || !(creditSplit.getCredit().doubleValue() > 100.0) && !(creditSplit.getCredit().doubleValue() < 0.0)) continue;
                GlobalVariables.getMessageMap().putError("document.developmentProposalList[0].investigator[" + i + "].creditSplits[" + j + "].credit", "error.percentage", new String[]{"Credit Split"});
                retval = false;
            }
            for (j = 0; j < propUnitCreditSplit.size(); ++j) {
                List<ProposalUnitCreditSplit> unitCreditSplit = propUnitCreditSplit.get(j).getCreditSplits();
                for (int k = 0; k < unitCreditSplit.size(); ++k) {
                    ProposalUnitCreditSplit unitSplit = unitCreditSplit.get(k);
                    if (unitSplit.getCredit() == null || !(unitSplit.getCredit().doubleValue() > 100.0) && !(unitSplit.getCredit().doubleValue() < 0.0)) continue;
                    GlobalVariables.getMessageMap().putError("document.developmentProposalList[0].investigator[" + i + "].units[" + j + "].creditSplits[" + k + "].credit", "error.percentage", new String[]{"Credit Split"});
                    retval = false;
                }
            }
            ++i;
        }
        return retval;
    }
}

