/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.questionnaire;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireUsage;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.questionnaire.ProposalDevelopmentModuleQuestionnaireBean;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;

public class ProposalDevelopmentQuestionnaireAuditRule
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private transient QuestionnaireAnswerService questionnaireAnswerService;
    private transient GlobalVariableService globalVariableService;

    protected QuestionnaireUsage getQuestionnaireUsage(String moduleItemCode, String moduleSubItemCode, List<QuestionnaireUsage> questionnaireUsages) {
        QuestionnaireUsage usage = null;
        int version = 0;
        for (QuestionnaireUsage questionnaireUsage : questionnaireUsages) {
            if (!moduleItemCode.equals(questionnaireUsage.getModuleItemCode()) || !moduleSubItemCode.equals(questionnaireUsage.getModuleSubItemCode()) || questionnaireUsage.getQuestionnaireSequenceNumber() <= version) continue;
            version = questionnaireUsage.getQuestionnaireSequenceNumber();
            usage = questionnaireUsage;
        }
        return usage;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        ProposalDevelopmentModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalDevelopmentModuleQuestionnaireBean(proposalDevelopmentDocument.getDevelopmentProposal());
        List<AnswerHeader> headers = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean);
        for (AnswerHeader answerHeader : headers) {
            QuestionnaireUsage usage = this.getQuestionnaireUsage(moduleQuestionnaireBean.getModuleItemCode(), moduleQuestionnaireBean.getModuleSubItemCode(), answerHeader.getQuestionnaire().getQuestionnaireUsages());
            if (answerHeader.isCompleted() || !usage.isMandatory()) continue;
            valid = false;
            this.getAuditErrors(answerHeader.getLabel()).add(new AuditError("PropDev-QuestionnairePage-" + StringUtils.removePattern((String)answerHeader.getLabel(), (String)"([^0-9a-zA-Z\\-_])"), "error.proposaldev.questionnaire.notcomplete", "PropDev-QuestionnairePage.PropDev-QuestionnairePage-" + StringUtils.removePattern((String)answerHeader.getLabel(), (String)"([^0-9a-zA-Z\\-_])"), new String[]{answerHeader.getLabel()}));
        }
        return valid;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        if (this.questionnaireAnswerService == null) {
            this.questionnaireAnswerService = KcServiceLocator.getService(QuestionnaireAnswerService.class);
        }
        return this.questionnaireAnswerService;
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    private List<AuditError> getAuditErrors(String sectionName) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String clusterKey = "Questionnaire." + sectionName;
        if (!this.getGlobalVariableService().getAuditErrorMap().containsKey(clusterKey)) {
            this.getGlobalVariableService().getAuditErrorMap().put(clusterKey, new AuditCluster(clusterKey, auditErrors, "Error"));
        } else {
            auditErrors = this.getGlobalVariableService().getAuditErrorMap().get(clusterKey).getAuditErrorList();
        }
        return auditErrors;
    }
}

