/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.question;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.questionnaire.impl.question.QuestionAuthorizationService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.lookup.keyvalue.LookupReturnValuesFinder;
import org.kuali.rice.kns.lookup.KualiLookupableImpl;
import org.kuali.rice.kns.lookup.LookupableHelperService;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.lookup.LookupUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="questionLookupable")
@Scope(value="prototype")
public class QuestionLookupableImpl
extends KualiLookupableImpl {
    private static final long serialVersionUID = -5431630475561370731L;
    private static final String MAINTENANCE = "maintenance";
    private static final String NEW_MAINTENANCE = "../maintenanceQ";
    private static final String LOOKUP_RETURN = "lookupReturn";
    private static final String LOOKUP_CLASS = "lookupClass";
    @Autowired
    @Qualifier(value="questionAuthorizationService")
    private transient QuestionAuthorizationService questionAuthorizationService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    public String getCreateNewUrl() {
        String url = "";
        if (this.questionAuthorizationService.hasPermission("Modify Question")) {
            url = super.getCreateNewUrl();
            url = url.replace(MAINTENANCE, NEW_MAINTENANCE);
        }
        return url;
    }

    public boolean checkForAdditionalFields(Map fieldValues) {
        String lookupReturnFieldName = (String)fieldValues.get(LOOKUP_RETURN);
        String lookupClassName = (String)fieldValues.get(LOOKUP_CLASS);
        if (StringUtils.isNotBlank((CharSequence)lookupClassName)) {
            for (Row row : this.getRows()) {
                for (Field field : row.getFields()) {
                    if (!field.getPropertyName().equals(LOOKUP_RETURN)) continue;
                    this.globalVariableService.getUserSession().addObject("lookupClassName", (Object)lookupClassName);
                    LookupReturnValuesFinder finder = new LookupReturnValuesFinder();
                    field.setFieldValidValues(finder.getKeyValues());
                    this.globalVariableService.getUserSession().removeObject("lookupReturnFields");
                    this.globalVariableService.getUserSession().removeObject("lookupClassName");
                    if (!StringUtils.isNotBlank((CharSequence)lookupReturnFieldName)) continue;
                    field.setPropertyValue(lookupReturnFieldName);
                    field.setPropertyValue(LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), (String)lookupReturnFieldName, (String)field.getPropertyValue()));
                    fieldValues.put(lookupReturnFieldName, field.getPropertyValue());
                }
            }
        }
        return super.checkForAdditionalFields(fieldValues);
    }

    public void setQuestionAuthorizationService(QuestionAuthorizationService questionAuthorizationService) {
        this.questionAuthorizationService = questionAuthorizationService;
    }

    public QuestionAuthorizationService getQuestionAuthorizationService() {
        return this.questionAuthorizationService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    @Autowired
    @Qualifier(value="questionLookupableHelperService")
    public void setLookupableHelperService(LookupableHelperService lookupableHelperService) {
        super.setLookupableHelperService(lookupableHelperService);
    }
}

