/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.rules;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationActivityAttachment;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.rules.NegotiationActivityAttachmentAddRule;
import org.kuali.kra.negotiations.rules.NegotiationActivityAttachmentAddRuleEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class NegotiationActivityAttachmentRuleImpl
implements NegotiationActivityAttachmentAddRule {
    private final ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);

    @Override
    public boolean processAddAttachmentRule(NegotiationActivityAttachmentAddRuleEvent event) {
        boolean result = true;
        NegotiationDocument document = (NegotiationDocument)event.getDocument();
        Negotiation negotiation = document.getNegotiation();
        NegotiationActivity activity = event.getActivity();
        NegotiationActivityAttachment newAttachment = event.getNewAttachment();
        GlobalVariables.getMessageMap().addToErrorPath(event.getErrorPathPrefix());
        result &= this.validateAttachmentRule(negotiation, activity, newAttachment);
        if (!this.errorReporter.propertyHasErrorReported(GlobalVariables.getMessageMap().getKeyPath("newFile", true)) && StringUtils.isBlank((CharSequence)newAttachment.getNewFile().getFileName())) {
            result = false;
            this.errorReporter.reportError("newFile", "error.required", "File (File)");
        }
        GlobalVariables.getMessageMap().removeFromErrorPath(event.getErrorPathPrefix());
        return result;
    }

    public boolean validateAttachmentRule(Negotiation negotiation, NegotiationActivity activity, NegotiationActivityAttachment attachment) {
        boolean result = true;
        if (!this.errorReporter.propertyHasErrorReported(GlobalVariables.getMessageMap().getKeyPath("description", true)) && StringUtils.isBlank((CharSequence)attachment.getDescription())) {
            result = false;
            this.errorReporter.reportError("description", "error.required", "Description (Description)");
        }
        return result;
    }
}

